/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.memory.HeapMemoryAccessor;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.nio.EnterpriseBufferObjectDataInput;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.EnterpriseSerializationUtil;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.VersionedObjectDataInput;
import com.hazelcast.nio.ObjectDataInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

final class MemoryBlockDataInput
extends VersionedObjectDataInput
implements EnterpriseBufferObjectDataInput {
    private static final int LOWER_BYTE_MASK = 255;
    private static final int LOWER_SHORT_MASK = 65535;
    private MemoryBlock memory;
    private final int size;
    private final int offset;
    private int pos;
    private int mark;
    private final EnterpriseSerializationService service;

    MemoryBlockDataInput(MemoryBlock memoryBlock, int position, int offset, EnterpriseSerializationService serializationService) {
        this.memory = memoryBlock;
        this.size = memoryBlock.size();
        this.service = serializationService;
        this.pos = position;
        this.offset = offset;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void init(byte[] data, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        return this.pos + this.offset < this.size ? (int)this.memory.readByte(this.pos++ + this.offset) : -1;
    }

    @Override
    public int read(int position) throws IOException {
        return position + this.offset < this.size ? (int)this.memory.readByte(position + this.offset) : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len <= 0) {
            return 0;
        }
        if (this.pos + this.offset >= this.size) {
            return -1;
        }
        if (this.pos + this.offset + len > this.size) {
            len = this.size - this.pos;
        }
        this.memCopy(b, HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET + off, len, HeapMemoryAccessor.ARRAY_BYTE_INDEX_SCALE);
        return len;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public boolean readBoolean(int position) throws IOException {
        int ch = this.read(position);
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public byte readByte(int position) throws IOException {
        int ch = this.read(position);
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public char readChar() throws IOException {
        char c = this.readChar(this.pos);
        this.pos += 2;
        return c;
    }

    @Override
    public char readChar(int position) throws IOException {
        try {
            return this.memory.readChar(position + this.offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    @Override
    public double readDouble() throws IOException {
        double d = this.readDouble(this.pos);
        this.pos += 8;
        return d;
    }

    @Override
    public double readDouble(int position) throws IOException {
        try {
            return this.memory.readDouble(position + this.offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    @Override
    public EnterpriseSerializationService getSerializationService() {
        return this.service;
    }

    @Override
    public double readDouble(ByteOrder byteOrder) throws IOException {
        if (byteOrder != ByteOrder.nativeOrder()) {
            return Double.longBitsToDouble(this.readLong(byteOrder));
        }
        return this.readDouble();
    }

    @Override
    public double readDouble(int position, ByteOrder byteOrder) throws IOException {
        if (byteOrder != ByteOrder.nativeOrder()) {
            return Double.longBitsToDouble(this.readLong(position, byteOrder));
        }
        return this.readDouble(position);
    }

    @Override
    public float readFloat() throws IOException {
        float f = this.readFloat(this.pos);
        this.pos += 4;
        return f;
    }

    @Override
    public float readFloat(int position) throws IOException {
        try {
            return this.memory.readFloat(position + this.offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    @Override
    public float readFloat(ByteOrder byteOrder) throws IOException {
        if (byteOrder != ByteOrder.nativeOrder()) {
            return Float.intBitsToFloat(this.readInt(byteOrder));
        }
        return this.readFloat();
    }

    @Override
    public float readFloat(int position, ByteOrder byteOrder) throws IOException {
        if (byteOrder != ByteOrder.nativeOrder()) {
            return Float.intBitsToFloat(this.readInt(position, byteOrder));
        }
        return this.readFloat(position);
    }

    @Override
    public int readInt() throws IOException {
        int i = this.readInt(this.pos);
        this.pos += 4;
        return i;
    }

    @Override
    public int readInt(int position) throws IOException {
        try {
            return this.memory.readInt(position + this.offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int readInt(ByteOrder byteOrder) throws IOException {
        int v = this.readInt();
        if (byteOrder != ByteOrder.nativeOrder()) {
            v = Integer.reverseBytes(v);
        }
        return v;
    }

    @Override
    public int readInt(int position, ByteOrder byteOrder) throws IOException {
        int v = this.readInt(position);
        if (byteOrder != ByteOrder.nativeOrder()) {
            v = Integer.reverseBytes(v);
        }
        return v;
    }

    @Override
    public long readLong() throws IOException {
        long l = this.readLong(this.pos);
        this.pos += 8;
        return l;
    }

    @Override
    public long readLong(int position) throws IOException {
        try {
            return this.memory.readLong(position + this.offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long readLong(ByteOrder byteOrder) throws IOException {
        long v = this.readLong();
        if (byteOrder != ByteOrder.nativeOrder()) {
            v = Long.reverseBytes(v);
        }
        return v;
    }

    @Override
    public long readLong(int position, ByteOrder byteOrder) throws IOException {
        long v = this.readLong(position);
        if (byteOrder != ByteOrder.nativeOrder()) {
            v = Long.reverseBytes(v);
        }
        return v;
    }

    @Override
    public short readShort() throws IOException {
        short s = this.readShort(this.pos);
        this.pos += 2;
        return s;
    }

    @Override
    public short readShort(int position) throws IOException {
        try {
            return this.memory.readShort(position + this.offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    @Override
    public short readShort(ByteOrder byteOrder) throws IOException {
        short v = this.readShort();
        if (byteOrder != ByteOrder.nativeOrder()) {
            v = Short.reverseBytes(v);
        }
        return v;
    }

    @Override
    public short readShort(int position, ByteOrder byteOrder) throws IOException {
        short v = this.readShort(position);
        if (byteOrder != ByteOrder.nativeOrder()) {
            v = Short.reverseBytes(v);
        }
        return v;
    }

    @Override
    public byte[] readByteArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            byte[] b = new byte[len];
            this.readFully(b);
            return b;
        }
        return new byte[0];
    }

    @Override
    public boolean[] readBooleanArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            boolean[] values = new boolean[len];
            this.memCopy(values, HeapMemoryAccessor.ARRAY_BOOLEAN_BASE_OFFSET, len, HeapMemoryAccessor.ARRAY_BOOLEAN_INDEX_SCALE);
            return values;
        }
        return new boolean[0];
    }

    @Override
    public char[] readCharArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            char[] values = new char[len];
            this.memCopy(values, HeapMemoryAccessor.ARRAY_CHAR_BASE_OFFSET, len, HeapMemoryAccessor.ARRAY_CHAR_INDEX_SCALE);
            return values;
        }
        return new char[0];
    }

    @Override
    public int[] readIntArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            int[] values = new int[len];
            this.memCopy(values, HeapMemoryAccessor.ARRAY_INT_BASE_OFFSET, len, HeapMemoryAccessor.ARRAY_INT_INDEX_SCALE);
            return values;
        }
        return new int[0];
    }

    @Override
    public long[] readLongArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            long[] values = new long[len];
            this.memCopy(values, HeapMemoryAccessor.ARRAY_LONG_BASE_OFFSET, len, HeapMemoryAccessor.ARRAY_LONG_INDEX_SCALE);
            return values;
        }
        return new long[0];
    }

    @Override
    public double[] readDoubleArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            double[] values = new double[len];
            this.memCopy(values, HeapMemoryAccessor.ARRAY_DOUBLE_BASE_OFFSET, len, HeapMemoryAccessor.ARRAY_DOUBLE_INDEX_SCALE);
            return values;
        }
        return new double[0];
    }

    @Override
    public float[] readFloatArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            float[] values = new float[len];
            this.memCopy(values, HeapMemoryAccessor.ARRAY_FLOAT_BASE_OFFSET, len, HeapMemoryAccessor.ARRAY_FLOAT_INDEX_SCALE);
            return values;
        }
        return new float[0];
    }

    @Override
    public short[] readShortArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            short[] values = new short[len];
            this.memCopy(values, HeapMemoryAccessor.ARRAY_SHORT_BASE_OFFSET, len, HeapMemoryAccessor.ARRAY_SHORT_INDEX_SCALE);
            return values;
        }
        return new short[0];
    }

    @Override
    public String[] readUTFArray() throws IOException {
        return this.readStringArray();
    }

    @Override
    public String[] readStringArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            String[] values = new String[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readString();
            }
            return values;
        }
        return new String[0];
    }

    @Override
    public <T> T readDataAsObject() throws IOException {
        Data data = this.readData();
        return data == null ? null : (T)this.service.toObject(data);
    }

    private void memCopy(Object dest, long destOffset, int length, int indexScale) throws IOException {
        if (length < 0) {
            throw new NegativeArraySizeException("Destination length is negative: " + length);
        }
        int actualLength = length * indexScale;
        try {
            this.memory.copyTo(this.pos + this.offset, dest, destOffset, actualLength);
            this.pos += actualLength;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        int r = this.read(b);
        if (r != b.length) {
            throw new EOFException();
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int r = this.read(b, off, len);
        if (r != len) {
            throw new EOFException();
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return this.readString();
    }

    @Override
    @Nullable
    public String readString() throws IOException {
        int numberOfBytes = this.readInt();
        if (numberOfBytes == -1) {
            return null;
        }
        byte[] utf8Bytes = new byte[numberOfBytes];
        this.memory.copyToByteArray(this.pos + this.offset, utf8Bytes, 0, numberOfBytes);
        this.position(this.pos + numberOfBytes);
        return new String(utf8Bytes, StandardCharsets.UTF_8);
    }

    @Override
    public void copyToMemoryBlock(MemoryBlock memory, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Object readObject() {
        return this.service.readObject(this);
    }

    @Override
    public <T> T readObject(Class aClass) {
        return this.service.readObject((ObjectDataInput)this, aClass);
    }

    @Override
    public Data readData() throws IOException {
        byte[] bytes = this.readByteArray();
        HeapData data = bytes != null ? new HeapData(bytes) : null;
        return data;
    }

    @Override
    public Data readData(DataType type) throws IOException {
        return EnterpriseSerializationUtil.readDataInternal(this, type, this.service.getCurrentMemoryAllocator(), false);
    }

    @Override
    public Data tryReadData(DataType type) throws IOException {
        return EnterpriseSerializationUtil.readDataInternal(this, type, this.service.getCurrentMemoryAllocator(), true);
    }

    @Override
    public long skip(long n) {
        if (n <= 0L || n >= Integer.MAX_VALUE) {
            return 0L;
        }
        return this.skipBytes((int)n);
    }

    @Override
    public int skipBytes(int n) {
        if (n <= 0) {
            return 0;
        }
        int skip = n;
        int pos = this.position();
        if (pos + skip > this.size - this.offset) {
            skip = this.size - this.offset - pos;
        }
        this.position(pos + skip);
        return skip;
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public void position(int newPos) {
        if (newPos > this.size - this.offset || newPos < 0) {
            throw new IllegalArgumentException();
        }
        this.pos = newPos;
        if (this.mark > this.pos) {
            this.mark = -1;
        }
    }

    @Override
    public int available() {
        return this.size - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() {
        this.memory = null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.service.getClassLoader();
    }

    public String toString() {
        return "MemoryBlockDataInput{size=" + this.size + ", pos=" + this.pos + ", mark=" + this.mark + ", byteOrder=" + String.valueOf(this.getByteOrder()) + "}";
    }
}

