/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.internal.util.StringUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public abstract class SSLEngineFactorySupport {
    public static final String JAVA_NET_SSL_PREFIX = "javax.net.ssl.";
    protected static final String PROP_KEY_MATERIAL_DURATION = "keyMaterialDuration";
    protected static final String PROP_PROTOCOL = "protocol";
    protected static final String PROP_TRUST_STORE_TYPE = "trustStoreType";
    protected static final String PROP_TRUST_MANAGER_ALGORITHM = "trustManagerAlgorithm";
    protected static final String PROP_TRUST_STORE_PASSWORD = "trustStorePassword";
    protected static final String PROP_TRUST_STORE = "trustStore";
    protected static final String PROP_KEY_STORE_TYPE = "keyStoreType";
    protected static final String PROP_KEY_MANAGER_ALGORITHM = "keyManagerAlgorithm";
    protected static final String PROP_KEY_STORE = "keyStore";
    protected static final String PROP_KEY_STORE_PASSWORD = "keyStorePassword";
    protected static final String PROP_FORCE_CERT_VALIDATION = "forceCertValidation";
    protected final Properties properties = new Properties();
    protected volatile String protocol;
    protected volatile Duration keyMaterialDuration;
    protected volatile String keyStorePassword;
    protected volatile String keyStore;
    protected volatile String keyManagerAlgorithm;
    protected volatile String keyStoreType;
    protected volatile String trustStore;
    protected volatile String trustStorePassword;
    protected volatile String trustManagerAlgorithm;
    protected volatile String trustStoreType;
    private volatile KeyMaterialHolder keyMaterial;

    protected void load(Properties properties) throws Exception {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
        this.keyStorePassword = SSLEngineFactorySupport.getProperty(properties, PROP_KEY_STORE_PASSWORD);
        this.keyStore = SSLEngineFactorySupport.getProperty(properties, PROP_KEY_STORE);
        this.keyManagerAlgorithm = SSLEngineFactorySupport.getProperty(properties, PROP_KEY_MANAGER_ALGORITHM, KeyManagerFactory.getDefaultAlgorithm());
        this.keyStoreType = SSLEngineFactorySupport.getProperty(properties, PROP_KEY_STORE_TYPE);
        this.trustStore = SSLEngineFactorySupport.getProperty(properties, PROP_TRUST_STORE);
        this.trustStorePassword = SSLEngineFactorySupport.getProperty(properties, PROP_TRUST_STORE_PASSWORD);
        this.trustManagerAlgorithm = SSLEngineFactorySupport.getProperty(properties, PROP_TRUST_MANAGER_ALGORITHM, TrustManagerFactory.getDefaultAlgorithm());
        this.trustStoreType = SSLEngineFactorySupport.getProperty(properties, PROP_TRUST_STORE_TYPE);
        this.protocol = SSLEngineFactorySupport.getProperty(properties, PROP_PROTOCOL, "TLS");
        this.keyMaterialDuration = Duration.parse(SSLEngineFactorySupport.getProperty(properties, PROP_KEY_MATERIAL_DURATION, "PT-1S"));
        this.keyMaterial = this.keyMaterialDuration.isNegative() ? new KeyMaterialHolder(Instant.MAX, SSLEngineFactorySupport.loadKeyManagerFactory(this.keyStorePassword, this.keyStore, this.keyManagerAlgorithm, this.keyStoreType), SSLEngineFactorySupport.loadTrustManagerFactory(this.trustStorePassword, this.trustStore, this.trustManagerAlgorithm, this.trustStoreType)) : new KeyMaterialHolder(Instant.MIN, null, null);
    }

    public KeyMaterial getKeyMaterial() throws IOException, GeneralSecurityException {
        if (this.keyMaterialDuration.isNegative()) {
            return this.keyMaterial;
        }
        KeyMaterialHolder tmpKeyMaterial = this.keyMaterial;
        if (!tmpKeyMaterial.isValid()) {
            KeyManagerFactory kmf = SSLEngineFactorySupport.loadKeyManagerFactory(this.keyStorePassword, this.keyStore, this.keyManagerAlgorithm, this.keyStoreType);
            TrustManagerFactory tmf = SSLEngineFactorySupport.loadTrustManagerFactory(this.trustStorePassword, this.trustStore, this.trustManagerAlgorithm, this.trustStoreType);
            tmpKeyMaterial = new KeyMaterialHolder(Instant.now().plus(this.keyMaterialDuration), kmf, tmf);
            if (!this.keyMaterialDuration.isZero()) {
                this.keyMaterial = tmpKeyMaterial;
            }
        }
        return tmpKeyMaterial;
    }

    public static TrustManagerFactory loadTrustManagerFactory(String trustStorePassword, String trustStore, String trustManagerAlgorithm, String trustStoreType) throws IOException, GeneralSecurityException {
        if (trustStore == null && trustStorePassword == null && trustStoreType == null) {
            return null;
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerAlgorithm);
        KeyStore ts = KeyStore.getInstance(trustStoreType == null ? KeyStore.getDefaultType() : trustStoreType);
        char[] passPhrase = trustStorePassword == null ? null : trustStorePassword.toCharArray();
        SSLEngineFactorySupport.loadKeyStore(ts, passPhrase, trustStore);
        tmf.init(ts);
        return tmf;
    }

    public static KeyManagerFactory loadKeyManagerFactory(String keyStorePassword, String keyStore, String keyManagerAlgorithm, String keyStoreType) throws IOException, GeneralSecurityException {
        if (keyStore == null && keyStorePassword == null && keyStoreType == null) {
            return null;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        char[] passPhrase = keyStorePassword == null ? null : keyStorePassword.toCharArray();
        KeyStore ks = KeyStore.getInstance(keyStoreType == null ? KeyStore.getDefaultType() : keyStoreType);
        SSLEngineFactorySupport.loadKeyStore(ks, passPhrase, keyStore);
        kmf.init(ks, passPhrase);
        return kmf;
    }

    public static void loadKeyStore(KeyStore ks, char[] passPhrase, String keyStoreFile) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (FileInputStream in = keyStoreFile == null ? null : new FileInputStream(keyStoreFile);){
            ks.load(in, passPhrase);
        }
    }

    public static String getProperty(Properties properties, String property) {
        String value = properties.getProperty(property);
        if (value == null) {
            value = properties.getProperty(JAVA_NET_SSL_PREFIX + property);
        }
        if (value == null) {
            value = System.getProperty(JAVA_NET_SSL_PREFIX + property);
        }
        if (value == null) {
            value = properties.getProperty(StringUtil.lowerCaseInternal(property));
        }
        return value;
    }

    public static String getProperty(Properties properties, String property, String defaultValue) {
        String value = SSLEngineFactorySupport.getProperty(properties, property);
        return value != null ? value : defaultValue;
    }

    protected static final class KeyMaterialHolder
    implements KeyMaterial {
        private final Instant validityEnd;
        private final KeyManagerFactory keyManagerFactory;
        private final TrustManagerFactory trustManagerFactory;

        public KeyMaterialHolder(Instant validityEnd, KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory) {
            this.validityEnd = Objects.requireNonNull(validityEnd);
            this.keyManagerFactory = keyManagerFactory;
            this.trustManagerFactory = trustManagerFactory;
        }

        protected boolean isValid() {
            return Instant.now().isBefore(this.validityEnd);
        }

        @Override
        public KeyManagerFactory getKeyManagerFactory() {
            return this.keyManagerFactory;
        }

        @Override
        public TrustManagerFactory getTrustManagerFactory() {
            return this.trustManagerFactory;
        }
    }

    public static interface KeyMaterial {
        public KeyManagerFactory getKeyManagerFactory();

        public TrustManagerFactory getTrustManagerFactory();
    }
}

