/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.nativememory;

import com.hazelcast.cache.impl.hidensity.maxsize.HiDensityEntryCountEvictionChecker;
import com.hazelcast.cache.impl.hidensity.maxsize.HiDensityFreeNativeMemoryPercentageEvictionChecker;
import com.hazelcast.cache.impl.hidensity.maxsize.HiDensityFreeNativeMemorySizeEvictionChecker;
import com.hazelcast.cache.impl.hidensity.maxsize.HiDensityUsedNativeMemoryPercentageEvictionChecker;
import com.hazelcast.cache.impl.hidensity.maxsize.HiDensityUsedNativeMemorySizeEvictionChecker;
import com.hazelcast.cache.impl.hidensity.nativememory.CacheHiDensityRecordProcessor;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.eviction.EvictionChecker;
import com.hazelcast.internal.eviction.ExpirationChecker;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.memory.PooledNativeMemoryStats;
import com.hazelcast.internal.memory.PoolingMemoryManager;
import com.hazelcast.internal.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.internal.nearcache.HDNearCacheRecordStore;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.nearcache.impl.nativememory.HDNearCacheRecord;
import com.hazelcast.internal.nearcache.impl.nativememory.HDNearCacheRecordAccessor;
import com.hazelcast.internal.nearcache.impl.nativememory.HDNearCacheRecordMap;
import com.hazelcast.internal.nearcache.impl.store.AbstractNearCacheRecordStore;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.memory.NativeOutOfMemoryError;
import javax.annotation.Nullable;

public class HDNearCacheRecordStoreImpl<K, V>
extends AbstractNearCacheRecordStore<K, V, Data, HDNearCacheRecord, HDNearCacheRecordMap>
implements HDNearCacheRecordStore<K, V, HDNearCacheRecord> {
    private static final int DEFAULT_INITIAL_CAPACITY = 256;
    private static final int SLOT_COST_IN_BYTES = 16;
    private HiDensityStorageInfo storageInfo;
    private HazelcastMemoryManager memoryManager;
    private HDNearCacheRecordAccessor recordAccessor;
    private HiDensityRecordProcessor<HDNearCacheRecord> recordProcessor;
    private final int sampleCount;
    private final RecordExpirationChecker recordExpirationChecker = new RecordExpirationChecker();

    public HDNearCacheRecordStoreImpl(NearCacheConfig nearCacheConfig, EnterpriseSerializationService ss, ClassLoader classLoader, int sampleCount) {
        this(nearCacheConfig, new NearCacheStatsImpl(), new HiDensityStorageInfo(nearCacheConfig.getName()), ss, classLoader, sampleCount);
    }

    public HDNearCacheRecordStoreImpl(NearCacheConfig nearCacheConfig, NearCacheStatsImpl nearCacheStats, HiDensityStorageInfo storageInfo, EnterpriseSerializationService ss, ClassLoader classLoader, int sampleCount) {
        super(nearCacheConfig, nearCacheStats, ss, classLoader);
        this.storageInfo = storageInfo;
        this.sampleCount = sampleCount;
    }

    private void ensureInitialized(NearCacheConfig nearCacheConfig) {
        EnterpriseSerializationService serializationService = (EnterpriseSerializationService)this.serializationService;
        if (this.memoryManager == null) {
            HazelcastMemoryManager mm = serializationService.getMemoryManager();
            this.memoryManager = mm instanceof PoolingMemoryManager ? ((PoolingMemoryManager)mm).getGlobalMemoryManager() : mm;
        }
        HiDensityStorageInfo hiDensityStorageInfo = this.storageInfo = this.storageInfo == null ? new HiDensityStorageInfo(nearCacheConfig.getName()) : this.storageInfo;
        if (this.recordAccessor == null) {
            this.recordAccessor = new HDNearCacheRecordAccessor(serializationService, this.memoryManager);
        }
        if (this.recordProcessor == null) {
            this.recordProcessor = new CacheHiDensityRecordProcessor<HDNearCacheRecord>(serializationService, this.recordAccessor, this.memoryManager, this.storageInfo);
        }
    }

    @Override
    protected HDNearCacheRecordMap createNearCacheRecordMap(NearCacheConfig nearCacheConfig) {
        this.ensureInitialized(nearCacheConfig);
        return new HDNearCacheRecordMap(256, this.recordProcessor, this.storageInfo);
    }

    @Override
    protected EvictionChecker createNearCacheEvictionChecker(EvictionConfig evictionConfig, NearCacheConfig nearCacheConfig) {
        this.ensureInitialized(nearCacheConfig);
        MaxSizePolicy maxSizePolicy = evictionConfig.getMaxSizePolicy();
        if (maxSizePolicy == null) {
            throw new IllegalArgumentException("Max-size policy cannot be null");
        }
        int size = evictionConfig.getSize();
        MemoryStats memoryStats = ((EnterpriseSerializationService)this.serializationService).getMemoryManager().getMemoryStats();
        long maxNativeMemory = memoryStats instanceof PooledNativeMemoryStats ? ((PooledNativeMemoryStats)memoryStats).getMaxData() : memoryStats.getMaxNative();
        switch (maxSizePolicy) {
            case ENTRY_COUNT: {
                return new HiDensityEntryCountEvictionChecker(this.storageInfo, size);
            }
            case USED_NATIVE_MEMORY_SIZE: {
                return new HiDensityUsedNativeMemorySizeEvictionChecker(this.storageInfo, size);
            }
            case USED_NATIVE_MEMORY_PERCENTAGE: {
                return new HiDensityUsedNativeMemoryPercentageEvictionChecker(this.storageInfo, size, maxNativeMemory);
            }
            case FREE_NATIVE_MEMORY_SIZE: {
                return new HiDensityFreeNativeMemorySizeEvictionChecker(this.memoryManager, size);
            }
            case FREE_NATIVE_MEMORY_PERCENTAGE: {
                return new HiDensityFreeNativeMemoryPercentageEvictionChecker(this.memoryManager, size, maxNativeMemory);
            }
        }
        throw new IllegalArgumentException("Invalid max-size policy (" + String.valueOf((Object)maxSizePolicy) + ") for " + this.getClass().getName() + "! Only " + String.valueOf((Object)MaxSizePolicy.ENTRY_COUNT) + ", " + String.valueOf((Object)MaxSizePolicy.USED_NATIVE_MEMORY_SIZE) + ", " + String.valueOf((Object)MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE) + ", " + String.valueOf((Object)MaxSizePolicy.FREE_NATIVE_MEMORY_SIZE) + ", " + String.valueOf((Object)MaxSizePolicy.FREE_NATIVE_MEMORY_PERCENTAGE) + " are supported.");
    }

    private NativeMemoryData toNativeMemoryData(Object data) {
        if (!(data instanceof Data)) {
            return (NativeMemoryData)this.recordProcessor.toData(data, DataType.NATIVE);
        }
        if (!(data instanceof NativeMemoryData)) {
            return (NativeMemoryData)this.recordProcessor.convertData((Data)data, DataType.NATIVE);
        }
        return (NativeMemoryData)data;
    }

    private static boolean isMemoryBlockValid(MemoryBlock memoryBlock) {
        return memoryBlock != null && memoryBlock.address() != 0L;
    }

    private HDNearCacheRecord createRecord(Object value, long creationTime, long expiryTime) {
        return this.createRecordInternal(value, creationTime, expiryTime, false, true);
    }

    private HDNearCacheRecord createRecordInternal(Object value, long creationTime, long expirationTime, boolean forceEvict, boolean retryOnOutOfMemoryError) {
        if (forceEvict) {
            this.forceEvict();
        }
        NativeMemoryData data = null;
        long recordAddress = 0L;
        try {
            recordAddress = this.recordProcessor.allocate(HDNearCacheRecord.SIZE);
            HDNearCacheRecord record = (HDNearCacheRecord)this.recordProcessor.newRecord();
            record.reset(recordAddress);
            record.setReservationId(-2L);
            record.setCreationTime(creationTime);
            record.setExpirationTime(expirationTime);
            record.setLastAccessTime(-1L);
            if (value != null) {
                data = this.toNativeMemoryData(value);
                record.setValueAddress(data.address());
            } else {
                record.setValueAddress(0L);
            }
            return record;
        }
        catch (NativeOutOfMemoryError e) {
            if (recordAddress != 0L) {
                this.recordProcessor.dispose(recordAddress);
            }
            if (HDNearCacheRecordStoreImpl.isMemoryBlockValid(data)) {
                this.recordProcessor.disposeData(data);
            }
            if (retryOnOutOfMemoryError) {
                return this.createRecordInternal(value, creationTime, expirationTime, true, false);
            }
            throw e;
        }
    }

    @Override
    public void invalidate(K key) {
        this.checkAvailable();
        HDNearCacheRecord record = null;
        try {
            Data keyData = this.toData(key);
            long keyStorageMemoryCost = this.getKeyStorageMemoryCost(keyData);
            record = (HDNearCacheRecord)((HDNearCacheRecordMap)this.records).remove(keyData);
            if (this.canUpdateStats(record)) {
                this.nearCacheStats.decrementOwnedEntryCount();
                this.nearCacheStats.incrementInvalidations();
                long totalStorageMemoryCost = keyStorageMemoryCost + this.getRecordStorageMemoryCost(record);
                this.nearCacheStats.decrementOwnedEntryMemoryCost(totalStorageMemoryCost);
            }
            this.onRemove(key, record, record != null);
        }
        catch (Throwable error) {
            this.onRemoveError(key, record, record != null, error);
            throw ExceptionUtil.rethrow(error);
        }
        finally {
            this.nearCacheStats.incrementInvalidationRequests();
        }
    }

    @Override
    protected long getKeyStorageMemoryCost(K key) {
        if (key instanceof Data && !(key instanceof NativeMemoryData)) {
            NativeMemoryData nativeKeyData = new NativeMemoryData();
            nativeKeyData.reset(((HDNearCacheRecordMap)this.records).getNativeKeyAddress((Data)key));
            return this.getKeyStorageMemoryCost(nativeKeyData);
        }
        long slotKeyCost = 8L;
        return key instanceof MemoryBlock ? slotKeyCost + this.recordAccessor.getSize((MemoryBlock)key) : 0L;
    }

    @Override
    protected long getRecordStorageMemoryCost(HDNearCacheRecord record) {
        long slotValueCost = 8L;
        return slotValueCost + this.recordAccessor.getSize(record) + this.recordAccessor.getSize(record.getValue());
    }

    @Override
    protected HDNearCacheRecord createRecord(V value) {
        long creationTime = Clock.currentTimeMillis();
        return this.timeToLiveMillis > 0L ? this.createRecord(value, creationTime, creationTime + this.timeToLiveMillis) : this.createRecord(value, creationTime, -1L);
    }

    @Override
    protected void updateRecordValue(HDNearCacheRecord record, V value) {
        NativeMemoryData newValue = null;
        try {
            NativeMemoryData oldValue = record.getValue();
            newValue = this.toNativeMemoryData(value);
            record.setValue(newValue);
            if (HDNearCacheRecordStoreImpl.isMemoryBlockValid(oldValue)) {
                this.recordProcessor.disposeData(oldValue);
            }
        }
        catch (Throwable throwable) {
            if (HDNearCacheRecordStoreImpl.isMemoryBlockValid(newValue)) {
                this.recordProcessor.disposeData(newValue);
            }
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    protected V recordToValue(HDNearCacheRecord record) {
        if (record.getValue() == null) {
            return (V)NearCache.CACHED_AS_NULL;
        }
        if (!HDNearCacheRecordStoreImpl.isMemoryBlockValid(record)) {
            return null;
        }
        return (V)this.recordProcessor.readValue(record);
    }

    @Override
    public HDNearCacheRecord getRecord(K key) {
        return (HDNearCacheRecord)((HDNearCacheRecordMap)this.records).get(this.toData(key));
    }

    @Override
    @Nullable
    public V tryPublishReserved(K key, V value, long reservationId, boolean deserialize) {
        NearCacheRecord reservedRecord = this.getRecord((Object)key);
        if (reservedRecord == null) {
            return null;
        }
        HDNearCacheRecord record = (HDNearCacheRecord)this.publishReservedRecord(key, value, reservedRecord, reservationId);
        if (!deserialize) {
            return null;
        }
        return this.toValue(record.getValue());
    }

    @Override
    protected HDNearCacheRecord reserveForWriteUpdate(K key, Data keyData, long reservationId) {
        HDNearCacheRecord existingRecord = (HDNearCacheRecord)((HDNearCacheRecordMap)this.records).get(keyData);
        HDNearCacheRecord reservedRecord = this.reserveForWriteUpdate(key, keyData, existingRecord, reservationId);
        if (reservedRecord != null) {
            Data nativeKey = null;
            try {
                nativeKey = existingRecord != null ? keyData : this.toNativeMemoryData(keyData);
                ((HDNearCacheRecordMap)this.records).put(nativeKey, reservedRecord);
            }
            catch (Throwable throwable) {
                this.freeHDMemory(nativeKey, reservedRecord);
                throw ExceptionUtil.rethrow(throwable);
            }
        } else {
            this.invalidate(keyData);
        }
        return reservedRecord;
    }

    @Override
    protected HDNearCacheRecord reserveForReadUpdate(K key, Data keyData, long reservationId) {
        NearCacheRecord recordToReserve = this.getRecord((Object)key);
        if (recordToReserve != null) {
            return recordToReserve;
        }
        HDNearCacheRecord record = null;
        NativeMemoryData nativeKey = null;
        try {
            record = (HDNearCacheRecord)this.newReservationRecord(key, keyData, reservationId);
            nativeKey = this.toNativeMemoryData(key);
            ((HDNearCacheRecordMap)this.records).put((Data)nativeKey, record);
        }
        catch (Throwable throwable) {
            this.freeHDMemory(nativeKey, record);
            throw ExceptionUtil.rethrow(throwable);
        }
        return record;
    }

    private void freeHDMemory(Data key, HDNearCacheRecord record) {
        if (key instanceof NativeMemoryData && HDNearCacheRecordStoreImpl.isMemoryBlockValid((NativeMemoryData)key)) {
            this.recordProcessor.disposeData(key);
        }
        if (HDNearCacheRecordStoreImpl.isMemoryBlockValid(record)) {
            this.recordProcessor.dispose(record);
        }
    }

    @Override
    protected HDNearCacheRecord putRecord(K key, HDNearCacheRecord record) {
        assert (key != null);
        NativeMemoryData keyData = this.toNativeMemoryData(key);
        HDNearCacheRecord oldRecord = ((HDNearCacheRecordMap)this.records).put((Data)keyData, record);
        this.nearCacheStats.incrementOwnedEntryMemoryCost(this.getTotalStorageMemoryCost(keyData, record));
        if (oldRecord != null) {
            this.nearCacheStats.decrementOwnedEntryMemoryCost(this.getTotalStorageMemoryCost(keyData, oldRecord));
        }
        return oldRecord;
    }

    @Override
    protected boolean containsRecordKey(K key) {
        Data keyData = this.toData(key);
        return ((HDNearCacheRecordMap)this.records).containsKey(keyData);
    }

    @Override
    protected void onPut(K key, V value, HDNearCacheRecord record, HDNearCacheRecord oldRecord) {
        if (HDNearCacheRecordStoreImpl.isMemoryBlockValid(oldRecord)) {
            this.recordProcessor.dispose(oldRecord);
        }
    }

    @Override
    protected void onPutError(K key, V value, HDNearCacheRecord record, HDNearCacheRecord oldRecord, Throwable error) {
        if (HDNearCacheRecordStoreImpl.isMemoryBlockValid(record)) {
            this.recordProcessor.dispose(record);
        }
    }

    @Override
    protected void onRemove(K key, HDNearCacheRecord record, boolean removed) {
        if (record != null) {
            this.recordProcessor.dispose(record);
        }
    }

    @Override
    protected void onRemoveError(K key, HDNearCacheRecord record, boolean removed, Throwable error) {
        if (removed && HDNearCacheRecordStoreImpl.isMemoryBlockValid(record)) {
            this.recordProcessor.dispose(record);
        }
    }

    @Override
    public int forceEvict() {
        this.checkAvailable();
        return ((HDNearCacheRecordMap)this.records).forceEvict(20, this);
    }

    @Override
    public void doExpiration() {
        this.checkAvailable();
        ((HDNearCacheRecordMap)this.records).sampleAndDeleteExpired(this, this.recordExpirationChecker, this.sampleCount);
    }

    @Override
    public void loadKeys(DataStructureAdapter<Object, ?> adapter) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void storeKeys() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void onEvict(Data key, HDNearCacheRecord record, boolean wasExpired) {
        if (!this.canUpdateStats(record)) {
            return;
        }
        super.onEvict(key, record, wasExpired);
        this.nearCacheStats.decrementOwnedEntryMemoryCost(this.getTotalStorageMemoryCost(key, record));
    }

    @Override
    public HazelcastMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public void destroy() {
        this.checkAvailable();
        try {
            super.destroy();
        }
        finally {
            ((HDNearCacheRecordMap)this.records).dispose();
            this.records = null;
        }
    }

    private class RecordExpirationChecker
    implements ExpirationChecker<HDNearCacheRecord> {
        private RecordExpirationChecker() {
        }

        @Override
        public boolean isExpired(HDNearCacheRecord record) {
            return HDNearCacheRecordStoreImpl.this.isRecordExpired(record);
        }
    }
}

