/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory.impl;

import com.hazelcast.config.PersistentMemoryDirectoryConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.util.DirectoryLock;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;

final class PersistentMemoryDirectory {
    private static final ILogger LOGGER = Logger.getLogger(PersistentMemoryDirectory.class);
    private static final String PERSISTENT_MEMORY_FILE_EXTENSION = ".pmem";
    private static final int LOCK_NEW_PMEM_DIRECTORY_ATTEMPTS_NUMBER = 5;
    private DirectoryLock directoryLock;
    private final String directory;
    private final int numaNodeId;
    private final File pmemFile;

    PersistentMemoryDirectory(PersistentMemoryDirectoryConfig config) {
        this(config.getDirectory(), config.getNumaNode());
    }

    private PersistentMemoryDirectory(String directory, int numaNodeId) {
        this.directory = directory;
        this.numaNodeId = numaNodeId;
        this.pmemFile = this.acquireDirectory();
    }

    File getPersistentMemoryFile() {
        return this.pmemFile;
    }

    int getNumaNodeId() {
        return this.numaNodeId;
    }

    private File acquireDirectory() {
        File pmemDirectory = new File(this.directory);
        if (!(pmemDirectory.exists() || pmemDirectory.mkdirs() || pmemDirectory.exists())) {
            throw new HazelcastException("Could not create " + pmemDirectory.getAbsolutePath());
        }
        if (!pmemDirectory.isDirectory()) {
            throw new HazelcastException(pmemDirectory.getAbsolutePath() + " is not a directory!");
        }
        File[] dirs = pmemDirectory.listFiles(f -> f.isDirectory() && UuidUtil.isUUID(f.getName()));
        if (dirs == null) {
            return this.newDirectoryAndDatafile(pmemDirectory, false);
        }
        for (File dir : dirs) {
            try {
                return this.newDirectoryAndDatafile(dir, true);
            }
            catch (Exception e) {
                LOGGER.fine("Could not lock persistent memory directory: %s. Reason: %s", dir.getAbsolutePath(), e.getMessage());
            }
        }
        return this.newDirectoryAndDatafile(pmemDirectory, false);
    }

    private File newDirectoryAndDatafile(File pmemDirectory, boolean reuseDirectory) {
        this.directoryLock = reuseDirectory ? DirectoryLock.lockForDirectory(pmemDirectory, LOGGER) : PersistentMemoryDirectory.newDirectory(pmemDirectory);
        PersistentMemoryDirectory.clearDirectory(this.directoryLock.getDir());
        return this.newDatafile();
    }

    private static DirectoryLock newDirectory(File pmemDirectory) {
        for (int attempt = 1; attempt <= 5; ++attempt) {
            File dir = new File(pmemDirectory, UuidUtil.newUnsecureUuidString());
            boolean created = dir.mkdir();
            if (!created) {
                throw new HazelcastException("Unable to create " + String.valueOf(dir));
            }
            LOGGER.info("Created new empty persistent memory directory: " + dir.getAbsolutePath());
            try {
                DirectoryLock lock = DirectoryLock.lockForDirectory(dir, LOGGER);
                return lock;
            }
            catch (Exception e) {
                LOGGER.fine("Could not lock persistent memory directory %s. Reason: %s", dir.getAbsolutePath(), e.getMessage());
                if (attempt < 5) continue;
                throw e;
            }
        }
        throw new HazelcastException("Unable to create persistent memory directory at " + String.valueOf(pmemDirectory));
    }

    private File newDatafile() {
        return new File(this.directoryLock.getDir(), UuidUtil.newUnsecureUuidString() + PERSISTENT_MEMORY_FILE_EXTENSION);
    }

    private static void clearDirectory(File directory) {
        File[] files = directory.listFiles(file -> file.getName().endsWith(PERSISTENT_MEMORY_FILE_EXTENSION));
        if (files != null) {
            for (File file2 : files) {
                boolean deleted = file2.delete();
                if (deleted) continue;
                LOGGER.fine("Could not delete file %s", file2.getAbsolutePath());
            }
        }
    }

    void dispose() {
        PersistentMemoryDirectory.clearDirectory(this.directoryLock.getDir());
        this.directoryLock.release();
    }
}

