/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory.impl;

import com.hazelcast.internal.memory.impl.LibMalloc;
import com.hazelcast.internal.memory.impl.MemkindHeap;

public abstract class AbstractMemkindMalloc
implements LibMalloc {
    private final MemkindHeap memkindHeap;

    protected AbstractMemkindMalloc(MemkindHeap memkindHeap) {
        this.memkindHeap = memkindHeap;
    }

    @Override
    public long malloc(long size) {
        try {
            return this.memkindHeap.allocate(size);
        }
        catch (OutOfMemoryError e) {
            return 0L;
        }
    }

    @Override
    public long realloc(long address, long size) {
        try {
            return this.memkindHeap.realloc(address, size);
        }
        catch (OutOfMemoryError e) {
            return 0L;
        }
    }

    @Override
    public void free(long address) {
        this.memkindHeap.free(address);
    }

    @Override
    public void dispose() {
        this.memkindHeap.close();
        this.onDispose();
    }

    protected void onDispose() {
    }
}

