/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.elastic.LongArray;
import com.hazelcast.internal.elastic.queue.LongArrayQueue;
import com.hazelcast.internal.memory.AbstractPoolingMemoryManager;
import com.hazelcast.internal.memory.AddressQueue;
import com.hazelcast.internal.memory.DestroyedAddressQueue;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.PooledNativeMemoryStats;
import com.hazelcast.internal.memory.impl.LibMalloc;
import com.hazelcast.internal.memory.impl.MemoryManagerBean;
import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.internal.util.collection.Long2LongMap;
import com.hazelcast.internal.util.collection.Long2LongMapHsa;
import com.hazelcast.internal.util.collection.LongCursor;
import com.hazelcast.internal.util.collection.LongLongCursor;
import com.hazelcast.internal.util.collection.LongSet;
import com.hazelcast.internal.util.collection.LongSetHsa;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.sort.LongMemArrayQuickSorter;
import com.hazelcast.internal.util.sort.MemArrayQuickSorter;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.NativeOutOfMemoryError;
import java.util.concurrent.TimeUnit;

public class ThreadLocalPoolingMemoryManager
extends AbstractPoolingMemoryManager
implements HazelcastMemoryManager {
    static final int HEADER_SIZE = 1;
    static final int MEMORY_OVERHEAD_WHEN_PAGE_OFFSET_IS_STORED = 8;
    static final int BLOCK_SIZE_MASK = 31;
    static final int EXTERNAL_BLOCK_BIT = 7;
    static final int AVAILABLE_BIT = 6;
    static final int PAGE_OFFSET_EXIST_BIT = 5;
    private static final int INITIAL_CAPACITY = 1024;
    private static final float LOAD_FACTOR = 0.6f;
    private static final long SHRINK_INTERVAL = TimeUnit.MINUTES.toMillis(5L);
    private static final boolean AGGRESSIVE_CORRUPTION_CHECKS = false;
    private final String threadName;
    private final LongSet pageAllocations;
    private final LongArray sortedPageAllocations;
    private final Long2LongMap externalAllocations;
    private final MemArrayQuickSorter pageAllocationsSorter;
    private long lastFullCompaction;

    protected ThreadLocalPoolingMemoryManager(int minBlockSize, int pageSize, LibMalloc malloc, PooledNativeMemoryStats stats) {
        super(minBlockSize, pageSize, malloc, stats);
        MemoryManagerBean systemMemMgr = new MemoryManagerBean(this.systemAllocator, GlobalMemoryAccessorRegistry.AMEM);
        this.sortedPageAllocations = new LongArray(systemMemMgr, 1024L);
        this.pageAllocations = new LongSetHsa(0L, systemMemMgr, 1024, 0.6f);
        this.pageAllocationsSorter = new LongMemArrayQuickSorter(GlobalMemoryAccessorRegistry.AMEM, 0L);
        this.externalAllocations = new Long2LongMapHsa(-1L, systemMemMgr);
        this.initializeAddressQueues();
        this.threadName = Thread.currentThread().getName();
    }

    @Override
    public boolean isDisposed() {
        return this.addressQueues[0] == DestroyedAddressQueue.INSTANCE;
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        for (int i = 0; i < this.addressQueues.length; ++i) {
            AddressQueue q = this.addressQueues[i];
            if (q == null) continue;
            q.destroy();
            this.addressQueues[i] = DestroyedAddressQueue.INSTANCE;
        }
        this.disposePageAllocations();
        this.sortedPageAllocations.dispose();
        this.disposeExternalAllocations();
    }

    @Override
    public long validateAndGetAllocatedSize(long address) {
        ThreadLocalPoolingMemoryManager.assertValidAddress(address);
        long pageBase = this.searchForOwningPage(address);
        if (pageBase == 0L) {
            return this.findSizeOfExternalAllocation(address);
        }
        int pageOffset = (int)(address - pageBase);
        byte header = this.getBlockHeaderByHeaderAddress(this.toHeaderAddress(address, pageOffset));
        int decodedSize = ThreadLocalPoolingMemoryManager.decodeSizeFromHeader(header);
        return !ThreadLocalPoolingMemoryManager.isHeaderAvailable(header) && !ThreadLocalPoolingMemoryManager.isExternalBlockHeader(header) && this.isLegalInternalBlockSize(decodedSize) && pageBase + (long)this.pageSize >= address + (long)decodedSize && (!ThreadLocalPoolingMemoryManager.hasStoredPageOffset(header) || this.getStoredPageOffset(address, decodedSize) == pageOffset) ? (long)decodedSize : -1L;
    }

    public String toString() {
        return "ThreadLocalPoolingMemoryManager [" + this.threadName + "]";
    }

    @Override
    protected void initialize(long address, int size, int offset) {
        ThreadLocalPoolingMemoryManager.trace("initialize %d, %d, %d", address, size, offset);
        ThreadLocalPoolingMemoryManager.assertValidAddress(address);
        assert (QuickMath.isPowerOfTwo(size)) : "Size must be power of two, got " + size;
        assert (size >= this.minBlockSize) : "Size must be greater than or equal to minimum block size of " + this.minBlockSize + ", got " + size;
        assert (offset >= 0) : "Offset must be non-negative, got " + offset;
        byte header = ThreadLocalPoolingMemoryManager.createAvailableHeader(size);
        long headerAddress = this.toHeaderAddress(address, offset);
        GlobalMemoryAccessorRegistry.AMEM.putByte(headerAddress, header);
        this.writeShadowBlockHeader(address, size, header);
        GlobalMemoryAccessorRegistry.AMEM.putInt(address, offset);
    }

    @Override
    protected AddressQueue createAddressQueue(int index, int size) {
        return new ThreadAddressQueue(index, size);
    }

    @Override
    protected int headerSize() {
        return 1;
    }

    @Override
    protected void onMallocPage(long pageAddress) {
        ThreadLocalPoolingMemoryManager.trace("onMallocPage: %d", pageAddress);
        boolean added = this.pageAllocations.add(pageAddress);
        if (added) {
            try {
                this.addToSortedAllocations(pageAddress);
            }
            catch (NativeOutOfMemoryError e) {
                this.pageAllocations.remove(pageAddress);
                this.freePage(pageAddress);
                throw e;
            }
        }
        assert (added) : "Duplicate malloc() for page address " + pageAddress;
        this.lastFullCompaction = 0L;
    }

    @Override
    protected void onOome(NativeOutOfMemoryError e) {
        long now = Clock.currentTimeMillis();
        if (now > this.lastFullCompaction + 1000L) {
            this.compact();
            this.lastFullCompaction = now;
        }
    }

    @Override
    protected long allocateExternalBlock(long size) {
        long allocationSize = size + 8L;
        long address = this.pageAllocator.allocate(allocationSize);
        long existingAllocationSize = this.externalAllocations.putIfAbsent(address, allocationSize);
        if (existingAllocationSize != -1L) {
            this.pageAllocator.free(address, allocationSize);
            throw new AssertionError((Object)String.format("Page allocator returned an already allocated address %x. Existing size is %x, requested size is %x", address, existingAllocationSize, size));
        }
        byte header = ThreadLocalPoolingMemoryManager.markAsExternalBlockHeader((byte)0);
        long internalHeaderAddress = address + 8L - 1L;
        GlobalMemoryAccessorRegistry.AMEM.putByte((Object)null, internalHeaderAddress, header);
        return address + 8L;
    }

    @Override
    protected void freeExternalBlock(long address, long size) {
        long allocationSize = size + 8L;
        long allocationAddress = address - 8L;
        long actualAllocationSize = this.externalAllocations.remove(allocationAddress);
        if (actualAllocationSize == -1L) {
            throw new AssertionError((Object)("Double free attempt detected for external address " + address + " of size " + size));
        }
        long actualSize = actualAllocationSize - 8L;
        if (actualSize != size) {
            this.externalAllocations.put(allocationAddress, actualAllocationSize);
            throw new AssertionError((Object)String.format("The call free(%x, %x) refers to an externally allocated block, but the supplied size is wrong. Actual block size is %x", address, size, actualSize));
        }
        this.pageAllocator.free(allocationAddress, allocationSize);
    }

    @Override
    protected void markAvailable(long address) {
        int pageOffset;
        ThreadLocalPoolingMemoryManager.trace("markAvailable: %d", address);
        ThreadLocalPoolingMemoryManager.assertValidAddress(address);
        long headerAddress = this.toHeaderAddress(address);
        byte header = this.getBlockHeaderByHeaderAddress(headerAddress);
        assert (!ThreadLocalPoolingMemoryManager.isHeaderAvailable(header)) : String.format("Block header at address %x is corrupt because it is already marked as available", address);
        int decodedSize = ThreadLocalPoolingMemoryManager.decodeSizeFromHeader(header);
        assert (this.isLegalInternalBlockSize(decodedSize)) : String.format("Block header at address %x is corrupt because it encodes an invalid size %x", address, decodedSize);
        if (ThreadLocalPoolingMemoryManager.hasStoredPageOffset(header)) {
            pageOffset = this.getStoredPageOffset(address, decodedSize);
            assert (this.isLegalPageOffsetAndSize(pageOffset, decodedSize)) : String.format("Block at address %x, decoded size %x, with decoded offset %x within the owning page, is corrupt because it cannot fit into a page of size %x", address, decodedSize, pageOffset, this.pageSize);
            assert (address > (long)pageOffset) : String.format("Block header at address %x of decoded size %x, with decoded offset %x within the owning page, is corrupt because the derived page base address is %x", address, decodedSize, pageOffset, address - (long)pageOffset);
        } else {
            long pageBase = this.searchForOwningPage(address);
            assert (pageBase > 0L) : String.format("Block at address %x of decoded size %x is corrupt because it doesn't fit into any allocated page", address, decodedSize);
            assert (address + (long)decodedSize <= pageBase + (long)this.pageSize) : String.format("Block [%x, %x] (decoded size %x) is corrupt because its header belongs to the page [%x, %x], but the rest of the block extends beyond the page end", address, address + (long)decodedSize - 1L, decodedSize, pageBase, pageBase + (long)this.pageSize - 1L);
            pageOffset = (int)(address - pageBase);
        }
        byte availableHeader = ThreadLocalPoolingMemoryManager.makeHeaderAvailable(header);
        GlobalMemoryAccessorRegistry.AMEM.putByte(headerAddress, availableHeader);
        this.writeShadowBlockHeader(address, decodedSize, availableHeader);
        GlobalMemoryAccessorRegistry.AMEM.putInt(ThreadLocalPoolingMemoryManager.addressOfStoredPageOffset(address, decodedSize), 0);
        GlobalMemoryAccessorRegistry.AMEM.putInt(address, pageOffset);
    }

    @Override
    protected boolean markUnavailable(long address, int usedSize, int internalSize) {
        ThreadLocalPoolingMemoryManager.trace("markUnavailable: %d, %d, %d", address, usedSize, internalSize);
        ThreadLocalPoolingMemoryManager.assertValidAddress(address);
        boolean canStorePageOffset = internalSize - usedSize >= 8;
        int offset = this.getOffsetWithinPage(address);
        long headerAddress = this.toHeaderAddress(address, offset);
        byte headerNow = this.getBlockHeaderByHeaderAddress(headerAddress);
        byte headerToBe = ThreadLocalPoolingMemoryManager.makeHeaderUnavailable(headerNow, canStorePageOffset);
        GlobalMemoryAccessorRegistry.AMEM.putByte(headerAddress, headerToBe);
        this.writeShadowBlockHeader(address, internalSize, (byte)0);
        if (canStorePageOffset) {
            GlobalMemoryAccessorRegistry.AMEM.putInt(ThreadLocalPoolingMemoryManager.addressOfStoredPageOffset(address, internalSize), offset);
        }
        GlobalMemoryAccessorRegistry.AMEM.putInt(address, 0);
        return true;
    }

    @Override
    protected boolean isAvailable(long address) {
        ThreadLocalPoolingMemoryManager.assertValidAddress(address);
        return this.isAddressAvailable(address);
    }

    @Override
    protected boolean markInvalid(long address, int expectedSize, int offset) {
        ThreadLocalPoolingMemoryManager.trace("markInvalid: %d, %d, %d", address, expectedSize, offset);
        ThreadLocalPoolingMemoryManager.assertValidAddress(address);
        assert ((long)expectedSize == this.getSizeInternal(address)) : "Invalid size, got " + this.getSizeInternal(address) + ", expected " + expectedSize;
        long headerAddress = this.toHeaderAddress(address, offset);
        GlobalMemoryAccessorRegistry.AMEM.putByte(headerAddress, (byte)0);
        this.writeShadowBlockHeader(address, expectedSize, (byte)0);
        GlobalMemoryAccessorRegistry.AMEM.putInt(ThreadLocalPoolingMemoryManager.addressOfStoredPageOffset(address, expectedSize), 0);
        GlobalMemoryAccessorRegistry.AMEM.putInt(address, 0);
        return true;
    }

    @Override
    protected boolean isValidAndAvailable(long address, int expectedSize) {
        boolean validOffset;
        ThreadLocalPoolingMemoryManager.assertValidAddress(address);
        byte header = this.getBlockHeader(address);
        boolean available = ThreadLocalPoolingMemoryManager.isHeaderAvailable(header);
        if (!available) {
            return false;
        }
        int size = ThreadLocalPoolingMemoryManager.decodeSizeFromHeader(header);
        if (size != expectedSize || size < this.minBlockSize) {
            return false;
        }
        int offset = this.getOffsetWithinPage(address);
        boolean bl = validOffset = offset >= 0 && QuickMath.modPowerOfTwo(offset, size) == 0 && this.isPageBaseAddress(address - (long)offset);
        if (SHADOW_HEADER_ENABLED && validOffset) {
            this.validateShadowHeader(address, size, header);
        }
        return validOffset;
    }

    private byte getBlockHeader(long blockAddress) {
        long headerAddress = this.toHeaderAddress(blockAddress);
        return this.getBlockHeaderByHeaderAddress(headerAddress);
    }

    private byte getBlockHeaderByHeaderAddress(long headerAddress) {
        return GlobalMemoryAccessorRegistry.AMEM.getByte(headerAddress);
    }

    private void writeShadowBlockHeader(long blockAddress, int size, byte header) {
        if (SHADOW_HEADER_ENABLED) {
            ThreadLocalPoolingMemoryManager.trace("writeShadowBlockHeader: %d, %d, %s", blockAddress, size, header);
            assert (header == 0 || ThreadLocalPoolingMemoryManager.decodeSizeFromHeader(header) == size) : "Mismatch between block size=" + size + " and size from header=" + ThreadLocalPoolingMemoryManager.decodeSizeFromHeader(header);
            GlobalMemoryAccessorRegistry.AMEM.putByte(blockAddress + (long)size - 2L, header);
        }
    }

    private void validateShadowHeader(long address, int size, byte header) {
        if (SHADOW_HEADER_ENABLED) {
            assert (header == 0 || ThreadLocalPoolingMemoryManager.decodeSizeFromHeader(header) == size) : "Mismatch between block size=" + size + " and size from header=" + ThreadLocalPoolingMemoryManager.decodeSizeFromHeader(header);
            byte shadowHeader = GlobalMemoryAccessorRegistry.AMEM.getByte(address + (long)size - 2L);
            assert (shadowHeader == header) : "Invalid shadow header, expected " + header + ", was " + shadowHeader + ", address=" + address + ", size from header=" + ThreadLocalPoolingMemoryManager.decodeSizeFromHeader(header);
        }
    }

    @Override
    protected long getSizeInternal(long address) {
        byte header = this.getBlockHeader(address);
        return ThreadLocalPoolingMemoryManager.isExternalBlockHeader(header) ? this.findSizeOfExternalAllocation(address) : (long)ThreadLocalPoolingMemoryManager.decodeSizeFromHeader(header);
    }

    @Override
    protected int getOffsetWithinPage(long address) {
        return GlobalMemoryAccessorRegistry.AMEM.getInt(address);
    }

    @Override
    protected int getQueueMergeThreshold(AddressQueue queue) {
        return queue.capacity() / 3;
    }

    @Override
    protected Counter newCounter() {
        return new ThreadLocalCounter();
    }

    long toHeaderAddress(long address) {
        if (this.isPageBaseAddress(address)) {
            return address + (long)this.pageSize - 1L;
        }
        return address - 1L;
    }

    private boolean isLegalInternalBlockSize(int size) {
        return size >= this.minBlockSize && size <= this.pageSize;
    }

    private boolean isLegalPageOffsetAndSize(int pageOffset, int size) {
        return pageOffset >= 0 && pageOffset + size <= this.pageSize;
    }

    private boolean isAddressAvailable(long address) {
        return ThreadLocalPoolingMemoryManager.isHeaderAvailable(this.getBlockHeader(address));
    }

    private boolean isPageBaseAddress(long address) {
        return this.pageAllocations.contains(address);
    }

    private long findSizeOfExternalAllocation(long address) {
        return this.externalAllocations.get(address - 8L);
    }

    private void addToSortedAllocations(long address) {
        long len = this.pageAllocations.size();
        if (this.sortedPageAllocations.length() == len) {
            long newArrayLen = this.sortedPageAllocations.length() << 1;
            this.sortedPageAllocations.expand(newArrayLen);
        }
        this.sortedPageAllocations.set(len - 1L, address);
        this.pageAllocationsSorter.gotoAddress(this.sortedPageAllocations.address()).sort(0L, len);
    }

    private long searchForOwningPage(long address) {
        long low = 0L;
        long high = this.pageAllocations.size() - 1L;
        while (low <= high) {
            long middle = low + high >>> 1;
            long pageBase = this.sortedPageAllocations.get(middle);
            long pageEnd = pageBase + (long)this.pageSize - 1L;
            if (address > pageEnd) {
                low = middle + 1L;
                continue;
            }
            if (address < pageBase) {
                high = middle - 1L;
                continue;
            }
            assert (pageBase > 0L) : String.format("sortedPageAllocations is corrupt because it contains address %x", pageBase);
            return pageBase;
        }
        return 0L;
    }

    private void disposePageAllocations() {
        if (!this.pageAllocations.isEmpty()) {
            LongCursor cursor = this.pageAllocations.cursor();
            while (cursor.advance()) {
                this.freePage(cursor.value());
            }
        }
        this.pageAllocations.dispose();
    }

    private void disposeExternalAllocations() {
        if (!this.externalAllocations.isEmpty()) {
            LongLongCursor cursor = this.externalAllocations.cursor();
            while (cursor.advance()) {
                long address = cursor.key();
                long size = cursor.value();
                this.pageAllocator.free(address, size);
            }
        }
        this.externalAllocations.dispose();
    }

    private int getStoredPageOffset(long address, int size) {
        assert (this.isLegalInternalBlockSize(size)) : String.format("Header of block at address %x, with decoded size %x, is corrupt because the decoded size is outside its legal range", address, size);
        return GlobalMemoryAccessorRegistry.AMEM.getInt(ThreadLocalPoolingMemoryManager.addressOfStoredPageOffset(address, size));
    }

    static byte setHasStoredPageOffset(byte unavailableHeader) {
        return Bits.setBit(unavailableHeader, 5);
    }

    static byte unsetHasStoredPageOffset(byte header) {
        return Bits.clearBit(header, 5);
    }

    static byte encodeSize(int size) {
        return (byte)QuickMath.log2(size);
    }

    static byte createAvailableHeader(int size) {
        return Bits.setBit(ThreadLocalPoolingMemoryManager.encodeSize(size), 6);
    }

    static byte makeHeaderAvailable(byte header) {
        return ThreadLocalPoolingMemoryManager.unsetHasStoredPageOffset(Bits.setBit(header, 6));
    }

    static byte makeHeaderUnavailable(byte header, boolean canStorePageOffset) {
        byte newHeader = canStorePageOffset ? ThreadLocalPoolingMemoryManager.setHasStoredPageOffset(header) : ThreadLocalPoolingMemoryManager.unsetHasStoredPageOffset(header);
        return Bits.clearBit(newHeader, 6);
    }

    static byte markAsExternalBlockHeader(byte header) {
        return Bits.setBit(header, 7);
    }

    static long addressOfStoredPageOffset(long blockBase, int blockSize) {
        return blockBase + (long)blockSize - 8L;
    }

    private static boolean isHeaderAvailable(byte header) {
        return Bits.isBitSet(header, 6);
    }

    private static boolean isExternalBlockHeader(byte header) {
        return Bits.isBitSet(header, 7);
    }

    private static boolean hasStoredPageOffset(byte header) {
        return Bits.isBitSet(header, 5);
    }

    private static int decodeSizeFromHeader(byte header) {
        return 1 << (header & 0x1F);
    }

    private final class ThreadAddressQueue
    implements AddressQueue {
        private static final float RESIZE_CAPACITY_THRESHOLD = 0.75f;
        private final int index;
        private final int memorySize;
        private LongArrayQueue queue;
        private long lastGC;
        private long lastResize;

        ThreadAddressQueue(int index, int memorySize) {
            if (memorySize <= 0) {
                throw new IllegalArgumentException();
            }
            this.index = index;
            this.memorySize = memorySize;
        }

        @Override
        public boolean beforeCompaction() {
            return true;
        }

        @Override
        public void afterCompaction() {
        }

        @Override
        public long acquire() {
            if (this.queue != null) {
                this.shrink(false);
                return this.queue.poll();
            }
            return 0L;
        }

        private void shrink(boolean force) {
            int capacity = this.queue.capacity();
            if (capacity > 1024 && (float)this.queue.remainingCapacity() > (float)capacity * 0.75f) {
                long now = Clock.currentTimeMillis();
                if (force || now > this.lastResize + SHRINK_INTERVAL) {
                    this.queue = this.resizeQueue(this.queue, this.queue.capacity() >> 1, true);
                    this.lastResize = now;
                }
            }
        }

        @Override
        public boolean release(long address) {
            if (address == 0L) {
                throw new IllegalArgumentException("Illegal memory address: " + address);
            }
            if (this.queue == null) {
                this.queue = this.resizeQueue(null, 1024, true);
                this.lastResize = Clock.currentTimeMillis();
            } else if (this.queue.remainingCapacity() == 0) {
                long now = Clock.currentTimeMillis();
                if (now > this.lastGC + 1000L) {
                    ThreadLocalPoolingMemoryManager.this.compact(this);
                    this.lastGC = now;
                }
                if (this.queue.remainingCapacity() == 0) {
                    this.queue = this.resizeQueue(this.queue, this.queue.capacity() << 1, true);
                    this.lastResize = now;
                }
            }
            boolean offered = this.queue.offer(address);
            assert (offered) : "Cannot offer!";
            return true;
        }

        private LongArrayQueue resizeQueue(LongArrayQueue current, int newCap, boolean purge) {
            LongArrayQueue queue;
            try {
                if (current != null && current.isAvailable()) {
                    queue = new LongArrayQueue((MemoryAllocator)ThreadLocalPoolingMemoryManager.this.systemAllocator, newCap, current);
                    current.dispose();
                } else {
                    queue = new LongArrayQueue((MemoryAllocator)ThreadLocalPoolingMemoryManager.this.systemAllocator, newCap, 0L);
                }
            }
            catch (NativeOutOfMemoryError e) {
                if (purge) {
                    try {
                        return this.purgeEmptySpaceAndResizeQueue(current, newCap);
                    }
                    catch (OutOfMemoryError oome) {
                        OutOfMemoryErrorDispatcher.onOutOfMemory(oome);
                    }
                    catch (NativeOutOfMemoryError oome) {
                        throw oome;
                    }
                    catch (Throwable t) {
                        throw new NativeOutOfMemoryError("Cannot expand internal memory pool even though purging and compacting are applied: " + t.getMessage(), e);
                    }
                }
                throw new NativeOutOfMemoryError("Cannot expand internal memory pool: " + e.getMessage(), e);
            }
            return queue;
        }

        private LongArrayQueue purgeEmptySpaceAndResizeQueue(LongArrayQueue current, int newCap) {
            ThreadLocalPoolingMemoryManager.this.compact();
            this.purgeEmptySpace();
            return this.resizeQueue(current, newCap, false);
        }

        private void purgeEmptySpace() {
            for (AddressQueue addressQueue : ThreadLocalPoolingMemoryManager.this.addressQueues) {
                ThreadAddressQueue q = (ThreadAddressQueue)addressQueue;
                if (q == this) continue;
                if (q.remaining() == 0) {
                    q.destroy();
                    continue;
                }
                q.shrink(true);
            }
        }

        @Override
        public int remaining() {
            return this.queue != null ? this.queue.size() : 0;
        }

        @Override
        public int capacity() {
            return this.queue != null ? this.queue.capacity() : 1024;
        }

        @Override
        public void destroy() {
            if (this.queue == null) {
                return;
            }
            this.queue.dispose();
            this.queue = null;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "ThreadAddressQueue{name=" + ThreadLocalPoolingMemoryManager.this.threadName + ", memorySize=" + Capacity.toPrettyString(this.memorySize) + ", queue=" + String.valueOf(this.queue) + "}";
        }

        @Override
        public int getMemorySize() {
            return this.memorySize;
        }
    }

    private static final class ThreadLocalCounter
    implements Counter {
        private long value;

        private ThreadLocalCounter() {
        }

        @Override
        public long get() {
            return this.value;
        }

        @Override
        public void set(long value) {
            this.value = value;
        }

        @Override
        public long getAndSet(long newValue) {
            long oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public long inc() {
            return ++this.value;
        }

        @Override
        public long inc(long amount) {
            this.value += amount;
            return this.value;
        }
    }
}

