/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory;

import com.hazelcast.internal.memory.AddressQueue;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.memory.PooledNativeMemoryStats;
import com.hazelcast.internal.memory.PoolingMemoryManager;
import com.hazelcast.internal.memory.StandardMemoryManager;
import com.hazelcast.internal.memory.impl.LibMalloc;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.NativeOutOfMemoryError;

public abstract class AbstractPoolingMemoryManager
implements HazelcastMemoryManager,
MemoryAllocator {
    public static final String PROPERTY_DEBUG_ENABLED = "hazelcast.memory.manager.pooling.debug.enabled";
    protected static final int EXTERNAL_BLOCK_HEADER_SIZE = 8;
    static final boolean ASSERTION_ENABLED = AbstractPoolingMemoryManager.class.desiredAssertionStatus();
    protected static final boolean SHADOW_HEADER_ENABLED = ASSERTION_ENABLED && (System.getProperty("hazelcast.memory.manager.pooling.debug.enabled") == null || Boolean.getBoolean("hazelcast.memory.manager.pooling.debug.enabled"));
    private static final boolean TRACE_ENABLED = false;
    private static final int STRING_BUILDER_DEFAULT_CAPACITY = 1024;
    protected final MemoryAllocator pageAllocator;
    final MetadataMemoryAllocator systemAllocator;
    final TieredStoreMemoryAllocator tstoreAllocator;
    final int minBlockSize;
    final int pageSize;
    final int minBlockSizePower;
    final AddressQueue[] addressQueues;
    final PooledNativeMemoryStats memoryStats;
    private final Counter sequenceGenerator;

    AbstractPoolingMemoryManager(int minBlockSize, int pageSize, LibMalloc malloc, PooledNativeMemoryStats stats) {
        PoolingMemoryManager.checkBlockAndPageSize(minBlockSize, pageSize);
        this.memoryStats = stats;
        this.minBlockSize = minBlockSize;
        this.pageSize = pageSize;
        this.minBlockSizePower = QuickMath.log2(minBlockSize);
        int length = QuickMath.log2(pageSize) - this.minBlockSizePower + 1;
        this.addressQueues = new AddressQueue[length];
        this.pageAllocator = new StandardMemoryManager(malloc, stats);
        this.systemAllocator = new MetadataMemoryAllocator(malloc, stats);
        this.tstoreAllocator = new TieredStoreMemoryAllocator(malloc, stats);
        this.sequenceGenerator = this.newCounter();
    }

    @Override
    public final long allocate(long size) {
        long address;
        AddressQueue queue = this.getAddressQueue(size);
        if (queue != null) {
            int memorySize = queue.getMemorySize();
            do {
                address = this.acquireInternal(queue);
                AbstractPoolingMemoryManager.assertValidAddress(address);
            } while (!this.markUnavailable(address, (int)size, memorySize));
            assert (!this.isAvailable(address));
            this.memoryStats.addInternalFragmentation((long)memorySize - size);
            size = memorySize;
        } else {
            address = this.allocateExternalBlock(size);
            this.memoryStats.addInternalFragmentation(8L);
            size += 8L;
        }
        this.memoryStats.addUsedNativeMemory(size);
        return address;
    }

    @Override
    public long reallocate(long address, long currentSize, long newSize) {
        long newAddress = this.allocate(newSize);
        long size = Math.min(currentSize, newSize);
        GlobalMemoryAccessorRegistry.AMEM.copyMemory(address, newAddress, size);
        if (newSize > currentSize) {
            long startAddress = newAddress + currentSize;
            GlobalMemoryAccessorRegistry.AMEM.setMemory(startAddress, newSize - currentSize, (byte)0);
        }
        this.free(address, currentSize);
        return newAddress;
    }

    @Override
    public final void free(long address, long size) {
        AbstractPoolingMemoryManager.assertValidAddress(address);
        AddressQueue queue = this.getAddressQueue(size);
        if (queue != null) {
            int memorySize = queue.getMemorySize();
            AbstractPoolingMemoryManager.zeroOut(address, size);
            if (this.isAvailable(address)) {
                throw new AssertionError((Object)("Double free() -> address: " + address + ", size: " + size));
            }
            assert ((long)memorySize == this.getSizeInternal(address)) : "Size mismatch -> header: " + this.getSizeInternal(address) + ", param: " + memorySize;
            this.memoryStats.removeInternalFragmentation((long)memorySize - size);
            this.markAvailable(address);
            this.releaseInternal(queue, address);
            size = memorySize;
        } else {
            this.freeExternalBlock(address, size);
            this.memoryStats.removeInternalFragmentation(8L);
            size += 8L;
        }
        this.memoryStats.removeUsedNativeMemory(size);
    }

    @Override
    public final MemoryStats getMemoryStats() {
        return this.memoryStats;
    }

    @Override
    public final MemoryAllocator getSystemAllocator() {
        return this.systemAllocator;
    }

    @Override
    public MemoryAllocator getTieredStoreAllocator() {
        return this.tstoreAllocator;
    }

    @Override
    public final void compact() {
        for (AddressQueue queue : this.addressQueues) {
            this.compact(queue);
        }
    }

    @Override
    public final long getAllocatedSize(long address) {
        if (ASSERTION_ENABLED) {
            return this.validateAndGetAllocatedSize(address);
        }
        return this.getSizeInternal(address);
    }

    @Override
    public final long getUsableSize(long address) {
        if (ASSERTION_ENABLED) {
            return this.validateAndGetUsableSize(address);
        }
        long allocatedSize = this.getAllocatedSize(address);
        if (allocatedSize == -1L) {
            return -1L;
        }
        if (allocatedSize > (long)this.pageSize) {
            return allocatedSize - 8L;
        }
        return allocatedSize - (long)this.headerSize();
    }

    @Override
    public final long validateAndGetUsableSize(long address) {
        long allocatedSize = this.validateAndGetAllocatedSize(address);
        return allocatedSize == -1L ? -1L : (allocatedSize <= (long)this.pageSize ? allocatedSize - (long)this.headerSize() : allocatedSize - 8L);
    }

    @Override
    public final long newSequence() {
        return this.sequenceGenerator.inc();
    }

    protected final AddressQueue getAddressQueue(long size) {
        if (size <= 0L) {
            throw new IllegalArgumentException("Size must be positive: " + size);
        }
        if ((size += (long)this.headerSize()) > (long)this.pageSize) {
            return null;
        }
        int size32 = Math.max((int)size, this.minBlockSize);
        int powerOfTwoSize = QuickMath.nextPowerOfTwo(size32);
        int ix = QuickMath.log2(powerOfTwoSize) - this.minBlockSizePower;
        return this.addressQueues[ix];
    }

    protected final long acquireInternal(AddressQueue queue) {
        long address;
        int memorySize = queue.getMemorySize();
        while ((address = queue.acquire()) != 0L && !this.isValidAndAvailable(address, memorySize)) {
        }
        if (address == 0L) {
            try {
                address = this.splitFromNextQueue(queue);
            }
            catch (NativeOutOfMemoryError e) {
                this.onOome(e);
                throw e;
            }
        }
        return address;
    }

    protected final long toHeaderAddress(long blockBase, int pageOffset) {
        return (long)(pageOffset != 0 ? 0 : this.pageSize) + blockBase - (long)this.headerSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void compact(AddressQueue queue) {
        int remaining = queue.remaining();
        if (remaining == 0) {
            return;
        }
        if (!queue.beforeCompaction()) {
            return;
        }
        try {
            for (int i = 0; i < remaining; ++i) {
                long address = queue.acquire();
                if (address == 0L) {
                    break;
                }
                if (!this.isValidAndAvailable(address, queue.getMemorySize()) || this.tryMergeBuddies(queue, address)) continue;
                queue.release(address);
            }
        }
        finally {
            queue.afterCompaction();
        }
    }

    protected final void freePage(long pageAddress) {
        this.pageAllocator.free(pageAddress, this.pageSize);
    }

    protected abstract void initialize(long var1, int var3, int var4);

    protected abstract long allocateExternalBlock(long var1);

    protected abstract void freeExternalBlock(long var1, long var3);

    protected abstract AddressQueue createAddressQueue(int var1, int var2);

    protected abstract int headerSize();

    protected abstract Counter newCounter();

    protected abstract int getQueueMergeThreshold(AddressQueue var1);

    protected abstract void onOome(NativeOutOfMemoryError var1);

    protected abstract void onMallocPage(long var1);

    protected abstract void markAvailable(long var1);

    protected abstract boolean markUnavailable(long var1, int var3, int var4);

    protected abstract boolean isAvailable(long var1);

    protected abstract boolean markInvalid(long var1, int var3, int var4);

    protected abstract boolean isValidAndAvailable(long var1, int var3);

    protected abstract long getSizeInternal(long var1);

    protected abstract int getOffsetWithinPage(long var1);

    private long splitFromNextQueue(AddressQueue queue) {
        int offset;
        long address;
        int memorySize = queue.getMemorySize();
        if (memorySize == this.pageSize) {
            long address2 = this.pageAllocator.allocate(this.pageSize);
            AbstractPoolingMemoryManager.zeroOut(address2, this.pageSize);
            this.onMallocPage(address2);
            this.initialize(address2, this.pageSize, 0);
            return address2;
        }
        AddressQueue nextQ = this.addressQueues[queue.getIndex() + 1];
        do {
            if ((address = this.acquireInternal(nextQ)) == 0L) {
                throw new NativeOutOfMemoryError("Not enough contiguous memory available, cannot acquire " + Capacity.toPrettyString(memorySize));
            }
            offset = this.getOffsetWithinPage(address);
        } while (!this.markInvalid(address, nextQ.getMemorySize(), offset));
        int offset2 = offset + memorySize;
        long address2 = address + (long)memorySize;
        this.initialize(address, memorySize, offset);
        this.initialize(address2, memorySize, offset2);
        queue.release(address2);
        return address;
    }

    private boolean tryMergeBuddies(AddressQueue queue, long address) {
        int memorySize = queue.getMemorySize();
        if (memorySize == this.pageSize) {
            return false;
        }
        int offset = this.getOffsetWithinPage(address);
        assert (QuickMath.modPowerOfTwo(offset, memorySize) == 0) : "Offset: " + offset + " must be factor of " + memorySize;
        int buddyIndex = offset / memorySize;
        long buddyAddress = buddyIndex % 2 == 0 ? address + (long)memorySize : address - (long)memorySize;
        AbstractPoolingMemoryManager.trace("tryMergeBuddies: %d and %d, memorySize: %d, buddyIndex: %d", address, buddyAddress, memorySize, buddyIndex);
        if (!this.isValidAndAvailable(buddyAddress, memorySize)) {
            return false;
        }
        if (!this.markInvalid(address, memorySize, offset)) {
            return false;
        }
        int buddyOffset = this.getOffsetWithinPage(buddyAddress);
        if (!this.markInvalid(buddyAddress, memorySize, buddyOffset)) {
            this.initialize(address, memorySize, offset);
            return false;
        }
        AddressQueue nextQ = this.addressQueues[queue.getIndex() + 1];
        if (address < buddyAddress) {
            this.initialize(address, nextQ.getMemorySize(), offset);
            this.releaseInternal(nextQ, address);
        } else {
            this.initialize(buddyAddress, nextQ.getMemorySize(), buddyOffset);
            this.releaseInternal(nextQ, buddyAddress);
        }
        return true;
    }

    final void initializeAddressQueues() {
        for (int i = 0; i < this.addressQueues.length; ++i) {
            this.addressQueues[i] = this.createAddressQueue(i, 1 << i + this.minBlockSizePower);
        }
    }

    private void releaseInternal(AddressQueue queue, long address) {
        int remaining = queue.remaining();
        if (remaining >= this.getQueueMergeThreshold(queue) && this.tryMergeBuddies(queue, address)) {
            return;
        }
        queue.release(address);
    }

    private static void zeroOut(long address, long size) {
        AbstractPoolingMemoryManager.assertValidAddress(address);
        assert (size > 0L) : "Invalid size: " + size;
        GlobalMemoryAccessorRegistry.AMEM.setMemory(address, size, (byte)0);
    }

    static void assertValidAddress(long address) {
        assert (address > 0L) : String.format("Illegal memory address %x", address);
    }

    public final double getFragmentationRatio(int size) {
        if (size <= 0 || size > this.pageSize) {
            return 0.0;
        }
        long free = this.memoryStats.getFreeNative();
        if (free == 0L) {
            return 0.0;
        }
        size = Math.max(size, this.minBlockSize);
        int powerOfTwoSize = QuickMath.nextPowerOfTwo(size);
        int ix = QuickMath.log2(powerOfTwoSize) - this.minBlockSizePower;
        long orderTotal = 0L;
        for (int i = ix; i < this.addressQueues.length; ++i) {
            AddressQueue q = this.addressQueues[i];
            orderTotal += (long)q.remaining() * (long)q.getMemorySize();
        }
        return (double)(free - orderTotal) / (double)free;
    }

    public final String dump() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(this.memoryStats);
        sb.append(":: PoolingMemoryManager ::").append('\n');
        boolean hasQueue = false;
        for (AddressQueue queue : this.addressQueues) {
            int remaining = queue.remaining();
            if (remaining <= 0) continue;
            for (int i = 0; i < remaining; ++i) {
                long address = queue.acquire();
                if (!this.isValidAndAvailable(address, queue.getMemorySize())) continue;
                queue.release(address);
            }
            if (queue.remaining() <= 0) continue;
            hasQueue = true;
            sb.append("\tQueue[").append(Capacity.toPrettyString(queue.getMemorySize())).append("]: ").append(queue.remaining()).append('\n');
        }
        if (!hasQueue) {
            sb.append(" ALL QUEUES ARE EMPTY!").append('\n');
        }
        return sb.toString();
    }

    protected static void trace(String message) {
    }

    protected static void trace(String format, Object arg1) {
    }

    protected static void trace(String format, Object arg1, Object arg2) {
    }

    protected static void trace(String format, Object arg1, Object arg2, Object arg3) {
    }

    protected static void trace(String format, Object arg1, Object arg2, Object arg3, Object arg4) {
    }

    public static final class MetadataMemoryAllocator
    implements MemoryAllocator {
        private final LibMalloc malloc;
        private final PooledNativeMemoryStats memoryStats;

        public MetadataMemoryAllocator(LibMalloc malloc, PooledNativeMemoryStats memoryStats) {
            this.malloc = malloc;
            this.memoryStats = memoryStats;
        }

        @Override
        public long allocate(long size) {
            this.memoryStats.getMemoryAdjuster().adjustMetadataMemory(size);
            long address = this.malloc.malloc(size);
            this.checkAddress(address, size);
            GlobalMemoryAccessorRegistry.AMEM.setMemory(address, size, (byte)0);
            this.memoryStats.addMetadataUsage(size);
            return address;
        }

        @Override
        public void free(long address, long size) {
            this.malloc.free(address);
            this.memoryStats.removeMetadataUsage(size);
        }

        @Override
        public long reallocate(long address, long currentSize, long newSize) {
            long diff = newSize - currentSize;
            if (diff > 0L) {
                this.memoryStats.getMemoryAdjuster().adjustMetadataMemory(diff);
            }
            long newAddress = this.malloc.realloc(address, newSize);
            this.checkAddress(newAddress, newSize);
            if (diff > 0L) {
                long startAddress = newAddress + currentSize;
                GlobalMemoryAccessorRegistry.AMEM.setMemory(startAddress, diff, (byte)0);
            }
            this.memoryStats.addMetadataUsage(diff);
            return newAddress;
        }

        private void checkAddress(long address, long size) {
            if (address == 0L) {
                throw new NativeOutOfMemoryError("Not enough contiguous memory available!Cannot acquire " + Capacity.toPrettyString(size) + "!");
            }
        }

        @Override
        public void dispose() {
        }
    }

    public static final class TieredStoreMemoryAllocator
    implements MemoryAllocator {
        private final LibMalloc malloc;
        private final PooledNativeMemoryStats memoryStats;

        public TieredStoreMemoryAllocator(LibMalloc malloc, PooledNativeMemoryStats memoryStats) {
            this.malloc = malloc;
            this.memoryStats = memoryStats;
        }

        @Override
        public long allocate(long size) {
            this.memoryStats.getMemoryAdjuster().adjustTstoreMemory(size);
            long address = this.malloc.malloc(size);
            this.checkAddress(address, size);
            GlobalMemoryAccessorRegistry.AMEM.setMemory(address, size, (byte)0);
            this.memoryStats.addUsedNativeMemory(size);
            return address;
        }

        @Override
        public void free(long address, long size) {
            this.malloc.free(address);
            this.memoryStats.removeTSNativeUsage(size);
        }

        @Override
        public long reallocate(long address, long currentSize, long newSize) {
            long diff = newSize - currentSize;
            if (diff > 0L) {
                this.memoryStats.getMemoryAdjuster().adjustTstoreMemory(diff);
            }
            long newAddress = this.malloc.realloc(address, newSize);
            this.checkAddress(newAddress, newSize);
            if (diff > 0L) {
                long startAddress = newAddress + currentSize;
                GlobalMemoryAccessorRegistry.AMEM.setMemory(startAddress, diff, (byte)0);
            }
            this.memoryStats.addUsedNativeMemory(diff);
            return newAddress;
        }

        private void checkAddress(long address, long size) {
            if (address == 0L) {
                throw new NativeOutOfMemoryError("Not enough contiguous memory available!Cannot acquire " + Capacity.toPrettyString(size) + "!");
            }
        }

        @Override
        public void dispose() {
        }
    }
}

