/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.events;

import com.hazelcast.internal.diagnostics.DiagnosticsConfig;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.management.events.AbstractEventBase;
import com.hazelcast.internal.management.events.EventMetadata;
import java.util.UUID;

public class DiagnosticsConfigUpdatedEvent
extends AbstractEventBase {
    protected DiagnosticsConfig diagnosticsConfig;
    protected UUID memberId;

    public DiagnosticsConfigUpdatedEvent(DiagnosticsConfig diagnosticsConfig, UUID memberId) {
        this.diagnosticsConfig = diagnosticsConfig;
        this.memberId = memberId;
    }

    @Override
    public EventMetadata.EventType getType() {
        return EventMetadata.EventType.DIAGNOSTICS_CONFIG_UPDATED;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("enabled", this.diagnosticsConfig.isEnabled());
        json.add("max-rolled-file-size-in-mb", this.diagnosticsConfig.getMaxRolledFileSizeInMB());
        json.add("max-rolled-file-count", this.diagnosticsConfig.getMaxRolledFileCount());
        json.add("include-epoch-time", this.diagnosticsConfig.isIncludeEpochTime());
        json.add("log-directory", this.diagnosticsConfig.getLogDirectory());
        json.add("file-name-prefix", this.diagnosticsConfig.getFileNamePrefix());
        json.add("output-type", this.diagnosticsConfig.getOutputType().name());
        json.add("auto-off-timer-in-minutes", this.diagnosticsConfig.getAutoOffDurationInMinutes());
        json.add("member-id", this.memberId.toString());
        JsonObject properties = new JsonObject();
        for (String key : this.diagnosticsConfig.getPluginProperties().keySet()) {
            properties.add(key, this.diagnosticsConfig.getPluginProperties().get(key));
        }
        json.add("plugin-properties", properties);
        return json;
    }
}

