/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.io;

import com.hazelcast.internal.hotrestart.impl.io.FileCopyStrategy;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class HardLinkCopyStrategy
implements FileCopyStrategy {
    @Override
    public void copy(File source, File target) {
        try {
            File destination = target.isDirectory() ? new File(target, source.getName()) : target;
            Files.createLink(destination.toPath(), source.toPath());
        }
        catch (IOException | SecurityException e) {
            throw new UnsupportedOperationException("createLink is not suppported", e);
        }
    }
}

