/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.chunk;

import com.hazelcast.internal.hotrestart.impl.gc.chunk.ActiveValChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.EmptyLongSet;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.util.collection.LongSet;

public final class StableValChunk
extends StableChunk {
    public final LongSet clearedPrefixesFoundAtRestart;

    public StableValChunk(ActiveValChunk from) {
        super(from);
        this.clearedPrefixesFoundAtRestart = EmptyLongSet.emptyLongSet();
    }

    public StableValChunk(long seq, RecordMap records, int liveRecordCount, long size, long garbage, boolean needsDismissing) {
        this(seq, records, EmptyLongSet.emptyLongSet(), liveRecordCount, size, garbage, needsDismissing);
    }

    public StableValChunk(long seq, RecordMap records, LongSet clearedPrefixesFoundAtRestart, int liveRecordCount, long size, long garbage, boolean needsDismissing) {
        super(seq, records, liveRecordCount, size, garbage, needsDismissing);
        this.clearedPrefixesFoundAtRestart = clearedPrefixesFoundAtRestart.isEmpty() ? EmptyLongSet.emptyLongSet() : clearedPrefixesFoundAtRestart;
    }

    public long cost() {
        return this.size() - this.garbage;
    }

    public double updateBenefitToCost(long currChunkSeq) {
        this.benefitToCost = this.benefitToCost(currChunkSeq);
        return this.benefitToCost;
    }

    private double benefitToCost(long currChunkSeq) {
        double benefit = this.garbage;
        double cost = this.cost();
        if (cost == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double age = currChunkSeq - this.seq;
        return age * benefit / cost;
    }
}

