/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.chunk;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.ActiveChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableValChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.WriteThroughChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileOut;

public class ActiveValChunk
extends WriteThroughChunk
implements ActiveChunk {
    public ActiveValChunk(long seq, RecordMap records, ChunkFileOut out, GcHelper gcHelper) {
        super(seq, ".active", records, out, gcHelper);
    }

    @Override
    public boolean addStep1(long recordSeq, long keyPrefix, byte[] keyBytes, byte[] valueBytes) {
        assert (this.hasRoom());
        this.out.writeValueRecord(recordSeq, keyPrefix, keyBytes, valueBytes);
        this.grow(24 + keyBytes.length + valueBytes.length);
        return this.full();
    }

    @Override
    public StableValChunk toStableChunk() {
        return new StableValChunk(this);
    }

    @Override
    public void insertOrUpdate(long recordSeq, long keyPrefix, KeyHandle kh, int ignored, int size) {
        this.insertOrUpdateValue(recordSeq, keyPrefix, kh, size);
    }

    @Override
    protected int determineSizeLimit() {
        return ActiveValChunk.valChunkSizeLimit();
    }
}

