/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkPriorityQueue;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.gc.GcParams;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.PrefixTombstoneManager;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.Chunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableValChunk;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.internal.util.collection.LongHashSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class ValChunkSelector {
    static final int INITIAL_TOP_CHUNKS = 128;
    private static final Comparator<StableValChunk> BY_SEQ_DESC = new Comparator<StableValChunk>(){

        @Override
        public int compare(StableValChunk left, StableValChunk right) {
            long leftSeq = left.seq;
            long rightSeq = right.seq;
            return leftSeq > rightSeq ? -1 : (leftSeq < rightSeq ? 1 : 0);
        }
    };
    private final Collection<StableChunk> allChunks;
    private final GcParams gcp;
    @Inject
    private PrefixTombstoneManager pfixTombstoMgr;
    @Inject
    private MutatorCatchup mc;
    @Inject
    private GcLogger logger;

    ValChunkSelector(Collection<StableChunk> allChunks, GcParams gcp) {
        this.allChunks = allChunks;
        this.gcp = gcp;
    }

    Collection<StableValChunk> select() {
        Object status;
        int initialChunksToFind;
        Set<StableValChunk> candidates = this.candidateChunks();
        if (candidates.isEmpty()) {
            return candidates;
        }
        ArrayList<StableValChunk> srcChunks = new ArrayList<StableValChunk>();
        long benefit = 0L;
        long cost = 0L;
        int chunksToFind = initialChunksToFind = this.gcp.limitSrcChunks ? 128 : candidates.size();
        int liveRecordCount = 0;
        block0: while (true) {
            for (StableValChunk c : this.topChunks(candidates, chunksToFind)) {
                this.mc.catchupAsNeeded();
                this.pfixTombstoMgr.dismissGarbage(c);
                srcChunks.add(c);
                candidates.remove(c);
                String statusIfAny = this.status(benefit += c.garbage, cost += c.cost(), liveRecordCount += c.liveRecordCount);
                if (statusIfAny == null) continue;
                status = statusIfAny;
                break block0;
            }
            if (candidates.isEmpty()) {
                if (cost > 0L && cost < this.gcp.minCost) {
                    srcChunks.clear();
                    return srcChunks;
                }
                status = "all candidates chosen, " + (cost == 0L ? "zero cost" : "some goals not reached");
                break;
            }
            if (srcChunks.size() == initialChunksToFind) {
                if (cost == 0L) {
                    status = "max candidates chosen, zero cost";
                    break;
                }
                if (!this.gcp.forceGc) {
                    status = "max candidates chosen, some goals not reached";
                    break;
                }
            }
            if (chunksToFind < 0x3FFFFFFF) {
                chunksToFind <<= 1;
            }
            this.logger.finestVerbose("Finding " + chunksToFind + " more top chunks");
        }
        if ((double)benefit / (double)cost < this.gcp.minBenefitToCost) {
            srcChunks.clear();
            return srcChunks;
        }
        ValChunkSelector.diagnoseChunks(this.allChunks, srcChunks, this.gcp, this.logger);
        this.logger.finest("GC: %s; about to reclaim %,d B at cost %,d B from %,d chunks out of %,d", status, benefit, cost, srcChunks.size(), this.allChunks.size());
        return srcChunks;
    }

    private Set<StableValChunk> candidateChunks() {
        HashSet<StableValChunk> candidates = new HashSet<StableValChunk>(this.allChunks.size());
        for (StableChunk chunk : this.allChunks) {
            StableValChunk stableValChunk;
            if (!(chunk instanceof StableValChunk) || (stableValChunk = (StableValChunk)chunk).size() != 0L && stableValChunk.garbage <= 0L) continue;
            stableValChunk.updateBenefitToCost(this.gcp.currChunkSeq);
            candidates.add(stableValChunk);
        }
        return candidates;
    }

    private List<StableValChunk> topChunks(Set<StableValChunk> candidates, int limit) {
        if (candidates.size() <= limit) {
            ArrayList<StableValChunk> sortedChunks = new ArrayList<StableValChunk>(candidates);
            Collections.sort(sortedChunks, StableChunk.BY_BENEFIT_COST_DESC);
            this.mc.catchupNow();
            return sortedChunks;
        }
        ChunkPriorityQueue topChunks = new ChunkPriorityQueue(limit);
        for (StableValChunk c : candidates) {
            this.mc.catchupAsNeeded();
            topChunks.offer(c);
        }
        StableValChunk[] result = new StableValChunk[topChunks.size()];
        for (int i = result.length - 1; i >= 0; --i) {
            this.mc.catchupAsNeeded();
            result[i] = topChunks.pop();
        }
        return Arrays.asList(result);
    }

    private String status(long garbage, long cost, int liveRecordCount) {
        return cost > this.gcp.maxCost ? String.format("max cost exceeded: will output %,d bytes", cost) : (liveRecordCount > 0x100000 ? String.format("max record count exceeded: will copy %,d records", liveRecordCount) : (cost >= this.gcp.costGoal && garbage >= this.gcp.benefitGoal ? "reached all goals" : null));
    }

    static void diagnoseChunks(Collection<StableChunk> allChunks, Collection<? extends StableChunk> selectedChunks, GcParams gcp, GcLogger logger) {
        if (!logger.isFinestVerboseEnabled()) {
            return;
        }
        ArrayList<StableValChunk> valChunks = new ArrayList<StableValChunk>(allChunks.size());
        int tombChunkCount = 0;
        for (StableChunk stableChunk : allChunks) {
            if (!(stableChunk instanceof StableValChunk)) {
                ++tombChunkCount;
                continue;
            }
            StableValChunk stableValChunk = (StableValChunk)stableChunk;
            stableValChunk.updateBenefitToCost(gcp.currChunkSeq);
            valChunks.add(stableValChunk);
        }
        Collections.sort(valChunks, BY_SEQ_DESC);
        LongHashSet selectedSeqs = new LongHashSet(selectedChunks.size(), -1L);
        for (StableChunk stableChunk : selectedChunks) {
            selectedSeqs.add(stableChunk.seq);
        }
        StringWriter stringWriter = new StringWriter(512);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.format("%nValue chunks %,d Tombstone chunks: %,d", valChunks.size(), tombChunkCount);
        printWriter.format("%n seq age        CB factor  recCount%n", new Object[0]);
        for (StableValChunk c : valChunks) {
            printWriter.format("%4x %3d %,15.2f    %,7d %s %s%n", c.seq, QuickMath.log2(gcp.currChunkSeq - c.seq), c.cachedBenefitToCost(), c.liveRecordCount, selectedSeqs.contains(c.seq) ? "X" : " ", ValChunkSelector.visualizedChunk(c.garbage, c.size(), Chunk.valChunkSizeLimit()));
        }
        logger.finestVerbose(stringWriter.toString());
    }

    private static String visualizedChunk(long garbage, long size, int chunkSize) {
        int chunkLimitChars = 16;
        int bytesPerChar = chunkSize / 16;
        StringBuilder b = new StringBuilder(24).append('|');
        long garbageChars = garbage / (long)bytesPerChar;
        long sizeChars = size / (long)bytesPerChar;
        int i = 0;
        while ((long)i < sizeChars) {
            b.append((long)i <= garbageChars ? (char)'-' : '#');
            ++i;
        }
        return b.toString();
    }
}

