/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.HotRestartKey;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManager;
import com.hazelcast.internal.hotrestart.impl.gc.GcExecutor;
import com.hazelcast.internal.hotrestart.impl.gc.GcMainLoop;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.ActiveChunk;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyorSingleQueue;
import java.io.File;

public final class GcExecutorImpl
implements GcExecutor {
    private final ChunkManager chunkMgr;
    private final Object testGcMutex;
    private final ConcurrentConveyorSingleQueue<Runnable> conveyor;
    private final Thread gcThread;
    private final MutatorCatchup mc;

    @Inject
    GcExecutorImpl(@Name(value="gcConveyor") ConcurrentConveyorSingleQueue<Runnable> gcConveyor, ChunkManager chunkMgr, MutatorCatchup mc, GcMainLoop mainLoop, @Name(value="storeName") String storeName, @Name(value="testGcMutex") Object testGcMutex) {
        this.chunkMgr = chunkMgr;
        this.gcThread = new Thread((Runnable)mainLoop, storeName + ".GC-thread");
        this.conveyor = gcConveyor;
        this.mc = mc;
        this.testGcMutex = testGcMutex;
    }

    @Override
    public void start() {
        this.gcThread.start();
    }

    @Override
    public void shutdown() {
        this.conveyor.submit(() -> {
            this.mc.askedToStop = true;
        });
        this.conveyor.awaitDrainerGone();
    }

    @Override
    public void submitRecord(HotRestartKey key, long freshSeq, int freshSize, boolean freshIsTombstone) {
        this.conveyor.submit(() -> this.chunkMgr.addRecord(key, freshSeq, freshSize, freshIsTombstone));
    }

    @Override
    public void submitReplaceActiveChunk(ActiveChunk closed, ActiveChunk fresh) {
        this.conveyor.submit(() -> this.chunkMgr.replaceActiveChunk(fresh, closed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWhileGcPaused(MutatorCatchup.CatchupRunnable task) {
        Object object = this.testGcMutex;
        synchronized (object) {
            task.run(this.mc);
        }
    }

    @Override
    public void submitBackup(File targetDir) {
        this.conveyor.submit(() -> this.chunkMgr.backupChunks(targetDir));
    }
}

