/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.impl.gc.BackupTask;
import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.persistence.BackupTaskState;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BackupExecutor
implements Disposable {
    private static final VarHandle CURRENT_BACKUP_TASK = ReflectionUtil.findVarHandle("currentBackupTask", BackupTask.class);
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private volatile Thread currentBackupThread;
    private volatile BackupTask currentBackupTask;
    private final BackupTask taskReservation = new BackupTask(null, "reservationStore", EMPTY_LONG_ARRAY, EMPTY_LONG_ARRAY);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock rl = this.lock.readLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(BackupTask task) {
        if (this.inProgress()) {
            return;
        }
        Thread thread = new Thread(task);
        Lock wl = this.lock.writeLock();
        wl.lock();
        try {
            this.currentBackupTask = task;
            this.currentBackupThread = thread;
            this.currentBackupThread.start();
        }
        finally {
            wl.unlock();
        }
    }

    @Override
    public void dispose() {
        this.interruptBackupTask(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptBackupTask(boolean waitForCompletion) {
        BackupTask backupTask;
        Thread thread;
        this.rl.lock();
        try {
            thread = this.currentBackupThread;
            backupTask = this.currentBackupTask;
        }
        finally {
            this.rl.unlock();
        }
        if (backupTask != null && thread == null) {
            backupTask.setToFailedState();
        } else if (this.inProgress(thread)) {
            thread.interrupt();
            if (waitForCompletion) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public boolean inProgress() {
        Thread thread = null;
        this.rl.lock();
        try {
            thread = this.currentBackupThread;
        }
        finally {
            this.rl.unlock();
        }
        return this.inProgress(thread);
    }

    public boolean prepareForNewTask() {
        BackupTask currentTask;
        this.rl.lock();
        try {
            currentTask = this.currentBackupTask;
        }
        finally {
            this.rl.unlock();
        }
        BackupTaskState taskState = currentTask != null ? currentTask.getBackupState() : BackupTaskState.NO_TASK;
        return !taskState.inProgress() && CURRENT_BACKUP_TASK.compareAndSet(this, currentTask, this.taskReservation);
    }

    public BackupTaskState getBackupTaskState() {
        BackupTask currentTask;
        this.rl.lock();
        try {
            currentTask = this.currentBackupTask;
        }
        finally {
            this.rl.unlock();
        }
        return currentTask != null ? currentTask.getBackupState() : BackupTaskState.NO_TASK;
    }

    public long getBackupTaskMaxChunkSeq() {
        BackupTask currentTask;
        this.rl.lock();
        try {
            currentTask = this.currentBackupTask;
        }
        finally {
            this.rl.unlock();
        }
        return currentTask != null ? currentTask.getMaxChunkSeq() : Long.MIN_VALUE;
    }

    public boolean isBackupTaskDone() {
        return !this.getBackupTaskState().inProgress();
    }

    private boolean inProgress(Thread thread) {
        return thread != null && thread.isAlive();
    }
}

