/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.HotRestartKey;
import com.hazelcast.internal.hotrestart.impl.RunnableWithStatus;
import com.hazelcast.internal.hotrestart.impl.di.DiContainer;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.hotrestart.impl.encryption.EncryptionManager;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManager;
import com.hazelcast.internal.hotrestart.impl.gc.GcExecutor;
import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.PrefixTombstoneManager;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.ActiveChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.Chunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.logging.ILogger;
import java.io.File;

public final class HotRestartPersistenceEngine
implements AutoCloseable {
    private final Disposable di;
    private final GcExecutor gcExec;
    private final GcHelper gcHelper;
    private final PrefixTombstoneManager pfixTombstoMgr;
    private final EncryptionManager encryptionMgr;
    private ActiveChunk activeValChunk;
    private ActiveChunk activeTombChunk;

    @Inject
    HotRestartPersistenceEngine(DiContainer di, GcExecutor gcExec, GcHelper gcHelper, PrefixTombstoneManager pfixTombstoMgr, EncryptionManager encryptionMgr) {
        this.di = di;
        this.gcExec = gcExec;
        this.gcHelper = gcHelper;
        this.pfixTombstoMgr = pfixTombstoMgr;
        this.encryptionMgr = encryptionMgr;
    }

    public void start(ILogger logger, ChunkManager chunkMgr, @Name(value="storeName") String name) {
        this.activeValChunk = this.gcHelper.newActiveValChunk();
        this.activeTombChunk = this.gcHelper.newActiveTombChunk();
        this.gcExec.submitReplaceActiveChunk(null, this.activeValChunk);
        this.gcExec.submitReplaceActiveChunk(null, this.activeTombChunk);
        this.gcExec.start();
        logger.info(String.format("%s reloaded %,d keys; chunk seq %03x", name, chunkMgr.trackedKeyCount(), ((Chunk)((Object)this.activeValChunk)).seq));
    }

    void put(HotRestartKey kh, byte[] value, boolean needsFsync) {
        this.put0(kh, value, needsFsync);
    }

    void remove(HotRestartKey key, boolean needsFsync) {
        this.put0(key, null, needsFsync);
    }

    void backup(File targetDir) {
        this.pfixTombstoMgr.backup(targetDir);
        this.encryptionMgr.backup(targetDir);
        this.replaceActiveChunk(this.activeValChunk, false);
        this.replaceActiveChunk(this.activeTombChunk, true);
        this.gcExec.submitBackup(targetDir);
    }

    void rotateMasterEncryptionKey(byte[] key) {
        this.encryptionMgr.rotateMasterKey(key);
    }

    private void put0(HotRestartKey hrKey, byte[] value, boolean needsFsync) {
        if (this.activeValChunk == null) {
            throw new HotRestartException("Hot restart not yet complete");
        }
        int size = Record.size(hrKey.bytes(), value);
        long seq = this.gcHelper.nextRecordSeq();
        boolean isTombstone = value == null;
        ActiveChunk activeChunk = isTombstone ? this.activeTombChunk : this.activeValChunk;
        activeChunk.flagForFsyncOnClose(needsFsync);
        this.gcExec.submitRecord(hrKey, seq, size, isTombstone);
        boolean full = activeChunk.addStep1(seq, hrKey.prefix(), hrKey.bytes(), value);
        if (full) {
            this.replaceActiveChunk(activeChunk, isTombstone);
        }
    }

    private void replaceActiveChunk(ActiveChunk activeChunk, boolean isTombstone) {
        ActiveChunk inactiveChunk = activeChunk;
        if (isTombstone) {
            this.activeTombChunk = null;
            inactiveChunk.close();
            this.activeTombChunk = activeChunk = this.gcHelper.newActiveTombChunk();
        } else {
            this.activeValChunk = null;
            inactiveChunk.close();
            this.activeValChunk = activeChunk = this.gcHelper.newActiveValChunk();
        }
        this.gcExec.submitReplaceActiveChunk(inactiveChunk, activeChunk);
    }

    void fsync() {
        this.activeValChunk.fsync();
        this.activeTombChunk.fsync();
    }

    void clear(boolean needsFsync, long ... keyPrefixes) {
        if (keyPrefixes.length != 0 && this.gcHelper.recordSeq() != 0L) {
            this.pfixTombstoMgr.addPrefixTombstones(keyPrefixes, needsFsync);
        }
    }

    @Override
    public void close() {
        this.closeAndDeleteIfEmpty(this.activeValChunk);
        this.activeValChunk = null;
        this.closeAndDeleteIfEmpty(this.activeTombChunk);
        this.activeTombChunk = null;
        this.gcExec.shutdown();
        this.di.dispose();
    }

    private void closeAndDeleteIfEmpty(ActiveChunk chunk) {
        if (chunk == null) {
            return;
        }
        chunk.close();
        if (chunk.size() == 0L) {
            this.gcHelper.deleteChunkFile(chunk.toStableChunk());
        }
    }

    final class RotateMasterEncryptionKey
    extends RunnableWithStatus {
        private final byte[] key;

        RotateMasterEncryptionKey(byte[] key) {
            super(true);
            this.key = key;
        }

        @Override
        public void run() {
            HotRestartPersistenceEngine.this.rotateMasterEncryptionKey(this.key);
        }
    }

    final class Clear
    extends RunnableWithStatus {
        final long[] prefixes;
        final boolean needsFsync;

        Clear(long[] prefixes, boolean needsFsync) {
            super(!needsFsync);
            this.prefixes = prefixes;
            this.needsFsync = needsFsync;
        }

        @Override
        public void run() {
            HotRestartPersistenceEngine.this.clear(this.needsFsync, this.prefixes);
        }
    }

    final class Backup
    extends RunnableWithStatus {
        private final File targetDir;

        Backup(File targetDir) {
            super(true);
            this.targetDir = targetDir;
        }

        @Override
        public void run() {
            HotRestartPersistenceEngine.this.backup(this.targetDir);
        }
    }

    final class Remove
    extends RunnableWithStatus {
        final HotRestartKey key;
        final boolean needsFsync;

        Remove(HotRestartKey key, boolean needsFsync) {
            super(!needsFsync);
            this.key = key;
            this.needsFsync = needsFsync;
        }

        @Override
        public void run() {
            HotRestartPersistenceEngine.this.remove(this.key, this.needsFsync);
        }

        public String toString() {
            return String.format("Put: needsFsync %b key %s", this.needsFsync, this.key);
        }
    }

    final class Put
    extends RunnableWithStatus {
        final HotRestartKey key;
        final byte[] value;
        final boolean needsFsync;

        Put(HotRestartKey key, byte[] value, boolean needsFsync) {
            super(!needsFsync);
            this.key = key;
            this.value = value;
            this.needsFsync = needsFsync;
        }

        @Override
        public void run() {
            HotRestartPersistenceEngine.this.put(this.key, this.value, this.needsFsync);
        }

        public String toString() {
            return String.format("Put: needsFsync %b key %s value.length %s", this.needsFsync, this.key, this.value.length);
        }
    }
}

