/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl;

import com.hazelcast.internal.hotrestart.HotRestartStore;
import com.hazelcast.internal.hotrestart.RamStoreRegistry;
import com.hazelcast.internal.hotrestart.impl.ConcurrentHotRestartStore;
import com.hazelcast.internal.hotrestart.impl.HotRestartPersistenceEngine;
import com.hazelcast.internal.hotrestart.impl.HotRestartStoreConfig;
import com.hazelcast.internal.hotrestart.impl.di.DiContainer;
import com.hazelcast.internal.hotrestart.impl.encryption.EncryptionManager;
import com.hazelcast.internal.hotrestart.impl.gc.BackupExecutor;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManager;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManagerImpl;
import com.hazelcast.internal.hotrestart.impl.gc.GcExecutor;
import com.hazelcast.internal.hotrestart.impl.gc.GcExecutorImpl;
import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.gc.GcMainLoop;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.PrefixTombstoneManager;
import com.hazelcast.internal.hotrestart.impl.gc.Snapshotter;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordDataHolder;
import com.hazelcast.internal.hotrestart.impl.io.TombFileAccessor;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyorSingleQueue;
import com.hazelcast.internal.util.concurrent.ManyToOneConcurrentArrayQueue;
import com.hazelcast.internal.util.concurrent.OneToOneConcurrentArrayQueue;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;

public final class HotRestartModule {
    private HotRestartModule() {
    }

    public static HotRestartStore newOnHeapHotRestartStore(HotRestartStoreConfig cfg, HazelcastProperties properties) {
        return HotRestartModule.hrStore(cfg, false, properties);
    }

    public static HotRestartStore newOffHeapHotRestartStore(HotRestartStoreConfig cfg, HazelcastProperties properties) {
        return HotRestartModule.hrStore(cfg, true, properties);
    }

    private static HotRestartStore hrStore(HotRestartStoreConfig cfg, boolean isOffHeap, HazelcastProperties properties) {
        int gcCollectorQueueCapacity = Preconditions.checkPositive("gcCollectorQueueCapacity", properties.getInteger(GcExecutor.GC_COLLECTOR_QUEUE_CAPACITY));
        int mutatorQueueCapacity = Preconditions.checkPositive("mutatorQueueCapacity", properties.getInteger(HotRestartStore.MUTATOR_QUEUE_CAPACITY));
        try {
            Class.forName(TombFileAccessor.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtil.rethrow(e);
        }
        catch (ExceptionInInitializerError e) {
            throw ExceptionUtil.rethrow(e.getCause() != null ? e.getCause() : e);
        }
        cfg.logger().info(cfg.storeName() + " homeDir: " + String.valueOf(cfg.homeDir()));
        cfg.validateAndCreateHomeDir();
        DiContainer di = new DiContainer();
        if (isOffHeap) {
            MemoryAllocator malloc = cfg.malloc();
            if (malloc == null) {
                throw new IllegalArgumentException("cfg.malloc is null");
            }
            di.dep(MemoryAllocator.class, malloc);
        }
        Class gcHelperClass = isOffHeap ? GcHelper.OffHeap.class : GcHelper.OnHeap.class;
        di.dep(di).dep(HazelcastProperties.class, properties).dep(new BackupExecutor()).disposable().dep("storeName", cfg.storeName()).dep("homeDir", cfg.homeDir()).dep(RamStoreRegistry.class, cfg.ramStoreRegistry()).dep(MetricsRegistry.class, cfg.metricsRegistry()).dep(ILogger.class, cfg.logger()).dep("testGcMutex", new Object()).dep(new RecordDataHolder()).dep(cfg.encryptionConfig()).dep(EncryptionManager.class).dep("mutatorQueueCapacity", Integer.valueOf(mutatorQueueCapacity)).dep("gcCollectorQueueCapacity", Integer.valueOf(gcCollectorQueueCapacity)).dep(GcLogger.class).dep(GcHelper.class, gcHelperClass).disposable().dep("persistenceConveyor", ConcurrentConveyorSingleQueue.concurrentConveyorSingleQueue(null, new ManyToOneConcurrentArrayQueue(mutatorQueueCapacity))).dep("gcConveyor", ConcurrentConveyorSingleQueue.concurrentConveyorSingleQueue(null, new OneToOneConcurrentArrayQueue(gcCollectorQueueCapacity))).dep(ChunkManager.class, ChunkManagerImpl.class).disposable().dep(Snapshotter.class).dep(MutatorCatchup.class).dep(PrefixTombstoneManager.class).dep(GcMainLoop.class).dep(GcExecutor.class, GcExecutorImpl.class).dep(HotRestartPersistenceEngine.class);
        di.wireAndInitializeAll();
        return di.instantiate(ConcurrentHotRestartStore.class);
    }
}

