/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hidensity.impl;

import com.hazelcast.internal.elastic.SlottableIterator;
import com.hazelcast.internal.elastic.map.SampleableElasticHashMap;
import com.hazelcast.internal.eviction.EvictableStore;
import com.hazelcast.internal.eviction.EvictionCandidate;
import com.hazelcast.internal.eviction.EvictionListener;
import com.hazelcast.internal.eviction.Expirable;
import com.hazelcast.internal.eviction.ExpirationChecker;
import com.hazelcast.internal.hidensity.HiDensityRecord;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.hidensity.impl.DefaultHiDensityRecordMap;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.Clock;
import java.util.ArrayList;

public class EvictableHiDensityRecordMap<R extends HiDensityRecord & Expirable>
extends DefaultHiDensityRecordMap<R>
implements EvictableStore<Data, R>,
EvictionListener<Data, R> {
    protected static final int ONE_HUNDRED_PERCENT = 100;
    protected static final int MIN_EVICTION_ELEMENT_COUNT = 10;
    protected final NativeMemoryData keyHolder = new NativeMemoryData();

    public EvictableHiDensityRecordMap(int initialCapacity, HiDensityRecordProcessor<R> recordProcessor, HiDensityStorageInfo storageInfo) {
        super(initialCapacity, recordProcessor, storageInfo);
    }

    public <C extends EvictionCandidate<Data, R>> int forceEvict(int evictionPercentage, EvictionListener<Data, R> evictionListener) {
        int size = this.size();
        if (evictionPercentage < 0 || size == 0) {
            return 0;
        }
        int evictCount = (int)((long)size * (long)evictionPercentage / 100L);
        evictCount = Math.max(evictCount, 10);
        SlottableIterator<Data> iter2 = this.newRandomEvictionKeyIterator();
        return this.forceEvict(iter2, evictionListener, evictCount);
    }

    private int forceEvict(SlottableIterator<Data> iterator, EvictionListener<Data, R> evictionListener, int evictCount) {
        int evictedEntryCount = 0;
        while (iterator.hasNext()) {
            iterator.nextSlot();
            int slot = iterator.getCurrentSlot();
            this.keyHolder.reset(this.accessor.getKey(slot));
            HiDensityRecord value = (HiDensityRecord)this.recordProcessor.read(this.accessor.getValue(slot));
            this.onEvict(this.keyHolder, (R)value, false);
            if (evictionListener != null) {
                evictionListener.onEvict(this.keyHolder, value, false);
            }
            iterator.remove();
            if (++evictedEntryCount < evictCount) continue;
            break;
        }
        return evictedEntryCount;
    }

    public void sampleAndDeleteExpired(EvictionListener<Data, R> evictionListener, ExpirationChecker<R> expirationChecker, int sampleCount) {
        assert (evictionListener != null);
        long now = Clock.currentTimeMillis();
        ArrayList<MemoryBlock> expiredDataKeyAndRecordPairs = new ArrayList<MemoryBlock>();
        Iterable randomSamples = this.getRandomSamples(sampleCount);
        for (SampleableElasticHashMap.SamplingEntry sampledEntry : randomSamples) {
            NativeMemoryData dataKey = sampledEntry.getEntryKey();
            HiDensityRecord record = (HiDensityRecord)sampledEntry.getEntryValue();
            if (!this.hasRecordExpired(record, expirationChecker, now)) continue;
            expiredDataKeyAndRecordPairs.add(dataKey);
            expiredDataKeyAndRecordPairs.add(record);
        }
        for (int i = 0; i < expiredDataKeyAndRecordPairs.size(); i += 2) {
            NativeMemoryData dataKey = (NativeMemoryData)expiredDataKeyAndRecordPairs.get(i);
            HiDensityRecord record = (HiDensityRecord)expiredDataKeyAndRecordPairs.get(i + 1);
            evictionListener.onEvict(dataKey, record, true);
            this.delete(dataKey);
            this.recordProcessor.disposeData(dataKey);
        }
    }

    private boolean hasRecordExpired(R record, ExpirationChecker<R> expirationChecker, long now) {
        if (expirationChecker != null) {
            return expirationChecker.isExpired(record);
        }
        return ((Expirable)record).isExpiredAt(now);
    }

    @Override
    public <C extends EvictionCandidate<Data, R>> boolean tryEvict(C evictionCandidate, EvictionListener<Data, R> evictionListener) {
        if (evictionCandidate == null) {
            return false;
        }
        Data key = evictionCandidate.getAccessor();
        MemoryBlock removedRecord = this.remove(key);
        if (removedRecord != null) {
            this.onEvict(key, (R)removedRecord, false);
            if (evictionListener != null) {
                evictionListener.onEvict(key, removedRecord, false);
            }
            this.recordProcessor.dispose(removedRecord);
        }
        this.recordProcessor.disposeData(key);
        return removedRecord != null;
    }

    @Override
    public void onEvict(Data evictedEntryAccessor, R evictedEntry, boolean wasExpired) {
    }
}

