/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hidensity;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class HiDensityStorageInfo {
    private final String storageName;
    @Probe(name="usedMemory", level=ProbeLevel.MANDATORY, unit=ProbeUnit.BYTES)
    private final AtomicLong usedMemory = new AtomicLong();
    @Probe(name="forceEvictionCount", level=ProbeLevel.MANDATORY)
    private final AtomicLong forceEvictionCount = new AtomicLong();
    @Probe(name="forceEvictedEntryCount", level=ProbeLevel.MANDATORY)
    private final AtomicLong forceEvictedEntryCount = new AtomicLong();
    @Probe(name="entryCount", level=ProbeLevel.MANDATORY)
    private final AtomicLong entryCount = new AtomicLong();

    public HiDensityStorageInfo(String storageName) {
        this.storageName = storageName;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public long addEntryCount(long count) {
        return this.entryCount.addAndGet(count);
    }

    public long removeEntryCount(long count) {
        return this.entryCount.addAndGet(-count);
    }

    public long increaseEntryCount() {
        return this.entryCount.incrementAndGet();
    }

    public long decreaseEntryCount() {
        return this.entryCount.decrementAndGet();
    }

    public long getEntryCount() {
        return this.entryCount.get();
    }

    public long addUsedMemory(long size) {
        return this.usedMemory.addAndGet(size);
    }

    public long removeUsedMemory(long size) {
        return this.usedMemory.addAndGet(-size);
    }

    public long getUsedMemory() {
        return this.usedMemory.get();
    }

    public long increaseForceEvictionCount() {
        return this.forceEvictionCount.incrementAndGet();
    }

    public long getForceEvictionCount() {
        return this.forceEvictionCount.get();
    }

    public void increaseForceEvictedEntryCount(long evictedEntryCount) {
        this.forceEvictedEntryCount.addAndGet(evictedEntryCount);
    }

    public long getForceEvictedEntryCount() {
        return this.forceEvictedEntryCount.get();
    }

    public int hashCode() {
        return this.storageName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HiDensityStorageInfo)) {
            return false;
        }
        return this.storageName.equals(((HiDensityStorageInfo)obj).storageName);
    }

    public String toString() {
        return "HiDensityStorageInfo{storageName='" + this.storageName + "', usedMemory=" + this.usedMemory.get() + ", forceEvictionCount=" + this.forceEvictionCount.get() + ", forceEvictedEntryCount=" + this.forceEvictedEntryCount.get() + ", entryCount=" + this.entryCount.get() + "}";
    }
}

