/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.queue;

import com.hazelcast.internal.elastic.LongIterator;
import com.hazelcast.internal.elastic.queue.LongQueue;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public final class LongLinkedBlockingQueue
implements LongQueue {
    private static final long NULL_PTR = 0L;
    private static final int NODE_SIZE = 16;
    private static final int NEXT_OFFSET = 8;
    private final MemoryAllocator malloc;
    private final long nullItem;
    private long head;
    private long tail;
    private final AtomicLong size = new AtomicLong();
    private final ReentrantLock headLock = new ReentrantLock();
    private final ReentrantLock tailLock = new ReentrantLock();

    public LongLinkedBlockingQueue(MemoryAllocator malloc, long nullValue) {
        this.malloc = malloc;
        this.nullItem = nullValue;
        this.tail = this.head = this.newNode(this.nullItem);
    }

    private long newNode(long e) {
        long address = this.malloc.allocate(16L);
        GlobalMemoryAccessorRegistry.AMEM.putLong(null, address, e);
        GlobalMemoryAccessorRegistry.AMEM.putLong(null, address + 8L, 0L);
        return address;
    }

    private static long getItem(long node) {
        assert (node != 0L);
        return GlobalMemoryAccessorRegistry.AMEM.getLong(node);
    }

    private static long getNextNode(long node) {
        assert (node != 0L);
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(node + 8L);
    }

    private static void setNextNode(long node, long value) {
        assert (node != 0L);
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(node + 8L, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(long value) {
        if (value == this.nullItem) {
            throw new IllegalArgumentException();
        }
        long node = this.newNode(value);
        this.tailLock.lock();
        try {
            if (this.tail == 0L) {
                this.malloc.free(node, 16L);
            }
            this.ensureTail();
            LongLinkedBlockingQueue.setNextNode(this.tail, node);
            this.tail = node;
            this.size.getAndIncrement();
        }
        finally {
            this.tailLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long poll() {
        long item;
        long node;
        this.headLock.lock();
        try {
            this.ensureHead();
            node = this.head;
            long newHead = LongLinkedBlockingQueue.getNextNode(node);
            if (newHead == 0L) {
                long l = this.nullItem;
                return l;
            }
            item = LongLinkedBlockingQueue.getItem(newHead);
            this.head = newHead;
            this.size.getAndDecrement();
        }
        finally {
            this.headLock.unlock();
        }
        this.malloc.free(node, 16L);
        assert (item != this.nullItem) : "Item in the queue cannot be null";
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long peek() {
        if (this.size.get() == 0L) {
            return this.nullItem;
        }
        this.headLock.lock();
        try {
            this.ensureHead();
            long first = LongLinkedBlockingQueue.getNextNode(this.head);
            if (first == 0L) {
                long l = this.nullItem;
                return l;
            }
            long l = LongLinkedBlockingQueue.getItem(first);
            return l;
        }
        finally {
            this.headLock.unlock();
        }
    }

    @Override
    public int size() {
        long c = this.size.get();
        return c < Integer.MAX_VALUE ? (int)c : Integer.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0L;
    }

    @Override
    public int capacity() {
        throw new UnsupportedOperationException("Capacity is not supported");
    }

    @Override
    public int remainingCapacity() {
        throw new UnsupportedOperationException("Capacity is not supported");
    }

    @Override
    public void clear() {
        this.fullLock();
        try {
            while (this.poll() != this.nullItem) {
            }
        }
        finally {
            this.fullUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.fullLock();
        try {
            if (this.head != 0L) {
                this.clear();
                long headPtr = this.head;
                long tailPtr = this.tail;
                this.head = 0L;
                this.tail = 0L;
                assert (headPtr == tailPtr);
                if (headPtr != 0L) {
                    this.malloc.free(headPtr, 16L);
                }
            }
        }
        finally {
            this.fullUnlock();
        }
    }

    @Override
    public long nullItem() {
        return this.nullItem;
    }

    @Override
    public LongIterator iterator() {
        throw new UnsupportedOperationException();
    }

    private void ensureHead() {
        if (this.head == 0L) {
            throw new IllegalStateException("Queue is already destroyed! " + String.valueOf(this));
        }
    }

    private void ensureTail() {
        if (this.tail == 0L) {
            throw new IllegalStateException("Queue is already destroyed! " + String.valueOf(this));
        }
    }

    private void fullUnlock() {
        this.tailLock.unlock();
        this.headLock.unlock();
    }

    private void fullLock() {
        this.headLock.lock();
        this.tailLock.lock();
    }

    public String toString() {
        return "LongLinkedBlockingQueue{size=" + this.size.get() + "}";
    }
}

