/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.map;

import com.hazelcast.internal.elastic.map.BinaryElasticHashMap;
import com.hazelcast.internal.elastic.map.ElasticMap;
import com.hazelcast.internal.elastic.map.NativeBehmSlotAccessorFactory;
import com.hazelcast.internal.elastic.map.NativeMemoryDataAccessor;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.memory.NativeOutOfMemoryError;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentElasticHashMap<K, V>
implements ElasticMap<K, V>,
ConcurrentMap<K, V> {
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final int MAX_SEGMENTS = 65536;
    private final EnterpriseSerializationService ss;
    private final int segmentMask;
    private final int segmentShift;
    private final Segment<V>[] segments;

    public ConcurrentElasticHashMap(EnterpriseSerializationService ss, MemoryAllocator malloc) {
        this(16, 0.6f, 16, ss, malloc);
    }

    public ConcurrentElasticHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, EnterpriseSerializationService ss, MemoryAllocator malloc) {
        int cap;
        int ssize;
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        int c = initialCapacity / ssize;
        if (c * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        this.segments = new Segment[ssize];
        for (int i = 0; i < ssize; ++i) {
            this.segments[i] = new Segment(ss, cap, loadFactor, malloc);
        }
        this.ss = ss;
    }

    protected final Segment<V> segmentFor(Data key) {
        return this.segments[key.hashCode() >>> this.segmentShift & this.segmentMask];
    }

    @Override
    public V put(K key, V value) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        try {
            Segment<V> segment = this.segmentFor(k);
            V oldValue = segment.put(k, value);
            if (oldValue != null && k != key) {
                this.ss.disposeData(k);
            }
            return oldValue;
        }
        catch (NativeOutOfMemoryError e) {
            this.ss.disposeData(k);
            throw e;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean set(K key, V value) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        try {
            Segment<V> segment = this.segmentFor(k);
            boolean added = segment.set(k, value);
            if (!added && k != key) {
                this.ss.disposeData(k);
            }
            return added;
        }
        catch (NativeOutOfMemoryError e) {
            this.ss.disposeData(k);
            throw e;
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        try {
            Segment<V> segment = this.segmentFor(k);
            V oldValue = segment.putIfAbsent(k, value);
            if (oldValue != null && k != key) {
                this.ss.disposeData(k);
            }
            return oldValue;
        }
        catch (NativeOutOfMemoryError e) {
            this.ss.disposeData(k);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        Segment<V> segment = this.segmentFor(k);
        try {
            boolean bl = segment.replace(k, oldValue, newValue);
            return bl;
        }
        finally {
            this.ss.disposeData(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        Segment<V> segment = this.segmentFor(k);
        try {
            V v = segment.replace(k, value);
            return v;
        }
        finally {
            this.ss.disposeData(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object k = this.ss.toData(key, DataType.NATIVE);
        Segment<V> segment = this.segmentFor((Data)k);
        try {
            V v = segment.get((Data)k);
            return v;
        }
        finally {
            this.ss.disposeData((Data)k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Object k = this.ss.toData(key, DataType.NATIVE);
        Segment<V> segment = this.segmentFor((Data)k);
        try {
            V v = segment.remove((Data)k);
            return v;
        }
        finally {
            this.ss.disposeData((Data)k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(K key) {
        Object k = this.ss.toData(key, DataType.NATIVE);
        Segment<V> segment = this.segmentFor((Data)k);
        try {
            boolean bl = segment.delete((Data)k);
            return bl;
        }
        finally {
            this.ss.disposeData((Data)k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        Object k = this.ss.toData(key, DataType.NATIVE);
        Segment<Object> segment = this.segmentFor((Data)k);
        try {
            boolean bl = segment.remove((Data)k, value);
            return bl;
        }
        finally {
            this.ss.disposeData((Data)k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Object k = this.ss.toData(key, DataType.NATIVE);
        Segment<V> segment = this.segmentFor((Data)k);
        try {
            boolean bl = segment.containsKey((Data)k);
            return bl;
        }
        finally {
            this.ss.disposeData((Data)k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Object v = this.ss.toData(value, DataType.NATIVE);
        try {
            for (Segment<V> segment : this.segments) {
                if (!segment.containsValue((Data)v)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.ss.disposeData((Data)v);
        }
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int s = 0;
        for (Segment<V> segment : this.segments) {
            s += segment.size();
        }
        return s;
    }

    @Override
    public boolean isEmpty() {
        for (Segment<V> segment : this.segments) {
            if (segment.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        for (Segment<V> segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].destroy();
            this.segments[i] = null;
        }
    }

    protected static final class Segment<V> {
        final ReentrantLock lock = new ReentrantLock();
        final EnterpriseSerializationService ss;
        final BinaryElasticHashMap<NativeMemoryData> map;

        Segment(EnterpriseSerializationService ss, int initialCapacity, float loadFactor, MemoryAllocator malloc) {
            this.ss = ss;
            this.map = new BinaryElasticHashMap<NativeMemoryData>(initialCapacity, loadFactor, ss, new NativeBehmSlotAccessorFactory(), new NativeMemoryDataAccessor(ss), malloc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public V put(Data key, V value) {
            NativeMemoryData v = (NativeMemoryData)this.ss.toData(value, DataType.NATIVE);
            try {
                NativeMemoryData old;
                this.lock.lock();
                try {
                    old = this.map.put(key, v);
                }
                finally {
                    this.lock.unlock();
                }
                if (old == null) return null;
                try {
                    Object t = this.ss.toObject(old);
                    return (V)t;
                }
                finally {
                    this.ss.disposeData(old);
                }
            }
            catch (NativeOutOfMemoryError e) {
                this.ss.disposeData(v);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean set(Data key, V value) {
            NativeMemoryData v = (NativeMemoryData)this.ss.toData(value, DataType.NATIVE);
            this.lock.lock();
            try {
                boolean bl = this.map.set(key, v);
                this.lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.lock.unlock();
                    throw throwable;
                }
                catch (NativeOutOfMemoryError e) {
                    this.ss.disposeData(v);
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public V putIfAbsent(Data key, V value) {
            NativeMemoryData v = (NativeMemoryData)this.ss.toData(value, DataType.NATIVE);
            try {
                this.lock.lock();
                try {
                    NativeMemoryData current = this.map.putIfAbsent(key, v);
                    if (current != null) {
                        this.ss.disposeData(key);
                        this.ss.disposeData(v);
                        Object t = this.ss.toObject(current);
                        return (V)t;
                    }
                    V v2 = null;
                    return v2;
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (NativeOutOfMemoryError e) {
                this.ss.disposeData(v);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replace(Data key, V oldValue, V newValue) {
            NativeMemoryData o = null;
            NativeMemoryData n = null;
            try {
                o = (NativeMemoryData)this.ss.toData(oldValue, DataType.NATIVE);
                n = (NativeMemoryData)this.ss.toData(newValue, DataType.NATIVE);
                boolean replaced = false;
                this.lock.lock();
                try {
                    replaced = this.map.replace(key, o, n);
                }
                finally {
                    this.lock.unlock();
                }
                this.ss.disposeData(o);
                if (!replaced) {
                    this.ss.disposeData(n);
                }
                return replaced;
            }
            catch (NativeOutOfMemoryError e) {
                this.ss.disposeData(o);
                this.ss.disposeData(n);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public V replace(Data key, V value) {
            NativeMemoryData v = (NativeMemoryData)this.ss.toData(value, DataType.NATIVE);
            try {
                NativeMemoryData old;
                this.lock.lock();
                try {
                    old = this.map.replace(key, v);
                }
                finally {
                    this.lock.unlock();
                }
                if (old == null) {
                    this.ss.disposeData(v);
                    return null;
                }
                try {
                    Object t = this.ss.toObject(old);
                    return (V)t;
                }
                finally {
                    this.ss.disposeData(old);
                }
            }
            catch (NativeOutOfMemoryError e) {
                this.ss.disposeData(v);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V remove(Data key) {
            NativeMemoryData old;
            this.lock.lock();
            try {
                old = (NativeMemoryData)this.map.remove(key);
            }
            finally {
                this.lock.unlock();
            }
            if (old != null) {
                try {
                    Object t = this.ss.toObject(old);
                    return (V)t;
                }
                finally {
                    this.ss.disposeData(old);
                }
            }
            return null;
        }

        public boolean delete(Data key) {
            this.lock.lock();
            try {
                boolean bl = this.map.delete(key);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        public boolean remove(Data key, V value) {
            Object v = this.ss.toData(value, DataType.NATIVE);
            try {
                this.lock.lock();
                try {
                    boolean bl;
                    try {
                        bl = this.map.remove(key, v);
                    }
                    catch (Throwable throwable) {
                        this.ss.disposeData((Data)v);
                        throw throwable;
                    }
                    this.ss.disposeData((Data)v);
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (NativeOutOfMemoryError e) {
                this.ss.disposeData((Data)v);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(Data key) {
            this.lock.lock();
            try {
                NativeMemoryData v = (NativeMemoryData)this.map.get(key);
                V v2 = v != null ? (V)this.ss.toObject(v) : null;
                return v2;
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean containsKey(Data key) {
            this.lock.lock();
            try {
                boolean bl = this.map.containsKey(key);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean containsValue(Data value) {
            this.lock.lock();
            try {
                boolean bl = this.map.containsValue(value);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void clear() {
            this.lock.lock();
            try {
                this.map.clear();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void destroy() {
            this.lock.lock();
            try {
                this.map.dispose();
            }
            finally {
                this.lock.unlock();
            }
        }

        public int size() {
            this.lock.lock();
            try {
                int n = this.map.size();
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isEmpty() {
            this.lock.lock();
            try {
                boolean bl = this.map.isEmpty();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

