/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.management.dto.SlowOperationDTO;
import com.hazelcast.internal.management.dto.SlowOperationInvocationDTO;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SlowOperationPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.slowoperations.period.seconds", 60, TimeUnit.SECONDS);
    private final OperationServiceImpl operationService;
    private final HazelcastProperties properties;
    private long periodMillis;

    public SlowOperationPlugin(ILogger logger, OperationServiceImpl operationService, HazelcastProperties props) {
        super(logger);
        this.operationService = operationService;
        this.properties = props;
        this.readProperties();
    }

    private long readPeriodMillis() {
        if (!this.properties.getBoolean(ClusterProperty.SLOW_OPERATION_DETECTOR_ENABLED)) {
            return 0L;
        }
        return this.properties.getMillis(this.overrideProperty(PERIOD_SECONDS));
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.logger.info("Plugin:active, period-millis:" + this.periodMillis);
    }

    @Override
    public void onShutdown() {
        super.onShutdown();
        this.logger.info("Plugin:inactive");
    }

    @Override
    void readProperties() {
        this.periodMillis = this.readPeriodMillis();
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        if (!this.isActive()) {
            return;
        }
        List<SlowOperationDTO> slowOperations = this.operationService.getSlowOperationDTOs();
        writer.startSection("SlowOperations");
        if (!slowOperations.isEmpty()) {
            for (SlowOperationDTO slowOperation : slowOperations) {
                this.render(writer, slowOperation);
            }
        }
        writer.endSection();
    }

    private void render(DiagnosticsLogWriter writer, SlowOperationDTO slowOperation) {
        writer.startSection(slowOperation.operation);
        writer.writeKeyValueEntry("invocations", slowOperation.totalInvocations);
        this.renderStackTrace(writer, slowOperation);
        this.renderInvocations(writer, slowOperation);
        writer.endSection();
    }

    private void renderInvocations(DiagnosticsLogWriter writer, SlowOperationDTO slowOperation) {
        writer.startSection("slowInvocations");
        for (SlowOperationInvocationDTO invocation : slowOperation.invocations) {
            writer.writeKeyValueEntry("startedAt", invocation.startedAt);
            writer.writeKeyValueEntryAsDateTime("started(date-time)", invocation.startedAt);
            writer.writeKeyValueEntry("duration(ms)", invocation.durationMs);
            writer.writeKeyValueEntry("operationDetails", invocation.operationDetails);
        }
        writer.endSection();
    }

    private void renderStackTrace(DiagnosticsLogWriter writer, SlowOperationDTO slowOperation) {
        String[] stackTraceLines;
        writer.startSection("stackTrace");
        for (String stackTraceLine : stackTraceLines = slowOperation.stackTrace.split(System.lineSeparator())) {
            writer.writeEntry(stackTraceLine);
        }
        writer.endSection();
    }
}

