/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.operationservice.impl.InvocationMonitor;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class OperationHeartbeatPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.operation-heartbeat.seconds", 10, TimeUnit.SECONDS);
    public static final HazelcastProperty MAX_DEVIATION_PERCENTAGE = new HazelcastProperty("hazelcast.diagnostics.operation-heartbeat.max-deviation-percentage", 33);
    private static final float HUNDRED = 100.0f;
    private final ConcurrentMap<Address, AtomicLong> heartbeatPerMember;
    private final HazelcastProperties properties;
    private boolean mainSectionStarted;
    private long periodMillis;
    private int maxDeviationPercentage;
    private final long expectedIntervalMillis;

    public OperationHeartbeatPlugin(ILogger logger, InvocationMonitor invocationMonitor, HazelcastProperties properties) {
        super(logger);
        this.properties = properties;
        this.readProperties();
        this.expectedIntervalMillis = invocationMonitor.getHeartbeatBroadcastPeriodMillis();
        this.heartbeatPerMember = invocationMonitor.getHeartbeatPerMember();
        this.readProperties();
    }

    @Override
    void readProperties() {
        this.periodMillis = this.properties.getMillis(this.overrideProperty(PERIOD_SECONDS));
        this.maxDeviationPercentage = this.properties.getInteger(this.overrideProperty(MAX_DEVIATION_PERCENTAGE));
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.logger.info("Plugin:active: period-millis:" + this.periodMillis + " max-deviation:" + this.maxDeviationPercentage + "%");
    }

    @Override
    public void onShutdown() {
        super.onShutdown();
        this.logger.info("Plugin:inactive");
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        if (!this.isActive()) {
            return;
        }
        long nowMillis = System.currentTimeMillis();
        for (Map.Entry entry : this.heartbeatPerMember.entrySet()) {
            Address member = (Address)entry.getKey();
            long lastHeartbeatMillis = ((AtomicLong)entry.getValue()).longValue();
            long noHeartbeatMillis = nowMillis - lastHeartbeatMillis;
            float deviation = 100.0f * (float)(noHeartbeatMillis - this.expectedIntervalMillis) / (float)this.expectedIntervalMillis;
            if (deviation >= (float)this.maxDeviationPercentage) {
                this.startLazyMainSection(writer);
                writer.startSection("member" + String.valueOf(member));
                writer.writeKeyValueEntry("deviation(%)", deviation);
                writer.writeKeyValueEntry("noHeartbeat(ms)", noHeartbeatMillis);
                writer.writeKeyValueEntry("lastHeartbeat(ms)", lastHeartbeatMillis);
                writer.writeKeyValueEntryAsDateTime("lastHeartbeat(date-time)", lastHeartbeatMillis);
                writer.writeKeyValueEntry("now(ms)", nowMillis);
                writer.writeKeyValueEntryAsDateTime("now(date-time)", nowMillis);
                writer.endSection();
            }
            if (this.isActive()) continue;
            break;
        }
        this.endLazyMainSection(writer);
    }

    int getMaxDeviationPercentage() {
        return this.maxDeviationPercentage;
    }

    private void startLazyMainSection(DiagnosticsLogWriter writer) {
        if (!this.mainSectionStarted) {
            this.mainSectionStarted = true;
            writer.startSection("OperationHeartbeat");
        }
    }

    private void endLazyMainSection(DiagnosticsLogWriter writer) {
        if (this.mainSectionStarted) {
            this.mainSectionStarted = false;
            writer.endSection();
        }
    }
}

