/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class DiagnosticsPlugin {
    static final long RUN_ONCE_PERIOD_MS = -1L;
    static final long NOT_SCHEDULED_PERIOD_MS = 0L;
    protected final ILogger logger;
    final AtomicBoolean isActive = new AtomicBoolean(false);
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();

    protected DiagnosticsPlugin(ILogger logger) {
        this.logger = logger;
    }

    protected void setActive() {
        this.isActive.set(true);
    }

    protected void setInactive() {
        this.isActive.set(false);
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public abstract long getPeriodMillis();

    public void onStart() {
        this.setActive();
    }

    public void onShutdown() {
        this.setInactive();
    }

    public boolean canBeEnabledDynamically() {
        return true;
    }

    void setProperties(Map<String, String> props) {
        this.setProperties(props, true);
    }

    private void setProperties(Map<String, String> props, boolean refresh) {
        if (!this.isActive() && !this.properties.equals(props)) {
            this.properties.clear();
            this.properties.putAll(props);
            if (refresh) {
                this.readProperties();
            }
        }
    }

    abstract void readProperties();

    HazelcastProperty overrideProperty(HazelcastProperty property) {
        String value = this.properties.get(property.getName());
        if (value == null) {
            return property;
        }
        property.setSystemProperty(value);
        return property;
    }

    public abstract void run(DiagnosticsLogWriter var1);
}

