/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAddressTranslator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.compaction.CompactorMetrics;
import com.hazelcast.internal.tstore.compaction.IncrementalCompactor;
import com.hazelcast.internal.tstore.compaction.LogBasedCompactor;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.HybridLogIteratorType;
import com.hazelcast.internal.tstore.hybridlog.InMemorySlotAccessor;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.LogBasedHybridLogIterator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.properties.HazelcastProperties;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class TStoreBTreeCompactor
extends LogBasedCompactor<Void>
implements IncrementalCompactor {
    private static final int UNINITIALIZED = -1;
    private static final int EPOCH_REFRESH_MASK_SHIFT = 4;
    private static final int EPOCH_REFRESH_MASK = 15;
    protected final Epoch epoch;
    protected final ILogger logger;
    protected final Dependencies dependencies;
    protected int threadIndex;
    private final HybridLogImpl log;
    private final SlotAccessor slotAccessor;
    private final LogBasedHybridLogIterator<AddressPair, AddressPair> logIterator;
    private final HybridLogBTreeCompactorMetrics metrics = new HybridLogBTreeCompactorMetrics();
    private boolean hasNext = true;
    private boolean firstCompaction = true;

    public TStoreBTreeCompactor(int nodeSize, HybridLogImpl log, Epoch epoch, Dependencies dependencies, int segmentNo, HazelcastProperties properties) {
        super(log, segmentNo, properties);
        this.log = log;
        this.epoch = epoch;
        this.dependencies = dependencies;
        this.logger = Logger.getLogger(this.getClass());
        long fromLogicalAddress = log.firstEntry(segmentNo);
        long toLogicalAddressInclusive = this.device.segmentLastLogicalAddress(segmentNo);
        this.slotAccessor = new SlotAccessor(nodeSize);
        this.logIterator = new LogBasedHybridLogIterator<AddressPair, AddressPair>(log, fromLogicalAddress, toLogicalAddressInclusive, this.slotAccessor, HybridLogIteratorType.BOUNDED);
        this.onCompactionQueued();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact(boolean withTimeout) {
        Throwable throwable = null;
        long startCompactionNanos = System.nanoTime();
        if (this.firstCompaction) {
            this.firstCompaction = false;
            this.onCompactionStart();
        }
        try {
            this.threadIndex = this.registerOnEpoch();
            try {
                this.assertCompactionDoesNotHappenInMemoryRegion();
                this.setLastVisitedRecordCount(0);
                int visitedRecordCounter = 0;
                long startNanos = System.nanoTime();
                this.trySetToStateRunning();
                while (this.isInStateRunning()) {
                    this.failIfInterrupted();
                    if (!this.logIterator.hasNext()) {
                        this.hasNext = false;
                        break;
                    }
                    this.compact(this.threadIndex, this.logIterator.next());
                    if ((++visitedRecordCounter & 0xF) == 0) {
                        this.epoch.refresh(this.threadIndex);
                    }
                    if (!this.isTimedOut(startNanos, withTimeout)) continue;
                }
                this.setLastVisitedRecordCount(visitedRecordCounter);
            }
            finally {
                this.deregisterOnEpoch(this.threadIndex);
                if (!this.hasNext) {
                    this.logIterator.close();
                    this.triggerSegmentsDeletion();
                    this.device.onSegmentCompacted(this.segmentNo);
                    ((LocalStorageDevice)this.device).getCompactionStats().decrementCurrentOnDeviceSegmentCount();
                }
            }
        }
        catch (Throwable ex) {
            throwable = ex;
            throw ex;
        }
        finally {
            this.trySetCompactorStateToStopped();
            this.metrics.addCompactionDuration(System.nanoTime() - startCompactionNanos);
            if (throwable != null) {
                this.onCompactionFinish(throwable);
            } else if (!this.hasNext) {
                this.onCompactionFinish(null);
            }
        }
    }

    int registerOnEpoch() {
        return this.epoch.register();
    }

    void deregisterOnEpoch(int threadIndex) {
        this.epoch.unregister(threadIndex);
    }

    @Override
    public boolean isDone() {
        return this.logIterator.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(int threadIndex, AddressPair entry) {
        block7: {
            long lockAddress = this.dependencies.getLockAddress(entry.stable);
            while (!this.dependencies.tryExclusiveLock(lockAddress)) {
                this.epoch.refresh(threadIndex);
                Thread.yield();
            }
            try {
                if (TStoreBTreeCompactor.read(this.dependencies.addressOf(entry.stable)) == entry.logical) {
                    this.metrics.onVisitedIndexReachableRecord();
                    long entryLogical = entry.logical;
                    while (true) {
                        AddressPair status;
                        if ((status = this.log.readRecordForUpdate(entryLogical, this.slotAccessor, (record, oldLogical, newLogical, currentThreadIndex) -> {
                            TStoreBTreeCompactor.write(this.dependencies.addressOf(entry.stable), newLogical);
                            return newLogical;
                        })) != SlotAccessor.BTREE_RETRY_STATUS) {
                            break block7;
                        }
                        this.epoch.refresh(threadIndex);
                        Thread.yield();
                    }
                }
                this.metrics.onVisitedRecordIsNotIndexReachable();
            }
            finally {
                this.dependencies.releaseLock(lockAddress);
            }
        }
    }

    private void onCompactionQueued() {
        this.log.getMetrics().onCompactionQueued();
    }

    private void onCompactionStart() {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("starting with compaction on b+tree HybridLog with id=%s, segmentNo=%s", this.log.getId(), this.segmentNo);
        }
        this.log.getMetrics().onCompactionStart(this.createdAt);
    }

    private void onCompactionFinish(@Nullable Throwable ex) {
        this.deregister();
        this.log.getMetrics().onCompactionFinish(this.metrics, ex != null);
        if (ex != null) {
            this.logger.warning(this.toReadableStr(ex));
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine(this.metrics.readableMetrics());
            this.logger.fine(this.logIterator.readableMetrics());
            this.logger.fine("done with compaction on b+tree HybridLog with id=%s, segmentNo=%s", this.log.getId(), this.segmentNo);
        }
    }

    public HybridLog getHybridLog() {
        return this.log;
    }

    private String toReadableStr(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        String ln = System.lineSeparator();
        StringBuilder sb = new StringBuilder().append("Exception during compaction of b+tree HybridLog with id=").append(this.log.getId()).append(", segmentNo=").append(this.segmentNo).append(ln).append(throwable.getMessage()).append(ln);
        for (StackTraceElement e : throwable.getStackTrace()) {
            sb.append(e.toString()).append(ln);
        }
        return sb.toString();
    }

    private static long read(long address) {
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(address);
    }

    private static void write(long address, long value) {
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(address, value);
    }

    @Override
    protected void doTriggerSegmentsDeletion() {
        this.device.truncateAsync(this.segmentNo);
    }

    private static class HybridLogBTreeCompactorMetrics
    implements CompactorMetrics {
        long aliveRecordsCnt;
        long deadRecordsCnt;
        long compactionDurationNs = -1L;

        private HybridLogBTreeCompactorMetrics() {
        }

        void addCompactionDuration(long durationNanos) {
            this.compactionDurationNs += durationNanos;
        }

        void onVisitedIndexReachableRecord() {
            ++this.aliveRecordsCnt;
        }

        void onVisitedRecordIsNotIndexReachable() {
            ++this.deadRecordsCnt;
        }

        String readableMetrics() {
            String newLine = System.lineSeparator() + "\t";
            return System.lineSeparator() + "HybridLogBTreeCompactorMetrics:" + newLine + "recordsIteratedOver=" + this.getVisitedRecordsCnt() + newLine + "aliveRecords=" + this.aliveRecordsCnt + newLine + "deadRecords=" + this.deadRecordsCnt + newLine + "compactionTime=" + String.format("%.3f", (double)this.getCompactionTimeNs() / 1000000.0) + " millis.";
        }

        @Override
        public long getDummyRecordsCnt() {
            return 0L;
        }

        @Override
        public long getNonDummyRecordsCnt() {
            return 0L;
        }

        @Override
        public long getAliveRecordsCnt() {
            return this.aliveRecordsCnt;
        }

        @Override
        public long getDeadRecordsCnt() {
            return this.deadRecordsCnt;
        }

        @Override
        public long getVisitedRecordsCnt() {
            return this.aliveRecordsCnt + this.deadRecordsCnt;
        }

        @Override
        public long getVisitedRecordsSize() {
            return -1L;
        }

        @Override
        public long getCompactionTimeNs() {
            return this.compactionDurationNs;
        }

        @Override
        public long getIoTimeNanos() {
            return 0L;
        }

        @Override
        public long getDummyRecordsSize() {
            return 0L;
        }

        @Override
        public long getNonDummyRecordsSize() {
            return 0L;
        }

        @Override
        public long getAliveRecordsSize() {
            return 0L;
        }

        @Override
        public long getDeadRecordsSize() {
            return 0L;
        }
    }

    public static interface Dependencies {
        public long getLockAddress(long var1);

        public boolean tryExclusiveLock(long var1);

        public void releaseLock(long var1);

        public long addressOf(long var1);
    }

    final class SlotAccessor
    implements InMemorySlotAccessor<AddressPair, AddressPair> {
        static final AddressPair BTREE_RETRY_STATUS = new AddressPair(-1L, -1L);
        final AddressPair entry = new AddressPair();
        final int nodeSize;

        SlotAccessor(int nodeSize) {
            this.nodeSize = nodeSize;
        }

        @Override
        public AddressPair prepare(long slotLogicalAddress, MemoryAddressTranslator translator, int threadIndex) {
            this.entry.logical = slotLogicalAddress;
            this.entry.stable = TStoreBTreeCompactor.read(translator.asPhysicalAddress(slotLogicalAddress, threadIndex));
            return this.entry;
        }

        @Override
        public int size(AddressPair preparedSlot) {
            return this.nodeSize;
        }

        @Override
        public boolean isAlive(AddressPair preparedSlot) {
            long stable = preparedSlot.stable;
            return TStoreBTreeCompactor.read(TStoreBTreeCompactor.this.dependencies.addressOf(stable)) <= preparedSlot.logical;
        }

        @Override
        public AddressPair asEntry(AddressPair preparedSlot) {
            return preparedSlot;
        }

        @Override
        public boolean lock(AddressPair preparedSlot) {
            return true;
        }

        @Override
        public void unlock(AddressPair preparedSlot) {
        }

        @Override
        public AddressPair retryStatus() {
            return BTREE_RETRY_STATUS;
        }

        @Override
        public long retryRawStatus() {
            return -1L;
        }

        @Override
        public int headerSize() {
            return 0;
        }

        @Override
        public Data readValue(byte[] record) {
            return null;
        }

        @Override
        public int length(byte[] chunkPart) {
            return this.nodeSize;
        }
    }

    private static final class AddressPair {
        long logical;
        long stable;

        AddressPair() {
        }

        AddressPair(long stable, long logical) {
            this.stable = stable;
            this.logical = logical;
        }
    }
}

