/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import java.util.concurrent.atomic.AtomicInteger;

class WanElementCounter {
    private final AtomicInteger primaryElementCounter = new AtomicInteger();
    private final AtomicInteger backupElementCounter = new AtomicInteger();

    WanElementCounter() {
    }

    void incrementCounters(boolean backupEvent) {
        if (backupEvent) {
            this.backupElementCounter.incrementAndGet();
        } else {
            this.primaryElementCounter.incrementAndGet();
        }
    }

    void decrementPrimaryElementCounter(int delta) {
        this.primaryElementCounter.addAndGet(-delta);
    }

    void decrementBackupElementCounter(int delta) {
        this.backupElementCounter.addAndGet(-delta);
    }

    void decrementPrimaryElementCounter() {
        this.primaryElementCounter.decrementAndGet();
    }

    void decrementBackupElementCounter() {
        this.backupElementCounter.decrementAndGet();
    }

    void moveFromBackupToPrimaryCounter(int delta) {
        this.backupElementCounter.addAndGet(-delta);
        this.primaryElementCounter.addAndGet(delta);
    }

    void moveFromPrimaryToBackupCounter(int delta) {
        this.primaryElementCounter.addAndGet(-delta);
        this.backupElementCounter.addAndGet(delta);
    }

    int getPrimaryElementCount() {
        return this.primaryElementCounter.get();
    }

    int getBackupElementCount() {
        return this.backupElementCounter.get();
    }

    void setPrimaryElementCounter(int newValue) {
        this.primaryElementCounter.set(newValue);
    }

    void setBackupElementCounter(int newValue) {
        this.backupElementCounter.set(newValue);
    }

    public String toString() {
        return "WanElementCounter{primaryElementCounter=" + String.valueOf(this.primaryElementCounter) + ", backupElementCounter=" + String.valueOf(this.backupElementCounter) + "}";
    }
}

