/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.internal.util.StringUtil;

public class WanConfigurationContext {
    private final boolean snapshotEnabled;
    private final int batchSize;
    private final long batchMaxDelayMillis;
    private final long responseTimeoutMillis;
    private final WanAcknowledgeType acknowledgeType;
    private final boolean useEndpointPrivateAddress;
    private final String clusterName;
    private final int maxEndpoints;
    private final int discoveryPeriodSeconds;
    private final String endpoints;
    private final WanBatchPublisherConfig publisherConfig;
    private final int maxConcurrentInvocations;
    private final long idleMinParkNs;
    private final long idleMaxParkNs;

    WanConfigurationContext(WanBatchPublisherConfig publisherConfig) {
        this.publisherConfig = publisherConfig;
        this.snapshotEnabled = publisherConfig.isSnapshotEnabled();
        this.batchSize = publisherConfig.getBatchSize();
        this.batchMaxDelayMillis = publisherConfig.getBatchMaxDelayMillis();
        this.responseTimeoutMillis = publisherConfig.getResponseTimeoutMillis();
        this.acknowledgeType = publisherConfig.getAcknowledgeType();
        this.clusterName = publisherConfig.getClusterName();
        this.useEndpointPrivateAddress = publisherConfig.isUseEndpointPrivateAddress();
        this.discoveryPeriodSeconds = publisherConfig.getDiscoveryPeriodSeconds();
        this.endpoints = publisherConfig.getTargetEndpoints();
        this.maxEndpoints = StringUtil.isNullOrEmpty(publisherConfig.getTargetEndpoints()) ? publisherConfig.getMaxTargetEndpoints() : Integer.MAX_VALUE;
        this.maxConcurrentInvocations = publisherConfig.getMaxConcurrentInvocations();
        this.idleMinParkNs = publisherConfig.getIdleMinParkNs();
        this.idleMaxParkNs = publisherConfig.getIdleMaxParkNs();
    }

    public boolean isSnapshotEnabled() {
        return this.snapshotEnabled;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getBatchMaxDelayMillis() {
        return this.batchMaxDelayMillis;
    }

    public long getResponseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    public WanAcknowledgeType getAcknowledgeType() {
        return this.acknowledgeType;
    }

    public boolean isUseEndpointPrivateAddress() {
        return this.useEndpointPrivateAddress;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public int getMaxEndpoints() {
        return this.maxEndpoints;
    }

    public int getDiscoveryPeriodSeconds() {
        return this.discoveryPeriodSeconds;
    }

    public String getEndpoints() {
        return this.endpoints;
    }

    public WanBatchPublisherConfig getPublisherConfig() {
        return this.publisherConfig;
    }

    public int getMaxConcurrentInvocations() {
        return this.maxConcurrentInvocations;
    }

    public long getIdleMinParkNs() {
        return this.idleMinParkNs;
    }

    public long getIdleMaxParkNs() {
        return this.idleMaxParkNs;
    }
}

