/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.cache.impl.wan.WanEnterpriseCacheEvent;
import com.hazelcast.config.AbstractWanPublisherConfig;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanQueueFullBehavior;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.enterprise.wan.impl.DistributedObjectIdentifier;
import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.FinalizableEnterpriseWanEvent;
import com.hazelcast.enterprise.wan.impl.PartitionWanEventQueueMap;
import com.hazelcast.enterprise.wan.impl.WanEventMigrationContainer;
import com.hazelcast.enterprise.wan.impl.WanEventQueue;
import com.hazelcast.enterprise.wan.impl.operation.RemoveWanEventBackupsOperation;
import com.hazelcast.enterprise.wan.impl.operation.WanPutOperation;
import com.hazelcast.enterprise.wan.impl.replication.PollSynchronizerPublisherQueueContainer;
import com.hazelcast.enterprise.wan.impl.replication.WanConfigurationContext;
import com.hazelcast.enterprise.wan.impl.replication.WanElementCounter;
import com.hazelcast.enterprise.wan.impl.replication.WanPublisherSyncSupport;
import com.hazelcast.enterprise.wan.impl.replication.WanQueueMigrationSupport;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.monitor.LocalWanPublisherStats;
import com.hazelcast.internal.monitor.impl.LocalWanPublisherStatsImpl;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.wan.WanEnterpriseMapEvent;
import com.hazelcast.map.impl.wan.WanEnterpriseMapMerkleTreeNode;
import com.hazelcast.map.impl.wan.WanEnterpriseMapSyncEvent;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.wan.WanEvent;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.WanMigrationAwarePublisher;
import com.hazelcast.wan.WanPublisherState;
import com.hazelcast.wan.WanQueueFullException;
import com.hazelcast.wan.impl.InternalWanEvent;
import com.hazelcast.wan.impl.InternalWanPublisher;
import com.hazelcast.wan.impl.WanReplicationServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractWanPublisher
implements InternalWanPublisher,
WanMigrationAwarePublisher<WanEventMigrationContainer>,
HazelcastInstanceAware {
    private static final int QUEUE_LOGGER_PERIOD_MILLIS = (int)TimeUnit.MINUTES.toMillis(5L);
    protected final WanElementCounter wanCounter = new WanElementCounter();
    protected final AtomicInteger term = new AtomicInteger();
    protected volatile WanPublisherState state;
    protected volatile boolean running = true;
    protected volatile long lastQueueFullLogTimeMs;
    protected int queueCapacity;
    protected int queueLoggerTimePeriodMs = QUEUE_LOGGER_PERIOD_MILLIS;
    protected Node node;
    protected ILogger logger;
    protected String localClusterName;
    protected String wanPublisherId;
    protected String wanReplicationName;
    protected WanQueueFullBehavior queueFullBehavior;
    protected WanConfigurationContext configurationContext;
    protected PollSynchronizerPublisherQueueContainer eventQueueContainer;
    protected WanPublisherSyncSupport syncSupport;
    protected EnterpriseWanReplicationService wanService;
    private WanQueueMigrationSupport wanQueueMigrationSupport;
    private final LocalWanPublisherStatsImpl localWanPublisherStats = new LocalWanPublisherStatsImpl();

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.node = ((HazelcastInstanceImpl)hazelcastInstance).node;
    }

    @Override
    public void init(WanReplicationConfig wanReplicationConfig, AbstractWanPublisherConfig config) {
        WanBatchPublisherConfig publisherConfig = (WanBatchPublisherConfig)config;
        this.configurationContext = new WanConfigurationContext(publisherConfig);
        this.wanReplicationName = wanReplicationConfig.getName();
        this.wanPublisherId = WanReplicationServiceImpl.getWanPublisherId(publisherConfig);
        this.logger = this.node.getLogger(this.getClass());
        this.queueCapacity = publisherConfig.getQueueCapacity();
        this.localClusterName = this.node.getNodeEngine().getConfig().getClusterName();
        this.eventQueueContainer = new PollSynchronizerPublisherQueueContainer(this.node, this.configurationContext);
        this.queueFullBehavior = publisherConfig.getQueueFullBehavior();
        this.wanService = (EnterpriseWanReplicationService)this.node.getNodeEngine().getWanReplicationService();
        WanEventCounters mapCounters = this.wanService.getSentEventCounters(this.wanReplicationName, this.wanPublisherId, "hz:impl:mapService");
        WanEventCounters cacheCounters = this.wanService.getSentEventCounters(this.wanReplicationName, this.wanPublisherId, "hz:impl:cacheService");
        this.localWanPublisherStats.setSentMapEventCounter(Collections.unmodifiableMap(mapCounters.getEventCounterMap()));
        this.localWanPublisherStats.setSentCacheEventCounter(Collections.unmodifiableMap(cacheCounters.getEventCounterMap()));
        this.wanQueueMigrationSupport = new WanQueueMigrationSupport(this.eventQueueContainer, this.wanCounter);
        this.state = publisherConfig.getInitialPublisherState();
        this.syncSupport = this.createWanSyncSupport();
    }

    protected int getPartitionId(Object key) {
        return this.node.getNodeEngine().getPartitionService().getPartitionId(key);
    }

    @Override
    public void publishReplicationEvent(WanEvent eventObject) {
        this.publishReplicationEventInternal((InternalWanEvent)eventObject, false, false);
    }

    @Override
    public void publishRepublishedReplicationEvent(WanEvent eventObject) {
        this.publishReplicationEventInternal((InternalWanEvent)eventObject, false, true);
    }

    @Override
    public void publishReplicationEventBackup(WanEvent eventObject) {
        this.publishReplicationEventInternal((InternalWanEvent)eventObject, true, false);
    }

    @Override
    public void publishRepublishedReplicationEventBackup(WanEvent eventObject) {
        this.publishReplicationEventInternal((InternalWanEvent)eventObject, true, true);
    }

    private void publishReplicationEventInternal(InternalWanEvent eventObject, boolean backupEvent, boolean republished) {
        if (!this.state.isEnqueueNewEvents()) {
            return;
        }
        if (this.isEventDroppingNeeded(backupEvent)) {
            if (!backupEvent) {
                this.wanService.getSentEventCounters(this.wanReplicationName, this.wanPublisherId, eventObject.getServiceName()).incrementDropped(eventObject.getObjectName());
            }
            return;
        }
        if (republished && eventObject.getClusterNames().contains(this.configurationContext.getClusterName())) {
            return;
        }
        eventObject.getClusterNames().add(this.localClusterName);
        boolean eventPublished = this.publishEventInternal(eventObject);
        if (eventPublished) {
            this.wanCounter.incrementCounters(backupEvent);
        }
    }

    private boolean publishEventInternal(InternalWanEvent eventObject) {
        FinalizableEnterpriseWanEvent finalizableEnterpriseWanEvent;
        assert (!(eventObject instanceof WanEnterpriseMapMerkleTreeNode)) : "Merkle tree sync objects should not be published";
        assert (!(eventObject instanceof WanEnterpriseMapSyncEvent)) : "Sync objects should not be published";
        if (eventObject instanceof FinalizableEnterpriseWanEvent) {
            FinalizableEnterpriseWanEvent finalizableEnterpriseWanEvent2 = (FinalizableEnterpriseWanEvent)eventObject;
            finalizableEnterpriseWanEvent = finalizableEnterpriseWanEvent2;
        } else {
            finalizableEnterpriseWanEvent = new FinalizableEnterpriseWanEvent(eventObject);
        }
        FinalizableEnterpriseWanEvent wrappedEvent = finalizableEnterpriseWanEvent;
        InternalWanEvent unwrappedEvent = wrappedEvent.getEvent();
        if (unwrappedEvent instanceof WanEnterpriseMapEvent) {
            WanEnterpriseMapEvent wanEnterpriseMapEvent = (WanEnterpriseMapEvent)unwrappedEvent;
            String mapName = wanEnterpriseMapEvent.getMapName();
            int partitionId = this.getPartitionId(unwrappedEvent.getKey());
            return this.eventQueueContainer.publishMapWanEvent(mapName, partitionId, wrappedEvent);
        }
        if (unwrappedEvent instanceof WanEnterpriseCacheEvent) {
            WanEnterpriseCacheEvent wanEnterpriseCacheEvent = (WanEnterpriseCacheEvent)unwrappedEvent;
            String cacheName = wanEnterpriseCacheEvent.getNameWithPrefix();
            int partitionId = this.getPartitionId(unwrappedEvent.getKey());
            return this.eventQueueContainer.publishCacheWanEvent(cacheName, partitionId, wrappedEvent);
        }
        this.logger.warning("Unexpected replication event object type: " + eventObject.getClass().getName());
        return false;
    }

    void incrementEventCount(InternalWanEvent event) {
        String serviceName = event.getServiceName();
        WanEventCounters counters = this.wanService.getSentEventCounters(this.wanReplicationName, this.wanPublisherId, serviceName);
        event.incrementEventCount(counters);
    }

    private boolean isEventDroppingNeeded(boolean isBackup) {
        if (isBackup) {
            return this.wanCounter.getBackupElementCount() >= this.queueCapacity;
        }
        if (this.wanCounter.getPrimaryElementCount() >= this.queueCapacity && this.queueFullBehavior != WanQueueFullBehavior.THROW_EXCEPTION) {
            long curTime = System.currentTimeMillis();
            if (curTime > this.lastQueueFullLogTimeMs + (long)this.queueLoggerTimePeriodMs) {
                this.lastQueueFullLogTimeMs = curTime;
                this.logger.severe("Wan replication event queue is full. Dropping events. Queue size : " + this.wanCounter.getPrimaryElementCount());
            } else {
                this.logger.finest("Wan replication event queue is full. An event will be dropped.");
            }
            return true;
        }
        return false;
    }

    protected void finalizeWanEventReplication(Collection<InternalWanEvent> ... eventCollections) {
        Map<Integer, Map<DistributedObjectIdentifier, Integer>> eventCounts = this.updateStatsAndCountEvents(eventCollections);
        if (eventCounts.isEmpty()) {
            return;
        }
        for (Collection<InternalWanEvent> entryCollection : eventCollections) {
            for (InternalWanEvent event : entryCollection) {
                if (!(event instanceof FinalizableEnterpriseWanEvent)) continue;
                FinalizableEnterpriseWanEvent finalizableEnterpriseWanEvent = (FinalizableEnterpriseWanEvent)event;
                finalizableEnterpriseWanEvent.doFinalize();
            }
        }
        List<InternalCompletableFuture> futures = this.invokeBackupRemovalOperations(eventCounts);
        try {
            for (InternalCompletableFuture future : futures) {
                future.get();
            }
        }
        catch (Exception ex) {
            this.logger.warning("Exception occurred while removing wan backups", ex);
        }
    }

    private List<InternalCompletableFuture> invokeBackupRemovalOperations(Map<Integer, Map<DistributedObjectIdentifier, Integer>> eventCounts) {
        ArrayList<InternalCompletableFuture> futures = new ArrayList<InternalCompletableFuture>(eventCounts.size());
        for (Map.Entry<Integer, Map<DistributedObjectIdentifier, Integer>> partitionEntry : eventCounts.entrySet()) {
            Integer partitionId = partitionEntry.getKey();
            Map<DistributedObjectIdentifier, Integer> partitionEventCounts = partitionEntry.getValue();
            int backupCount = 0;
            for (DistributedObjectIdentifier id : partitionEventCounts.keySet()) {
                backupCount = Math.max(backupCount, id.getTotalBackupCount());
            }
            int maxAllowedBackupCount = this.node.getPartitionService().getMaxAllowedBackupCount();
            for (int i = 0; i < backupCount && i < maxAllowedBackupCount; ++i) {
                RemoveWanEventBackupsOperation op = new RemoveWanEventBackupsOperation(this.wanReplicationName, this.wanPublisherId, partitionEventCounts);
                InvocationFuture future = this.node.getNodeEngine().getOperationService().createInvocationBuilder("hz:core:wanReplicationService", (Operation)op, partitionId).setResultDeserialized(false).setReplicaIndex(i + 1).invoke();
                futures.add(future);
            }
        }
        return futures;
    }

    private Map<Integer, Map<DistributedObjectIdentifier, Integer>> updateStatsAndCountEvents(Collection<InternalWanEvent> ... eventCollections) {
        HashMap<Integer, Map<DistributedObjectIdentifier, Integer>> eventCounts = new HashMap<Integer, Map<DistributedObjectIdentifier, Integer>>();
        for (Collection<InternalWanEvent> eventsCollection : eventCollections) {
            for (InternalWanEvent event : eventsCollection) {
                Integer eventCount;
                DistributedObjectIdentifier id;
                Map partitionEventCounts;
                if (event instanceof WanEnterpriseMapSyncEvent || event instanceof WanEnterpriseMapMerkleTreeNode) {
                    this.syncSupport.removeReplicationEvent((WanEnterpriseMapEvent)event);
                    continue;
                }
                this.updateStats(event);
                int partitionId = this.getPartitionId(event.getKey());
                if (!eventCounts.containsKey(partitionId)) {
                    eventCounts.put(partitionId, new HashMap());
                }
                partitionEventCounts.put(id, (eventCount = (Integer)(partitionEventCounts = (Map)eventCounts.get(partitionId)).get(id = this.getDistributedObjectIdentifier(event))) != null ? eventCount + 1 : 1);
            }
        }
        return eventCounts;
    }

    private DistributedObjectIdentifier getDistributedObjectIdentifier(InternalWanEvent eventObject) {
        DistributedObjectIdentifier id = null;
        if (eventObject instanceof FinalizableEnterpriseWanEvent) {
            FinalizableEnterpriseWanEvent finalizableEnterpriseWanEvent = (FinalizableEnterpriseWanEvent)eventObject;
            eventObject = finalizableEnterpriseWanEvent.getEvent();
        }
        if (eventObject instanceof WanEnterpriseMapEvent) {
            WanEnterpriseMapEvent mapEvent = (WanEnterpriseMapEvent)eventObject;
            id = new DistributedObjectIdentifier("hz:impl:mapService", mapEvent.getMapName(), mapEvent.getBackupCount());
        } else if (eventObject instanceof WanEnterpriseCacheEvent) {
            WanEnterpriseCacheEvent cacheEvent = (WanEnterpriseCacheEvent)eventObject;
            id = new DistributedObjectIdentifier("hz:impl:cacheService", cacheEvent.getNameWithPrefix(), cacheEvent.getBackupCount());
        } else {
            this.logger.warning("Unexpected replication event object type: " + eventObject.getClass().getName());
        }
        return id;
    }

    private void updateStats(InternalWanEvent event) {
        long latency = Clock.currentTimeMillis() - event.getCreationTime();
        this.localWanPublisherStats.incrementPublishedEventCount(latency < 0L ? 0L : latency);
    }

    @Override
    public final void shutdown() {
        this.running = false;
        this.syncSupport.shutdown();
        this.afterShutdown();
    }

    protected void afterShutdown() {
    }

    @Override
    public void pause() {
        this.state = WanPublisherState.PAUSED;
        this.logger.info("Paused WAN replication " + this.wanReplicationName + ", publisherId: " + this.wanPublisherId);
    }

    @Override
    public void stop() {
        this.state = WanPublisherState.STOPPED;
        this.logger.info("Stopped WAN replication " + this.wanReplicationName + ", publisherId: " + this.wanPublisherId);
    }

    @Override
    public void resume() {
        this.state = WanPublisherState.REPLICATING;
        this.logger.info("Resumed WAN replication " + this.wanReplicationName + ", publisherId: " + this.wanPublisherId);
    }

    @Override
    public LocalWanPublisherStats getStats() {
        this.localWanPublisherStats.setState(this.state);
        this.localWanPublisherStats.setConnected(this.isConnected());
        this.localWanPublisherStats.setOutboundQueueSize(this.wanCounter.getPrimaryElementCount());
        this.localWanPublisherStats.setLastConsistencyCheckResults(this.syncSupport.getLastConsistencyCheckResults());
        this.localWanPublisherStats.setLastSyncStats(this.syncSupport.getLastSyncStats());
        return this.localWanPublisherStats;
    }

    public abstract boolean isConnected();

    @Override
    public void doPrepublicationChecks() {
        if (this.isThrowExceptionBehavior(this.queueFullBehavior) && this.wanCounter.getPrimaryElementCount() >= this.queueCapacity) {
            throw new WanQueueFullException(String.format("WAN replication for WAN publisher %s is full. Queue capacity is %d", this.wanPublisherId, this.queueCapacity));
        }
    }

    public void republishReplicationEvent(InternalWanEvent wanEvent) {
        WanPutOperation wanPutOperation = new WanPutOperation(this.wanReplicationName, this.wanPublisherId, wanEvent, wanEvent.getBackupCount());
        this.invokeOnPartition(wanEvent.getServiceName(), wanEvent.getKey(), wanPutOperation);
    }

    private void invokeOnPartition(String serviceName, Data key, Operation operation) {
        try {
            int partitionId = this.node.getNodeEngine().getPartitionService().getPartitionId(key);
            this.node.getNodeEngine().getOperationService().invokeOnPartition(serviceName, operation, partitionId).get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private boolean isThrowExceptionBehavior(WanQueueFullBehavior queueFullBehavior) {
        return WanQueueFullBehavior.THROW_EXCEPTION == queueFullBehavior || WanQueueFullBehavior.THROW_EXCEPTION_ONLY_IF_REPLICATION_ACTIVE == queueFullBehavior && this.state.isReplicateEnqueuedEvents();
    }

    @Override
    public void destroyMapData(String mapName) {
        this.syncSupport.destroyMapData(mapName);
    }

    @Override
    public int removeWanEvents() {
        boolean isReplicating = this.state.isReplicateEnqueuedEvents();
        if (isReplicating) {
            this.pause();
        }
        int drained = this.clearQueuesInternal();
        this.term.incrementAndGet();
        if (isReplicating) {
            this.resume();
        }
        return drained;
    }

    private void decrementCounter(int delta, boolean isPrimary) {
        if (isPrimary) {
            this.wanCounter.decrementPrimaryElementCounter(delta);
        } else {
            this.wanCounter.decrementBackupElementCounter(delta);
        }
    }

    private int clearQueuesInternal() {
        int totalDrained = 0;
        Map<Integer, Integer> drainedPerPartition = this.eventQueueContainer.drainQueues();
        for (Map.Entry<Integer, Integer> entry : drainedPerPartition.entrySet()) {
            Integer partitionId = entry.getKey();
            int drainedElements = entry.getValue();
            totalDrained += drainedElements;
            InternalPartition partition = this.node.getPartitionService().getPartition(partitionId);
            this.decrementCounter(drainedElements, partition.isLocal());
        }
        this.logger.info("Cleared " + totalDrained + " elements from the WAN queues. Current element counts: primary=" + this.wanCounter.getPrimaryElementCount() + " backup=" + this.wanCounter.getBackupElementCount());
        return totalDrained;
    }

    @Override
    public void onMigrationStart(PartitionMigrationEvent event) {
        this.wanQueueMigrationSupport.onMigrationStart(event);
    }

    @Override
    public void onMigrationCommit(PartitionMigrationEvent event) {
        this.wanQueueMigrationSupport.onMigrationCommit(event);
    }

    @Override
    public void onMigrationRollback(PartitionMigrationEvent event) {
        this.wanQueueMigrationSupport.onMigrationRollback(event);
    }

    @Override
    public void reset() {
        this.eventQueueContainer.clear();
        this.wanCounter.setPrimaryElementCounter(0);
        this.wanCounter.setBackupElementCounter(0);
    }

    public int getCurrentElementCount() {
        return this.wanCounter.getPrimaryElementCount();
    }

    public int getCurrentBackupElementCount() {
        return this.wanCounter.getBackupElementCount();
    }

    @Override
    public void collectAllServiceNamespaces(PartitionReplicationEvent event, Set<ServiceNamespace> namespaces) {
        this.eventQueueContainer.collectAllServiceNamespaces(event, namespaces);
    }

    @Override
    public int removeWanEvents(int partitionId, String serviceName, String objectName, int count) {
        boolean isMapService = "hz:impl:mapService".equals(serviceName);
        if (!isMapService && !"hz:impl:cacheService".equals(serviceName)) {
            String msg = "Unexpected replication event service name: " + serviceName;
            assert (false) : msg;
            this.logger.warning(msg);
            return 0;
        }
        int removed = 0;
        for (int i = 0; i < count; ++i) {
            InternalWanEvent event;
            InternalWanEvent internalWanEvent = event = isMapService ? this.eventQueueContainer.pollMapWanEvent(objectName, partitionId) : this.eventQueueContainer.pollCacheWanEvent(objectName, partitionId);
            if (event == null) break;
            this.wanCounter.decrementBackupElementCounter();
            ++removed;
        }
        return removed;
    }

    @Override
    public WanEventMigrationContainer prepareEventContainerReplicationData(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        return this.eventQueueContainer.prepareEventContainerReplicationData(event, namespaces);
    }

    @Override
    public void processEventContainerReplicationData(int partitionId, WanEventMigrationContainer eventContainer) {
        boolean isPrimaryReplica = this.node.getNodeEngine().getPartitionService().getPartition(partitionId).isLocal();
        PartitionWanEventQueueMap mapQueues = eventContainer.getMapQueues();
        PartitionWanEventQueueMap cacheQueues = eventContainer.getCacheQueues();
        int removedMapEvents = MapUtil.isNullOrEmpty(mapQueues) ? 0 : this.removeWanEvents(partitionId, "hz:impl:mapService");
        int removedCacheEvents = MapUtil.isNullOrEmpty(cacheQueues) ? 0 : this.removeWanEvents(partitionId, "hz:impl:cacheService");
        this.decrementCounter(removedMapEvents + removedCacheEvents, isPrimaryReplica);
        this.publishEvents(partitionId, mapQueues);
        this.publishEvents(partitionId, cacheQueues);
    }

    private int removeWanEvents(int partitionId, String serviceName) {
        int size = 0;
        switch (serviceName) {
            case "hz:impl:mapService": {
                size += this.eventQueueContainer.drainMapQueuesMatchingPredicate(partitionId, q -> true);
                break;
            }
            case "hz:impl:cacheService": {
                size += this.eventQueueContainer.drainCacheQueuesMatchingPredicate(partitionId, q -> true);
                break;
            }
            default: {
                String msg = "Unexpected replication event service name: " + serviceName;
                assert (false) : msg;
                this.logger.warning(msg);
            }
        }
        return size;
    }

    private void publishEvents(int partitionId, PartitionWanEventQueueMap queues) {
        if (queues != null) {
            for (WanEventQueue queue : queues.values()) {
                this.publishReplicationEventQueue(partitionId, queue);
            }
        }
    }

    private void publishReplicationEventQueue(int partitionId, WanEventQueue eventQueue) {
        InternalWanEvent event = (InternalWanEvent)eventQueue.poll();
        while (event != null) {
            boolean isPrimaryReplica = this.node.getNodeEngine().getPartitionService().getPartition(partitionId).isLocal();
            if (isPrimaryReplica) {
                this.publishReplicationEvent((WanEvent)event);
            } else {
                this.publishReplicationEventBackup((WanEvent)event);
            }
            event = (InternalWanEvent)eventQueue.poll();
        }
    }

    protected abstract WanPublisherSyncSupport createWanSyncSupport();

    public WanConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public PollSynchronizerPublisherQueueContainer getEventQueueContainer() {
        return this.eventQueueContainer;
    }

    public WanPublisherSyncSupport getSyncSupport() {
        return this.syncSupport;
    }
}

