/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.operation;

import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.internal.cluster.impl.operations.WanOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.version.Version;
import java.io.IOException;

public class WanEventContainerOperation
extends Operation
implements WanOperation,
IdentifiedDataSerializable,
AllowedDuringPassiveState {
    private IdentifiedDataSerializable event;
    private WanAcknowledgeType acknowledgeType;
    private final transient Version wanProtocolVersion;

    public WanEventContainerOperation() {
        this.wanProtocolVersion = Version.UNKNOWN;
    }

    public WanEventContainerOperation(IdentifiedDataSerializable event, WanAcknowledgeType acknowledgeType, Version wanProtocolVersion) {
        this.event = event;
        this.acknowledgeType = acknowledgeType;
        this.wanProtocolVersion = wanProtocolVersion;
    }

    private void setWanProtocolVersion(ObjectDataOutput output) {
        output.setWanProtocolVersion(this.wanProtocolVersion);
    }

    @Override
    public void run() throws Exception {
        EnterpriseWanReplicationService wanRepService = (EnterpriseWanReplicationService)this.getNodeEngine().getWanReplicationService();
        wanRepService.handleEvent(this.event, this);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 12;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.setWanProtocolVersion(out);
        out.writeObject(this.event);
        out.writeInt(this.acknowledgeType.getId());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.event = (IdentifiedDataSerializable)in.readObject();
        this.acknowledgeType = WanAcknowledgeType.getById(in.readInt());
    }

    public WanAcknowledgeType getAcknowledgeType() {
        return this.acknowledgeType;
    }
}

