/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.operation;

import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.internal.dynamicconfig.ConfigurationService;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class PostJoinWanOperation
extends Operation
implements IdentifiedDataSerializable {
    private Collection<WanReplicationConfig> wanReplicationConfigs = new ArrayList<WanReplicationConfig>();

    public PostJoinWanOperation() {
    }

    public PostJoinWanOperation(Collection<WanReplicationConfig> wanReplicationConfigs) {
        this.wanReplicationConfigs = wanReplicationConfigs;
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 11;
    }

    @Override
    public void run() throws Exception {
        EnterpriseWanReplicationService service = (EnterpriseWanReplicationService)this.getService();
        for (WanReplicationConfig wanReplicationConfig : this.wanReplicationConfigs) {
            boolean configIsChanged = service.appendWanReplicationConfig(wanReplicationConfig);
            if (!configIsChanged) continue;
            ConfigurationService configurationService = (ConfigurationService)this.getNodeEngine().getService("hz:configurationService");
            configurationService.persist(wanReplicationConfig);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        SerializationUtil.writeCollection(this.wanReplicationConfigs, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            WanReplicationConfig wanReplicationConfig = (WanReplicationConfig)in.readObject();
            this.wanReplicationConfigs.add(wanReplicationConfig);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:core:wanReplicationService";
    }
}

