/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.enterprise.wan.impl.BatchWanEventRunnable;
import com.hazelcast.enterprise.wan.impl.WanAcknowledger;
import com.hazelcast.enterprise.wan.impl.WanEventRunnable;
import com.hazelcast.enterprise.wan.impl.operation.WanEventContainerOperation;
import com.hazelcast.enterprise.wan.impl.replication.WanEventBatch;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.services.WanSupportingService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.operationservice.LiveOperations;
import com.hazelcast.spi.impl.operationservice.LiveOperationsTracker;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

class WanEventProcessor
implements LiveOperationsTracker {
    private final ILogger logger;
    private final Node node;
    private final Set<Operation> liveOperations = ConcurrentHashMap.newKeySet();
    private final WanAcknowledger acknowledger;

    WanEventProcessor(Node node, WanAcknowledger acknowledger) {
        this.logger = node.getLogger(WanEventProcessor.class.getName());
        this.node = node;
        this.acknowledger = acknowledger;
    }

    public void handleRepEvent(WanEventBatch replicationEvent, WanEventContainerOperation op) {
        BatchWanEventRunnable processingRunnable = new BatchWanEventRunnable(replicationEvent, op, this.node.getNodeEngine(), this.liveOperations, this.logger, this.acknowledger, this.getExecutor());
        this.executeAndNotify(processingRunnable, op);
    }

    public void handleRepEvent(InternalWanEvent event, WanEventContainerOperation op) {
        WanEventRunnable processingRunnable = new WanEventRunnable(event, op, this.node.getNodeEngine(), this.liveOperations, this.logger, this.acknowledger);
        this.executeAndNotify(processingRunnable, op);
    }

    public void handleEvent(InternalWanEvent event, WanAcknowledgeType acknowledgeType) {
        String serviceName = event.getServiceName();
        WanSupportingService service = (WanSupportingService)this.node.getNodeEngine().getService(serviceName);
        service.onReplicationEvent(event, acknowledgeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndNotify(Runnable wanProcessingRunnable, WanEventContainerOperation op) {
        try {
            this.liveOperations.add(op);
            this.getExecutor().execute(wanProcessingRunnable);
        }
        catch (RejectedExecutionException ree) {
            this.logger.warning("Can not handle incoming wan replication event.", ree);
            try {
                op.sendResponse(false);
            }
            finally {
                this.liveOperations.remove(op);
            }
        }
    }

    private Executor getExecutor() {
        return this.node.getNodeEngine().getExecutionService().getExecutor("hz:wan:consumer");
    }

    @Override
    public void populate(LiveOperations liveOperations) {
        for (Operation op : this.liveOperations) {
            liveOperations.add(op.getCallerAddress(), op.getCallId());
        }
    }
}

