/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.dataconnection.impl;

import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.dataconnection.DataConnectionBase;
import com.hazelcast.dataconnection.DataConnectionResource;
import com.hazelcast.dataconnection.impl.ConnectionDelegate;
import com.hazelcast.dataconnection.impl.DatabaseDialect;
import com.hazelcast.dataconnection.impl.ResourceReader;
import com.hazelcast.dataconnection.impl.jdbcproperties.DriverManagerTranslator;
import com.hazelcast.dataconnection.impl.jdbcproperties.HikariTranslator;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.shaded.com.zaxxer.hikari.HikariConfig;
import com.hazelcast.shaded.com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class JdbcDataConnection
extends DataConnectionBase {
    public static final String OBJECT_TYPE_TABLE = "Table";
    private static final List<String> H2_SYSTEM_SCHEMA_LIST = List.of("INFORMATION_SCHEMA");
    private static final List<String> MYSQL_SYSTEM_CATALOG_LIST = List.of("SYS");
    private static final List<String> MSSQL_SYSTEM_SCHEMA_LIST = List.of("sys", "INFORMATION_SCHEMA");
    private static final List<String> MSSQL_SYSTEM_TABLE_LIST = List.of("MSreplication_options", "spt_fallback_db", "spt_fallback_dev", "spt_fallback_usg", "spt_monitor", "spt_values");
    private static final AtomicInteger DATA_SOURCE_COUNTER = new AtomicInteger();
    private volatile ConcurrentMemoizingSupplier<HikariDataSource> pooledDataSourceSup;
    private volatile Supplier<Connection> singleUseConnectionSup;

    public JdbcDataConnection(DataConnectionConfig config) {
        super(config);
        if (config.isShared()) {
            this.pooledDataSourceSup = new ConcurrentMemoizingSupplier<HikariDataSource>(this::createHikariDataSource);
        } else {
            this.singleUseConnectionSup = this.createSingleConnectionSup();
        }
    }

    protected HikariDataSource createHikariDataSource() {
        try {
            this.validate(this.getConfig());
            Properties properties = this.getConfig().getProperties();
            HikariTranslator translator = new HikariTranslator(DATA_SOURCE_COUNTER, this.getName());
            Properties translatedProperties = translator.translate(properties);
            HikariConfig dataSourceConfig = new HikariConfig(translatedProperties);
            return new HikariDataSource(dataSourceConfig);
        }
        catch (Exception e) {
            throw new HazelcastException("Could not create pool for data connection '" + this.getName() + "'", e);
        }
    }

    private Supplier<Connection> createSingleConnectionSup() {
        this.validate(this.getConfig());
        Properties properties = this.getConfig().getProperties();
        Properties translatedProperties = DriverManagerTranslator.translate(properties);
        return () -> {
            try {
                String jdbcUrl = properties.getProperty("jdbcUrl");
                return DriverManager.getConnection(jdbcUrl, translatedProperties);
            }
            catch (SQLException e) {
                throw new HazelcastException("Could not create a new connection: " + String.valueOf(e), e);
            }
        };
    }

    private void validate(DataConnectionConfig config) {
        Properties properties = config.getProperties();
        if (properties.get("jdbcUrl") == null) {
            throw new HazelcastException("jdbcUrl property is not defined for data connection '" + this.getName() + "'");
        }
    }

    @Override
    @Nonnull
    public Collection<String> resourceTypes() {
        return Collections.singleton(OBJECT_TYPE_TABLE);
    }

    @Nonnull
    public List<DataConnectionResource> listResources() {
        List<DataConnectionResource> list;
        block14: {
            Connection connection = this.getConnection();
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ResourceReader reader = new ResourceReader();
                switch (DatabaseDialect.resolveDialect(databaseMetaData)) {
                    case H2: {
                        reader.withCatalog(connection.getCatalog()).exclude((catalog, schema, table) -> H2_SYSTEM_SCHEMA_LIST.contains(schema));
                        break;
                    }
                    case POSTGRESQL: {
                        reader.withCatalog(connection.getCatalog());
                        break;
                    }
                    case MYSQL: {
                        reader.exclude((catalog, schema, table) -> catalog != null && MYSQL_SYSTEM_CATALOG_LIST.contains(catalog.toUpperCase(Locale.ROOT)));
                        break;
                    }
                    case MICROSOFT_SQL_SERVER: {
                        reader.withCatalog(connection.getCatalog()).exclude((catalog, schema, table) -> MSSQL_SYSTEM_SCHEMA_LIST.contains(schema) || MSSQL_SYSTEM_TABLE_LIST.contains(table));
                        break;
                    }
                }
                list = reader.listResources(connection);
                if (connection == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new HazelcastException("Could not read resources for DataConnection " + this.getName(), exception);
                }
            }
            connection.close();
        }
        return list;
    }

    private Connection pooledConnection() {
        this.retain();
        try {
            return new ConnectionDelegate(this.pooledDataSourceSup.get().getConnection()){

                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    catch (Exception e) {
                        throw new HazelcastException("Could not close connection", e);
                    }
                    finally {
                        JdbcDataConnection.this.release();
                    }
                }
            };
        }
        catch (SQLException e) {
            throw new HazelcastException("Could not get Connection from pool", e);
        }
    }

    private Connection singleUseConnection() {
        return this.singleUseConnectionSup.get();
    }

    public Connection getConnection() {
        return this.getConfig().isShared() ? this.pooledConnection() : this.singleUseConnection();
    }

    @Override
    public void destroy() {
        ConcurrentMemoizingSupplier<HikariDataSource> localPooledDataSourceSup = this.pooledDataSourceSup;
        if (localPooledDataSourceSup != null) {
            HikariDataSource dataSource = localPooledDataSourceSup.remembered();
            this.pooledDataSourceSup = null;
            if (dataSource != null) {
                try {
                    dataSource.close();
                }
                catch (Exception e) {
                    throw new HazelcastException("Could not close connection pool", e);
                }
            }
        }
        this.singleUseConnectionSup = null;
    }

    HikariDataSource pooledDataSource() {
        return this.pooledDataSourceSup.get();
    }
}

