/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.log;

import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.log.LogEntry;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.Collection;

public class SnapshotChunk
extends LogEntry {
    private int chunkNumber;
    private int chunkCount;
    private long groupMembersLogIndex;
    private Collection<RaftEndpoint> groupMembers;

    public int chunkCount() {
        return this.chunkCount;
    }

    public int chunkNumber() {
        return this.chunkNumber;
    }

    public boolean isFirstChunk() {
        return this.chunkNumber() == 0;
    }

    public Collection<RaftEndpoint> groupMembers() {
        return this.groupMembers;
    }

    public long groupMembersLogIndex() {
        return this.groupMembersLogIndex;
    }

    public SnapshotChunk setGroupMembers(Collection<RaftEndpoint> groupMembers) {
        this.groupMembers = groupMembers;
        return this;
    }

    public SnapshotChunk setGroupMembersLogIndex(long groupMembersLogIndex) {
        this.groupMembersLogIndex = groupMembersLogIndex;
        return this;
    }

    public SnapshotChunk setChunkNumber(int chunkNumber) {
        assert (chunkNumber >= 0 && chunkNumber < this.chunkCount) : "not expected chunkNumber=" + chunkNumber + "(0-based), chunkCount=" + this.chunkCount;
        this.chunkNumber = chunkNumber;
        return this;
    }

    public SnapshotChunk setChunkCount(int chunkCount) {
        this.chunkCount = chunkCount;
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.chunkNumber);
        out.writeInt(this.chunkCount);
        out.writeLong(this.groupMembersLogIndex);
        SerializationUtil.writeCollection(this.groupMembers, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.chunkNumber = in.readInt();
        this.chunkCount = in.readInt();
        this.groupMembersLogIndex = in.readLong();
        this.groupMembers = SerializationUtil.readCollection(in);
    }

    @Override
    public int getClassId() {
        return 14;
    }

    @Override
    public String toString() {
        return "SnapshotChunk{term=" + this.term() + ", snapshotIndex=" + this.index() + ", operation=" + (this.operation() == null ? "null" : "not null") + ", chunkNumber=" + this.chunkNumber + "(0-based), chunkCount=" + this.chunkCount + ", groupMembersLogIndex=" + this.groupMembersLogIndex + ", groupMembers=" + String.valueOf(this.groupMembers) + "}";
    }
}

