/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.dto;

import com.hazelcast.cp.internal.raft.impl.RaftDataSerializerHook;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class TriggerLeaderElection
implements IdentifiedDataSerializable {
    private RaftEndpoint leader;
    private int term;
    private int lastLogTerm;
    private long lastLogIndex;

    public TriggerLeaderElection() {
    }

    public TriggerLeaderElection(RaftEndpoint leader, int term, int lastLogTerm, long lastLogIndex) {
        this.leader = leader;
        this.term = term;
        this.lastLogTerm = lastLogTerm;
        this.lastLogIndex = lastLogIndex;
    }

    public RaftEndpoint leader() {
        return this.leader;
    }

    public int term() {
        return this.term;
    }

    public int lastLogTerm() {
        return this.lastLogTerm;
    }

    public long lastLogIndex() {
        return this.lastLogIndex;
    }

    @Override
    public int getFactoryId() {
        return RaftDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 13;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.leader);
        out.writeInt(this.term);
        out.writeInt(this.lastLogTerm);
        out.writeLong(this.lastLogIndex);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.leader = (RaftEndpoint)in.readObject();
        this.term = in.readInt();
        this.lastLogTerm = in.readInt();
        this.lastLogIndex = in.readLong();
    }

    public String toString() {
        return "TriggerLeaderElection{leader=" + String.valueOf(this.leader) + ", term=" + this.term + ", lastLogTerm=" + this.lastLogTerm + ", lastLogIndex=" + this.lastLogIndex + "}";
    }
}

