/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.dto;

import com.hazelcast.cp.internal.raft.impl.RaftDataSerializerConstants;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotChunk;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class InstallSnapshotRequest
implements IdentifiedDataSerializable {
    private RaftEndpoint leader;
    private int term;
    private SnapshotChunk snapshotChunk;
    private long queryRound;
    private long flowControlSequenceNumber;

    public InstallSnapshotRequest() {
    }

    public InstallSnapshotRequest(RaftEndpoint leader, int term, SnapshotChunk snapshotChunk, long queryRound, long flowControlSequenceNumber) {
        this.leader = leader;
        this.term = term;
        this.snapshotChunk = snapshotChunk;
        this.queryRound = queryRound;
        this.flowControlSequenceNumber = flowControlSequenceNumber;
    }

    public RaftEndpoint leader() {
        return this.leader;
    }

    public int term() {
        return this.term;
    }

    public SnapshotChunk snapshotChunk() {
        return this.snapshotChunk;
    }

    public long queryRound() {
        return this.queryRound;
    }

    public long flowControlSequenceNumber() {
        return this.flowControlSequenceNumber;
    }

    @Override
    public int getFactoryId() {
        return RaftDataSerializerConstants.F_ID;
    }

    @Override
    public int getClassId() {
        return 19;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.leader);
        out.writeInt(this.term);
        out.writeLong(this.queryRound);
        out.writeLong(this.flowControlSequenceNumber);
        out.writeObject(this.snapshotChunk);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.leader = (RaftEndpoint)in.readObject();
        this.term = in.readInt();
        this.queryRound = in.readLong();
        this.flowControlSequenceNumber = in.readLong();
        this.snapshotChunk = (SnapshotChunk)in.readObject();
    }

    public String toString() {
        return "InstallSnapshotRequest{leader=" + String.valueOf(this.leader) + ", term=" + this.term + ", snapshotChunk=" + String.valueOf(this.snapshotChunk) + ", queryRound=" + this.queryRound + ", flowControlSequenceNumber=" + this.flowControlSequenceNumber + "}";
    }
}

