/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.persistence;

import com.hazelcast.cp.internal.datastructures.snapshot.ChunkUtil;
import com.hazelcast.cp.internal.persistence.OnDiskRaftStateStore;
import com.hazelcast.cp.internal.persistence.V55OnDiskRaftStateStore;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.log.LogEntry;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotEntry;
import com.hazelcast.cp.internal.raft.impl.persistence.LogFileStructure;
import com.hazelcast.cp.internal.raft.impl.persistence.RaftStateStore;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.version.Version;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VersionAwareOnDiskRaftStateStore
implements RaftStateStore {
    private final Supplier<Version> clusterVersionSupplier;
    private final V55OnDiskRaftStateStore v55Store;
    private boolean isChunkingStoreInitialized;
    private OnDiskRaftStateStore chunkingStore;

    public VersionAwareOnDiskRaftStateStore(File groupDir, InternalSerializationService serializationService, int maxUncommittedEntries, LogFileStructure logFileStructure, Supplier<Version> clusterVersionSupplier) {
        this.clusterVersionSupplier = clusterVersionSupplier;
        this.v55Store = new V55OnDiskRaftStateStore(groupDir, serializationService, maxUncommittedEntries, logFileStructure);
    }

    private void initializeChunkingStore() {
        this.chunkingStore = new OnDiskRaftStateStore(this.v55Store.getBaseDir(), this.v55Store.getSerializationService(), this.v55Store.getMaxUncommittedEntries(), this.v55Store.getLogFileStructure());
        File currentFile = this.v55Store.getCurrentFile();
        if (currentFile != null) {
            this.chunkingStore.setCurrentFile(currentFile);
            this.chunkingStore.setLogDataOut(this.v55Store.getLogDataOut());
            this.chunkingStore.setLogRaf(this.v55Store.getLogRaf());
        }
        this.chunkingStore.setNextEntryIndex(this.v55Store.getNextEntryIndex());
    }

    private RaftStateStore getActiveStore() {
        return this.isChunkingSupportedVersion() ? this.chunkingStore : this.v55Store;
    }

    @Override
    public boolean isChunkingSupportedVersion() {
        boolean chunkingSupported = this.clusterVersionSupplier.get().isGreaterOrEqual(ChunkUtil.MIN_CHUNKING_SUPPORTED_VERSION);
        if (chunkingSupported && !this.isChunkingStoreInitialized) {
            this.initializeChunkingStore();
            this.isChunkingStoreInitialized = true;
        }
        return chunkingSupported;
    }

    @Override
    public void open() throws IOException {
        this.getActiveStore().open();
    }

    @Override
    public void persistInitialMembers(@Nonnull RaftEndpoint localMember, @Nonnull Collection<RaftEndpoint> initialMembers) throws IOException {
        this.getActiveStore().persistInitialMembers(localMember, initialMembers);
    }

    @Override
    public void persistTerm(int term, @Nullable RaftEndpoint votedFor) throws IOException {
        this.getActiveStore().persistTerm(term, votedFor);
    }

    @Override
    public void persistEntry(@Nonnull LogEntry entry) throws IOException {
        this.getActiveStore().persistEntry(entry);
    }

    @Override
    public void persistSnapshotChunk(Object snapshotChunk) throws IOException {
        this.getActiveStore().persistSnapshotChunk(snapshotChunk);
    }

    @Override
    public void deleteSnapshotChunks(long snapshotIndex) throws IOException {
        this.getActiveStore().deleteSnapshotChunks(snapshotIndex);
    }

    @Override
    public void persistSnapshot(@Nonnull SnapshotEntry entry) throws IOException {
        this.getActiveStore().persistSnapshot(entry);
    }

    @Override
    public void deleteEntriesFrom(long startIndexInclusive) throws IOException {
        this.getActiveStore().deleteEntriesFrom(startIndexInclusive);
    }

    @Override
    public void flushLogs() throws IOException {
        this.getActiveStore().flushLogs();
    }

    @Override
    public void close() throws IOException {
        this.getActiveStore().close();
    }
}

