/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.snapshot;

import com.hazelcast.cp.internal.datastructures.snapshot.AbstractDataChunk;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class KeyValueDataChunk
extends AbstractDataChunk {
    private List<Data> keyValuePairs;

    public KeyValueDataChunk() {
        this.keyValuePairs = new ArrayList<Data>();
    }

    public KeyValueDataChunk(String name) {
        this(name, false);
    }

    public KeyValueDataChunk(String name, boolean destroyed) {
        super(name, destroyed);
        this.keyValuePairs = destroyed ? Collections.emptyList() : new ArrayList();
    }

    public List<Data> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public void addToChunk(Data key, Data value) {
        this.keyValuePairs.add(key);
        this.keyValuePairs.add(value);
        this.addToChunkSize(key.dataSize() + value.dataSize());
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    void writeDataInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.keyValuePairs.size());
        for (Data data : this.keyValuePairs) {
            IOUtil.writeData(out, data);
        }
    }

    @Override
    void readDataInternal(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.keyValuePairs = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data data = IOUtil.readData(in);
            this.keyValuePairs.add(data);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyValueDataChunk that = (KeyValueDataChunk)o;
        return Objects.equals(this.keyValuePairs, that.keyValuePairs);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.keyValuePairs);
        return result;
    }

    @Override
    public String toString() {
        return "KeyValueDataChunk{keyValuePairsSize=" + this.keyValuePairs.size() + "} " + super.toString();
    }
}

