/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.cpmap.store;

import com.hazelcast.cp.internal.datastructures.cpmap.CPMapDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.cpmap.store.CPMapStore;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public final class HeapCPMapStore
implements CPMapStore,
IdentifiedDataSerializable {
    public static final int LIMIT_MAX_CAPACITY_MB = 2000;
    private static final int BYTES_IN_MB = 1000000;
    private final Map<Data, Data> map;
    private int capacityInBytes;
    private final AtomicInteger usedDataBytes;
    private volatile int size;

    public HeapCPMapStore() {
        this(100);
    }

    public HeapCPMapStore(int capacityInMb) {
        if (capacityInMb < 1 || capacityInMb > 2000) {
            throw new IllegalArgumentException("'capacityInMb' must be within the range [1, 2000]MB");
        }
        this.map = new LinkedHashMap<Data, Data>();
        this.capacityInBytes = capacityInMb * 1000000;
        this.usedDataBytes = new AtomicInteger();
    }

    @Override
    public Iterator<Map.Entry<Data, Data>> iterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Data put(@Nonnull Data key, @Nonnull Data value) {
        this.checkWithinMaximumPermittedBytes(key, value);
        Data result = this.map.put(key, value);
        this.size = this.map.size();
        int unpublishedUsedDataBytes = this.usedDataBytes.get();
        if (result != null) {
            unpublishedUsedDataBytes -= HeapCPMapStore.keyValueSize(key, result);
        }
        this.usedDataBytes.set(unpublishedUsedDataBytes += HeapCPMapStore.keyValueSize(key, value));
        return result;
    }

    @Override
    public Data remove(@Nonnull Data key) {
        Data value = this.map.remove(key);
        if (value != null) {
            int unpublishedDataBytes = this.usedDataBytes.get();
            this.usedDataBytes.set(unpublishedDataBytes -= HeapCPMapStore.keyValueSize(key, value));
            this.size = this.map.size();
        }
        return value;
    }

    @Override
    public boolean compareAndSet(@Nonnull Data key, @Nonnull Data expectedValue, @Nonnull Data newValue) {
        Data observedValue = this.map.get(key);
        boolean updated = false;
        if (Objects.equals(observedValue, expectedValue)) {
            this.checkWithinMaximumPermittedBytes(key, newValue);
            this.map.put(key, newValue);
            int unpublishedUsedDataBytes = this.usedDataBytes.get();
            unpublishedUsedDataBytes -= HeapCPMapStore.keyValueSize(key, observedValue);
            this.usedDataBytes.set(unpublishedUsedDataBytes += HeapCPMapStore.keyValueSize(key, newValue));
            this.size = this.map.size();
            updated = true;
        }
        return updated;
    }

    @Override
    public Data get(@Nonnull Data key) {
        return this.map.get(key);
    }

    @Override
    public void collectMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        MetricDescriptor size = descriptor.copy().withMetric("size");
        context.collect(size, this.size());
        MetricDescriptor sizeBytes = descriptor.copy().withMetric("sizeBytes");
        context.collect(sizeBytes, this.usedDataBytes.get());
    }

    @Override
    public Data putIfAbsent(@Nonnull Data key, @Nonnull Data value) {
        Data currentValue = this.map.get(key);
        if (currentValue == null) {
            this.checkWithinMaximumPermittedBytes(key, value);
            this.map.put(key, value);
            this.usedDataBytes.addAndGet(HeapCPMapStore.keyValueSize(key, value));
            this.size = this.map.size();
        }
        return currentValue;
    }

    private void checkWithinMaximumPermittedBytes(Data key, Data value) {
        if (HeapCPMapStore.keyValueSize(key, value) + this.usedDataBytes.get() > this.capacityInBytes) {
            throw new IllegalStateException("Write not permitted as it would exceed the user defined capacity limit of " + this.capacityInBytes / 1000000 + "MB");
        }
    }

    private static int keyValueSize(Data key, Data value) {
        int keySize = key == null ? 0 : key.dataSize();
        int valueSize = value == null ? 0 : value.dataSize();
        return keySize + valueSize;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.capacityInBytes);
        out.writeInt(this.usedDataBytes.get());
        out.writeInt(this.size);
        for (Map.Entry<Data, Data> entry : this.map.entrySet()) {
            IOUtil.writeData(out, entry.getKey());
            IOUtil.writeData(out, entry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.capacityInBytes = in.readInt();
        this.usedDataBytes.set(in.readInt());
        int mapSize = in.readInt();
        for (int j = 0; j < mapSize; ++j) {
            Data key = IOUtil.readData(in);
            Data value = IOUtil.readData(in);
            this.map.put(key, value);
        }
        this.size = mapSize;
    }

    @Override
    public int getFactoryId() {
        return CPMapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 10;
    }

    int getUsedDataBytes() {
        return this.usedDataBytes.get();
    }
}

