/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.cpmap.client;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.cp.internal.client.AbstractCPMessageTask;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.license.domain.Feature;

public abstract class CPMapAbstractMessageTask<P>
extends AbstractCPMessageTask<P> {
    protected CPMapAbstractMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    public String getServiceName() {
        return "hz:raft:mapService";
    }

    @Override
    protected void processMessage() throws Throwable {
        this.checkClusterVersion();
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.nodeEngine.getNode().getNodeExtension();
        if (!nodeExtension.getLicense().getFeatures().contains(Feature.ADVANCED_CP)) {
            throw new UnsupportedOperationException("CPMap is not included in your license. Please also ensure you are using the enterprise client.");
        }
    }

    protected void checkClusterVersion() {
        if (this.nodeEngine.getClusterService().getClusterVersion().isUnknownOrLessThan(Versions.V5_4)) {
            throw new UnsupportedOperationException(String.format("CP Map is supported in version %s and above", Versions.V5_4));
        }
    }
}

