/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.cpmap;

import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftNodeLifecycleAwareService;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.cpmap.CPMapProxy;
import com.hazelcast.cp.internal.datastructures.cpmap.CPMapRegistry;
import com.hazelcast.cp.internal.datastructures.cpmap.CPMapRegistrySnapshot;
import com.hazelcast.cp.internal.datastructures.cpmap.store.CPMapStore;
import com.hazelcast.cp.internal.datastructures.snapshot.ChunkUtil;
import com.hazelcast.cp.internal.datastructures.snapshot.DataChunkGroup;
import com.hazelcast.cp.internal.datastructures.snapshot.KeyValueDataChunk;
import com.hazelcast.cp.internal.datastructures.spi.RaftManagedService;
import com.hazelcast.cp.internal.datastructures.spi.RaftRemoteService;
import com.hazelcast.cp.internal.raft.ChunkedSnapshotAwareService;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class CPMapService
implements RaftManagedService,
RaftRemoteService,
ChunkedSnapshotAwareService<KeyValueDataChunk, CPMapRegistrySnapshot>,
RaftNodeLifecycleAwareService,
DynamicMetricsProvider {
    public static final String SERVICE_NAME = "hz:raft:mapService";
    private final NodeEngine nodeEngine;
    private final ConcurrentMap<CPGroupId, CPMapRegistry> mapRegistries = new ConcurrentHashMap<CPGroupId, CPMapRegistry>();
    private final CPSubsystemConfig cpSubsystemConfig;
    private final long maxChunkSizeInBytes;
    private volatile RaftService raftService;

    public CPMapService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.cpSubsystemConfig = nodeEngine.getConfig().getCPSubsystemConfig();
        this.maxChunkSizeInBytes = ChunkUtil.getMaxChunkSizeInBytes(nodeEngine.getProperties());
    }

    public CPMapStore getOrInitMapStore(CPGroupId groupId, String objectName) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(objectName);
        return this.mapRegistries.computeIfAbsent(groupId, r -> new CPMapRegistry(groupId)).getMapStore(objectName, this.cpSubsystemConfig);
    }

    public Collection<String> listResourceNames(CPGroupId groupId, boolean tombstone) {
        CPMapRegistry cpMapRegistry = (CPMapRegistry)this.mapRegistries.get(groupId);
        if (cpMapRegistry == null) {
            return List.of();
        }
        if (tombstone) {
            return cpMapRegistry.getDestroyed();
        }
        return cpMapRegistry.getMapStores().keySet();
    }

    @Override
    public void onCPSubsystemRestart() {
        this.mapRegistries.clear();
    }

    public DistributedObject createProxy(String objectName) {
        RaftGroupId groupId = this.raftService.createRaftGroupForProxy(objectName);
        return new CPMapProxy(this.nodeEngine, groupId, objectName);
    }

    @Override
    public boolean destroyRaftObject(CPGroupId groupId, String objectName) {
        return this.mapRegistries.computeIfAbsent(groupId, r -> new CPMapRegistry(groupId)).destroyMapStore(objectName);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.raftService = (RaftService)nodeEngine.getService("hz:core:raft");
        if (nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES) && nodeEngine instanceof NodeEngineImpl) {
            NodeEngineImpl nodeEngineImpl = (NodeEngineImpl)nodeEngine;
            nodeEngineImpl.getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        this.mapRegistries.clear();
    }

    @Override
    public Iterator<DataChunkGroup<KeyValueDataChunk>> takeChunkedSnapshot(@Nonnull CPGroupId groupId, long commitIndex) {
        Preconditions.checkNotNull(groupId);
        assert (this.isChunkingSupportedVersion());
        CPMapRegistrySnapshot snapshot = this.takeSnapshot(groupId, commitIndex);
        return ChunkUtil.groupServiceChunksBySize(snapshot.toChunks(this.maxChunkSizeInBytes), this.maxChunkSizeInBytes).iterator();
    }

    private boolean isChunkingSupportedVersion() {
        return this.nodeEngine.getClusterService().getClusterVersion().isGreaterOrEqual(ChunkUtil.MIN_CHUNKING_SUPPORTED_VERSION);
    }

    @Override
    public void restoreChunkedSnapshot(@Nonnull CPGroupId groupId, long commitIndex, @Nonnull DataChunkGroup dataChunk) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(dataChunk);
        assert (this.isChunkingSupportedVersion());
        List cpMapDataList = dataChunk.getServiceData();
        for (KeyValueDataChunk cpMapData : cpMapDataList) {
            String cpMapName = cpMapData.getName();
            if (cpMapData.isDestroyed()) {
                this.destroyRaftObject(groupId, cpMapName);
                continue;
            }
            CPMapStore cpMapStore = this.getOrInitMapStore(groupId, cpMapName);
            List<Data> keyValuePairs = cpMapData.getKeyValuePairs();
            for (int i = 0; i < keyValuePairs.size(); i += 2) {
                Data key = keyValuePairs.get(i);
                Data value = keyValuePairs.get(i + 1);
                cpMapStore.put(key, value);
            }
        }
    }

    @Override
    public void resetForChunkedSnapshotRestore(@Nonnull CPGroupId groupId) {
        assert (this.raftService.isCpSubsystemEnabled()) : "no call is expected when cp is disable";
        Preconditions.checkNotNull(groupId);
        CPMapRegistry cpMapRegistry = (CPMapRegistry)this.mapRegistries.get(groupId);
        if (cpMapRegistry == null) {
            return;
        }
        cpMapRegistry.resetForChunkedSnapshotRestore();
    }

    @Override
    public CPMapRegistrySnapshot takeSnapshot(CPGroupId groupId, long commitIndex) {
        CPMapRegistry cpMapRegistry = (CPMapRegistry)this.mapRegistries.get(groupId);
        if (cpMapRegistry == null) {
            return new CPMapRegistrySnapshot();
        }
        return cpMapRegistry.takeSnapshot();
    }

    @Override
    public void restoreSnapshot(CPGroupId groupId, long commitIndex, CPMapRegistrySnapshot snapshot) {
        if (this.isChunkingSupportedVersion()) {
            throw new UnsupportedOperationException("No call to this method is expected since the chunked variant has been introduced");
        }
        this.v55restoreSnapshot(groupId, snapshot);
    }

    private void v55restoreSnapshot(CPGroupId groupId, CPMapRegistrySnapshot snapshot) {
        if (!snapshot.isEmpty()) {
            CPMapRegistry cpMapRegistry = new CPMapRegistry(groupId);
            cpMapRegistry.v55restoreCPMapRegistrySnapshot(snapshot);
            this.mapRegistries.put(groupId, cpMapRegistry);
        }
    }

    @Override
    public void onRaftNodeTerminated(CPGroupId groupId) {
        this.mapRegistries.remove(groupId);
    }

    @Override
    public void onRaftNodeSteppedDown(CPGroupId groupId) {
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        MetricDescriptor root = descriptor.withPrefix("cp.map");
        for (CPMapRegistry cpMapRegistry : this.mapRegistries.values()) {
            cpMapRegistry.collectMetrics(root, context);
        }
        CPMapService.addSummaryMetrics(root, context, this.mapRegistries);
    }

    static void addSummaryMetrics(MetricDescriptor descriptor, MetricsCollectionContext context, Map<CPGroupId, CPMapRegistry> mapRegistries) {
        MetricDescriptor destroyed = descriptor.withPrefix("cp.map.summary");
        for (CPMapRegistry cpMapRegistry : mapRegistries.values()) {
            MetricDescriptor destroyedCount = destroyed.copy().withDiscriminator("group", cpMapRegistry.getGroupName()).withMetric("destroyed.count");
            context.collect(destroyedCount, cpMapRegistry.getDestroyed().size());
            MetricDescriptor liveCount = destroyed.copy().withDiscriminator("group", cpMapRegistry.getGroupName()).withMetric("live.count");
            context.collect(liveCount, cpMapRegistry.getMapStores().size());
        }
    }
}

