/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.cp.CPGroup;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPGroupsSnapshot;
import com.hazelcast.cp.CPMap;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.CPObjectInfo;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.IAtomicReference;
import com.hazelcast.cp.ICountDownLatch;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.event.CPGroupAvailabilityListener;
import com.hazelcast.cp.event.CPMembershipListener;
import com.hazelcast.cp.exception.NotLeaderException;
import com.hazelcast.cp.internal.CPObjectInfoImpl;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.spi.RaftRemoteService;
import com.hazelcast.cp.internal.datastructures.spi.atomic.RaftAtomicValueService;
import com.hazelcast.cp.internal.datastructures.spi.blocking.AbstractBlockingService;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.cp.session.CPSessionManagementService;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.license.domain.Feature;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class CPSubsystemImpl
implements CPSubsystem {
    public static final String CPMAP_LICENSE_MESSAGE = "CPMap is not included in your license. Please also ensure you are using the enterprise client.";
    protected final boolean cpSubsystemEnabled;
    protected final NodeEngine nodeEngine;
    private volatile CPSubsystemManagementService cpSubsystemManagementService;

    public CPSubsystemImpl(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        int cpMemberCount = nodeEngine.getConfig().getCPSubsystemConfig().getCPMemberCount();
        this.cpSubsystemEnabled = cpMemberCount > 0;
        ILogger logger = nodeEngine.getLogger(CPSubsystem.class);
        if (this.cpSubsystemEnabled) {
            logger.info("CP Subsystem is enabled with " + cpMemberCount + " members.");
        } else {
            logger.warning("CP Subsystem is not enabled. CP data structures will operate in UNSAFE mode! Please note that UNSAFE mode will not provide strong consistency guarantees.");
        }
    }

    @Override
    @Nonnull
    public IAtomicLong getAtomicLong(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an atomic long instance with a null name is not allowed!");
        return (IAtomicLong)this.createProxy("hz:raft:atomicLongService", name);
    }

    @Override
    @Nonnull
    public <E> IAtomicReference<E> getAtomicReference(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an atomic reference instance with a null name is not allowed!");
        return (IAtomicReference)this.createProxy("hz:raft:atomicRefService", name);
    }

    @Override
    @Nonnull
    public ICountDownLatch getCountDownLatch(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a count down latch instance with a null name is not allowed!");
        return (ICountDownLatch)this.createProxy("hz:raft:countDownLatchService", name);
    }

    @Override
    @Nonnull
    public FencedLock getLock(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an fenced lock instance with a null name is not allowed!");
        return (FencedLock)this.createProxy("hz:raft:lockService", name);
    }

    @Override
    @Nonnull
    public ISemaphore getSemaphore(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a semaphore instance with a null name is not allowed!");
        return (ISemaphore)this.createProxy("hz:raft:semaphoreService", name);
    }

    @Override
    public CPMember getLocalCPMember() {
        return this.getCPSubsystemManagementService().getLocalCPMember();
    }

    @Override
    public CPSubsystemManagementService getCPSubsystemManagementService() {
        if (!this.cpSubsystemEnabled) {
            throw new HazelcastException("CP Subsystem is not enabled!");
        }
        if (this.cpSubsystemManagementService != null) {
            return this.cpSubsystemManagementService;
        }
        RaftService raftService = (RaftService)this.getService("hz:core:raft");
        this.cpSubsystemManagementService = new CPSubsystemManagementServiceImpl(raftService, this.nodeEngine);
        return this.cpSubsystemManagementService;
    }

    @Override
    public CPSessionManagementService getCPSessionManagementService() {
        if (!this.cpSubsystemEnabled) {
            throw new HazelcastException("CP Subsystem is not enabled!");
        }
        return (CPSessionManagementService)this.getService("hz:core:raftSession");
    }

    private <T> T getService(@Nonnull String serviceName) {
        return this.nodeEngine.getService(serviceName);
    }

    protected <T extends DistributedObject> T createProxy(String serviceName, String name) {
        RaftRemoteService service = (RaftRemoteService)this.getService(serviceName);
        return service.createProxy(name);
    }

    @Override
    public UUID addMembershipListener(CPMembershipListener listener) {
        RaftService raftService = (RaftService)this.getService("hz:core:raft");
        return raftService.registerMembershipListener(listener);
    }

    @Override
    public boolean removeMembershipListener(UUID id) {
        RaftService raftService = (RaftService)this.getService("hz:core:raft");
        return raftService.removeMembershipListener(id);
    }

    @Override
    public UUID addGroupAvailabilityListener(CPGroupAvailabilityListener listener) {
        RaftService raftService = (RaftService)this.getService("hz:core:raft");
        return raftService.registerAvailabilityListener(listener);
    }

    @Override
    public boolean removeGroupAvailabilityListener(UUID id) {
        RaftService raftService = (RaftService)this.getService("hz:core:raft");
        return raftService.removeAvailabilityListener(id);
    }

    @Override
    @Nonnull
    public <K, V> CPMap<K, V> getMap(@Nonnull String name) {
        throw new UnsupportedOperationException(CPMAP_LICENSE_MESSAGE);
    }

    @Override
    @Nonnull
    public Collection<CPGroupId> getCPGroupIds() {
        try {
            return this.getCPSubsystemManagementService().getCPGroupIds().toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HazelcastException("Could not retrieve CP group ids", e);
        }
    }

    @Override
    @Nonnull
    public Iterable<CPObjectInfo> getObjectInfos(@Nonnull CPGroupId groupId, @Nonnull String serviceName) {
        return this.getCPObjectInfos(groupId, serviceName, false);
    }

    @Override
    @Nonnull
    public Iterable<CPObjectInfo> getTombstoneInfos(@Nonnull CPGroupId groupId, @Nonnull String serviceName) {
        return this.getCPObjectInfos(groupId, serviceName, true);
    }

    private Iterable<CPObjectInfo> getCPObjectInfos(CPGroupId groupId, String serviceName, boolean returnTombstone) {
        RaftService raftService = (RaftService)this.getService("hz:core:raft");
        try {
            Collection<String> names = raftService.getObjectNames(groupId, serviceName, returnTombstone).get();
            return CPSubsystemImpl.toObjectInfos(names, serviceName, groupId);
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof NotLeaderException) {
                throw (NotLeaderException)e.getCause();
            }
            if (e.getCause() instanceof TargetNotMemberException) {
                throw new NotLeaderException(groupId, raftService.getLocalCPEndpoint(), null);
            }
            throw new HazelcastException(e);
        }
    }

    private static Iterable<CPObjectInfo> toObjectInfos(Collection<String> names, String serviceName, CPGroupId groupId) {
        return names.stream().map(name -> new CPObjectInfoImpl((String)name, serviceName, groupId)).collect(Collectors.toList());
    }

    public Collection<String> getCPObjectNames(CPGroupId groupId, String serviceName, boolean returnTombstone) {
        return switch (serviceName) {
            case "hz:raft:lockService", "hz:raft:semaphoreService", "hz:raft:countDownLatchService" -> ((AbstractBlockingService)this.nodeEngine.getService(serviceName)).listResourceNames(groupId, returnTombstone);
            case "hz:raft:atomicLongService", "hz:raft:atomicRefService" -> {
                RaftAtomicValueService service = (RaftAtomicValueService)this.nodeEngine.getService(serviceName);
                yield service.listResourceNames(groupId, returnTombstone);
            }
            case "hz:raft:mapService" -> throw new UnsupportedOperationException(CPMAP_LICENSE_MESSAGE);
            default -> throw new IllegalArgumentException("Calling getCPObjectInfo is not supported for " + serviceName);
        };
    }

    protected <K, V> CPMap<K, V> getCpmap(@Nonnull String name) {
        return this.getMap(name);
    }

    private static class CPSubsystemManagementServiceImpl
    implements CPSubsystemManagementService {
        private final RaftService raftService;
        private final boolean provideSnapshots;

        CPSubsystemManagementServiceImpl(RaftService raftService, NodeEngine nodeEngine) {
            this.raftService = raftService;
            EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)nodeEngine.getNode().getNodeExtension();
            this.provideSnapshots = nodeExtension.getLicense().getFeatures().contains(Feature.ADVANCED_CP);
        }

        @Override
        public CPMember getLocalCPMember() {
            return this.raftService.getLocalCPMember();
        }

        public InternalCompletableFuture<Collection<CPGroupId>> getCPGroupIds() {
            return this.raftService.getCPGroupIds();
        }

        public InternalCompletableFuture<CPGroup> getCPGroup(String name) {
            return this.raftService.getCPGroup(name);
        }

        public InternalCompletableFuture<Void> forceDestroyCPGroup(String groupName) {
            return this.raftService.forceDestroyCPGroup(groupName);
        }

        public InternalCompletableFuture<Collection<CPMember>> getCPMembers() {
            return this.raftService.getCPMembers();
        }

        public InternalCompletableFuture<Void> promoteToCPMember() {
            return this.raftService.promoteToCPMember();
        }

        public InternalCompletableFuture<Void> removeCPMember(UUID cpMemberUuid) {
            return this.raftService.removeCPMember(cpMemberUuid);
        }

        public InternalCompletableFuture<Void> reset() {
            return this.raftService.resetCPSubsystem();
        }

        @Override
        public boolean isDiscoveryCompleted() {
            return this.raftService.isDiscoveryCompleted();
        }

        @Override
        public boolean awaitUntilDiscoveryCompleted(long timeout, TimeUnit timeUnit) throws InterruptedException {
            return this.raftService.awaitUntilDiscoveryCompleted(timeout, timeUnit);
        }

        @Override
        public CPGroupsSnapshot getCurrentGroupsSnapshot() {
            if (this.provideSnapshots) {
                return this.raftService.getGroupViewTracker().createSnapshotView(true);
            }
            return CPGroupsSnapshot.EMPTY;
        }
    }
}

