/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.vector;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.SplitBrainPolicyAwareConfig;
import com.hazelcast.config.UserCodeNamespaceAwareConfig;
import com.hazelcast.config.vector.VectorIndexConfig;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.annotation.Beta;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@Beta
public class VectorCollectionConfig
implements NamedConfig,
IdentifiedDataSerializable,
Versioned,
SplitBrainPolicyAwareConfig,
UserCodeNamespaceAwareConfig<VectorCollectionConfig> {
    public static final int MIN_BACKUP_COUNT = 0;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    public static final int MAX_BACKUP_COUNT = 6;
    private String name;
    private int backupCount = 1;
    private int asyncBackupCount = 0;
    private final List<VectorIndexConfig> vectorIndexConfigs = new ArrayList<VectorIndexConfig>();
    private String splitBrainProtectionName;
    private MergePolicyConfig mergePolicyConfig = new MergePolicyConfig();
    @Nullable
    private String userCodeNamespace = DEFAULT_NAMESPACE;

    public VectorCollectionConfig() {
    }

    public VectorCollectionConfig(String name) {
        this.name = name;
    }

    public VectorCollectionConfig(VectorCollectionConfig config) {
        Objects.requireNonNull(config, "config must not be null.");
        this.name = config.getName();
        this.backupCount = config.getBackupCount();
        this.asyncBackupCount = config.getAsyncBackupCount();
        this.splitBrainProtectionName = config.getSplitBrainProtectionName();
        this.mergePolicyConfig = config.getMergePolicyConfig();
        this.userCodeNamespace = config.getUserCodeNamespace();
        this.setVectorIndexConfigs(config.getVectorIndexConfigs());
    }

    @Override
    public VectorCollectionConfig setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public VectorCollectionConfig addVectorIndexConfig(final VectorIndexConfig vectorIndexConfig) {
        Objects.requireNonNull(vectorIndexConfig, "vector index config must not be null.");
        this.validateIndexConfig((List<VectorIndexConfig>)new ArrayList<VectorIndexConfig>(this.vectorIndexConfigs){
            {
                super(c);
                this.add(vectorIndexConfig);
            }
        });
        this.vectorIndexConfigs.add(vectorIndexConfig);
        return this;
    }

    public List<VectorIndexConfig> getVectorIndexConfigs() {
        return this.vectorIndexConfigs;
    }

    public void setVectorIndexConfigs(List<VectorIndexConfig> vectorIndexConfigs) {
        this.validateIndexConfig(vectorIndexConfigs);
        this.vectorIndexConfigs.clear();
        this.vectorIndexConfigs.addAll(vectorIndexConfigs);
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public VectorCollectionConfig setBackupCount(int backupCount) {
        this.backupCount = Preconditions.checkBackupCount(backupCount, this.asyncBackupCount);
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public VectorCollectionConfig setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = Preconditions.checkAsyncBackupCount(this.backupCount, asyncBackupCount);
        return this;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    @Override
    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    @Override
    public VectorCollectionConfig setSplitBrainProtectionName(@Nullable String splitBrainProtectionName) {
        this.splitBrainProtectionName = splitBrainProtectionName;
        return this;
    }

    @Override
    public MergePolicyConfig getMergePolicyConfig() {
        return this.mergePolicyConfig;
    }

    @Override
    public VectorCollectionConfig setMergePolicyConfig(MergePolicyConfig mergePolicyConfig) {
        this.mergePolicyConfig = Preconditions.checkNotNull(mergePolicyConfig, "mergePolicyConfig cannot be null");
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_6)) {
            out.writeInt(this.backupCount);
            out.writeInt(this.asyncBackupCount);
            out.writeString(this.splitBrainProtectionName);
            out.writeObject(this.mergePolicyConfig);
            out.writeObject(this.userCodeNamespace);
        }
        SerializationUtil.writeList(this.vectorIndexConfigs, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.vectorIndexConfigs.clear();
        this.name = in.readString();
        if (in.getVersion().isGreaterOrEqual(Versions.V5_6)) {
            this.backupCount = in.readInt();
            this.asyncBackupCount = in.readInt();
            this.splitBrainProtectionName = in.readString();
            this.mergePolicyConfig = (MergePolicyConfig)in.readObject();
            this.userCodeNamespace = (String)in.readObject();
        } else {
            this.backupCount = 0;
            this.asyncBackupCount = 0;
        }
        List deserialized = SerializationUtil.readList(in);
        this.vectorIndexConfigs.addAll(deserialized);
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 72;
    }

    public String toString() {
        return "VectorCollectionConfig{name='" + this.name + "', backupCount=" + this.backupCount + ", asyncBackupCount=" + this.asyncBackupCount + ", splitBrainProtectionName=" + this.splitBrainProtectionName + ", mergePolicyConfig=" + String.valueOf(this.mergePolicyConfig) + ", userCodeNamespace=" + this.userCodeNamespace + ", vectorIndexConfigs=" + String.valueOf(this.vectorIndexConfigs) + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VectorCollectionConfig that = (VectorCollectionConfig)object;
        return Objects.equals(this.name, that.name) && Objects.equals(this.backupCount, that.backupCount) && Objects.equals(this.asyncBackupCount, that.asyncBackupCount) && Objects.equals(this.splitBrainProtectionName, that.splitBrainProtectionName) && Objects.equals(this.mergePolicyConfig, that.mergePolicyConfig) && Objects.equals(this.userCodeNamespace, that.userCodeNamespace) && Objects.equals(this.vectorIndexConfigs, that.vectorIndexConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.backupCount, this.asyncBackupCount, this.splitBrainProtectionName, this.mergePolicyConfig, this.userCodeNamespace, this.vectorIndexConfigs);
    }

    private void validateIndexConfig(List<VectorIndexConfig> newIndexConfig) {
        HashSet<String> seenNames = new HashSet<String>();
        for (VectorIndexConfig index2 : newIndexConfig) {
            if (seenNames.add(index2.getName())) continue;
            throw new InvalidConfigurationException("The vector index configuration contains multiple indexes with the same name: " + index2.getName());
        }
        if (newIndexConfig.size() > 1 && newIndexConfig.stream().anyMatch(index -> index.getName() == null)) {
            throw new InvalidConfigurationException("Vector collection cannot contain both named and unnamed index");
        }
    }

    @Override
    @Nullable
    public String getUserCodeNamespace() {
        return this.userCodeNamespace;
    }

    @Override
    public VectorCollectionConfig setUserCodeNamespace(@Nullable String userCodeNamespace) {
        this.userCodeNamespace = userCodeNamespace;
        return this;
    }
}

