/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.rest;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.properties.ClusterProperty;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;

public class RestConfig {
    private static final int DEFAULT_PORT = 8443;
    private static final int DEFAULT_DURATION_MINUTES = 15;
    private static final Duration DEFAULT_DURATION = Duration.of(15L, ChronoUnit.MINUTES);
    private static final Duration DEFAULT_TIMEOUT_SECONDS = Duration.ofSeconds(TimeUnit.MILLISECONDS.toSeconds(Long.parseLong(ClusterProperty.OPERATION_CALL_TIMEOUT_MILLIS.getDefaultValue())));
    private static final int DEFAULT_MAX_LOGIN_ATTEMPTS = 5;
    private Duration requestTimeoutDuration = DEFAULT_TIMEOUT_SECONDS;
    private boolean enabled;
    private int port = 8443;
    private String securityRealm;
    private Duration tokenValidityDuration = DEFAULT_DURATION;
    private Duration lockoutDuration = DEFAULT_DURATION;
    private int maxLoginAttempts = 5;
    private Ssl ssl = new Ssl();

    public Duration getRequestTimeoutDuration() {
        return this.requestTimeoutDuration;
    }

    public void setRequestTimeoutDuration(Duration requestTimeoutDuration) {
        this.requestTimeoutDuration = Preconditions.checkNotNegative(requestTimeoutDuration, "requestTimeoutDuration cannot be negative.");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public RestConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RestConfig setPort(int port) {
        this.port = port;
        return this;
    }

    public String getSecurityRealm() {
        return this.securityRealm;
    }

    public RestConfig setSecurityRealm(String securityRealm) {
        this.securityRealm = securityRealm;
        return this;
    }

    public Duration getTokenValidityDuration() {
        return this.tokenValidityDuration;
    }

    public RestConfig setTokenValidityDuration(Duration tokenValidityDuration) {
        this.tokenValidityDuration = Preconditions.checkNotNegative(tokenValidityDuration, "tokenValidityDuration cannot be negative.");
        return this;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public RestConfig setSsl(Ssl ssl) {
        this.ssl = ssl;
        return this;
    }

    public Duration getLockoutDuration() {
        return this.lockoutDuration;
    }

    public RestConfig setLockoutDuration(Duration lockoutDuration) {
        Preconditions.checkNotNegative(lockoutDuration, "lockoutDuration cannot be negative.");
        this.lockoutDuration = lockoutDuration;
        return this;
    }

    public int getMaxLoginAttempts() {
        return this.maxLoginAttempts;
    }

    public RestConfig setMaxLoginAttempts(int maxLoginAttempts) {
        if (maxLoginAttempts < 0) {
            throw new IllegalArgumentException("maxLoginAttempts cannot be negative.");
        }
        this.maxLoginAttempts = maxLoginAttempts;
        return this;
    }

    public String toString() {
        return "RestConfig{enabled=" + this.enabled + ", port=" + this.port + ", securityRealm='" + this.securityRealm + "', tokenValidityDuration=" + String.valueOf(this.tokenValidityDuration) + ", ssl=" + String.valueOf(this.ssl) + ",, maxLoginAttempts=" + this.maxLoginAttempts + ", lockoutDuration=" + String.valueOf(this.lockoutDuration) + ", requestTimeoutDuration=" + String.valueOf(this.requestTimeoutDuration) + "}";
    }

    public static class Ssl {
        private boolean enabled;
        private ClientAuth clientAuth = ClientAuth.NONE;
        private String ciphers;
        private String enabledProtocols;
        private String keyAlias;
        private String keyPassword;
        private String keyStore;
        private String keyStorePassword;
        private String keyStoreType;
        private String keyStoreProvider;
        private String trustStore;
        private String trustStorePassword;
        private String trustStoreType;
        private String trustStoreProvider;
        private String certificate;
        private String certificatePrivateKey;
        private String trustCertificate;
        private String trustCertificatePrivateKey;
        private String protocol = "TLS";

        public boolean isEnabled() {
            return this.enabled;
        }

        public Ssl setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public ClientAuth getClientAuth() {
            return this.clientAuth;
        }

        public Ssl setClientAuth(ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
            return this;
        }

        public String getCiphers() {
            return this.ciphers;
        }

        public Ssl setCiphers(String ciphers) {
            this.ciphers = ciphers;
            return this;
        }

        public String getEnabledProtocols() {
            return this.enabledProtocols;
        }

        public Ssl setEnabledProtocols(String enabledProtocols) {
            this.enabledProtocols = enabledProtocols;
            return this;
        }

        public String getKeyAlias() {
            return this.keyAlias;
        }

        public Ssl setKeyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            return this;
        }

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public Ssl setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        public String getKeyStore() {
            return this.keyStore;
        }

        public Ssl setKeyStore(String keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public Ssl setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public Ssl setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public String getKeyStoreProvider() {
            return this.keyStoreProvider;
        }

        public Ssl setKeyStoreProvider(String keyStoreProvider) {
            this.keyStoreProvider = keyStoreProvider;
            return this;
        }

        public String getTrustStore() {
            return this.trustStore;
        }

        public Ssl setTrustStore(String trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public Ssl setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public String getTrustStoreType() {
            return this.trustStoreType;
        }

        public Ssl setTrustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public String getTrustStoreProvider() {
            return this.trustStoreProvider;
        }

        public Ssl setTrustStoreProvider(String trustStoreProvider) {
            this.trustStoreProvider = trustStoreProvider;
            return this;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public Ssl setCertificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public String getCertificatePrivateKey() {
            return this.certificatePrivateKey;
        }

        public Ssl setCertificatePrivateKey(String certificatePrivateKey) {
            this.certificatePrivateKey = certificatePrivateKey;
            return this;
        }

        public String getTrustCertificate() {
            return this.trustCertificate;
        }

        public Ssl setTrustCertificate(String trustCertificate) {
            this.trustCertificate = trustCertificate;
            return this;
        }

        public String getTrustCertificatePrivateKey() {
            return this.trustCertificatePrivateKey;
        }

        public Ssl setTrustCertificatePrivateKey(String trustCertificatePrivateKey) {
            this.trustCertificatePrivateKey = trustCertificatePrivateKey;
            return this;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public Ssl setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public String toString() {
            return "Ssl{enabled=" + this.enabled + ", clientAuth=" + String.valueOf((Object)this.clientAuth) + ", ciphers=" + this.ciphers + ", enabledProtocols=" + this.enabledProtocols + ", keyAlias='" + this.keyAlias + "', keyPassword='" + this.keyPassword + "', keyStore='" + this.keyStore + "', keyStorePassword='" + this.keyStorePassword + "', keyStoreType='" + this.keyStoreType + "', keyStoreProvider='" + this.keyStoreProvider + "', trustStore='" + this.trustStore + "', trustStorePassword='" + this.trustStorePassword + "', trustStoreType='" + this.trustStoreType + "', trustStoreProvider='" + this.trustStoreProvider + "', certificate='" + this.certificate + "', certificatePrivateKey='" + this.certificatePrivateKey + "', trustCertificate='" + this.trustCertificate + "', trustCertificatePrivateKey='" + this.trustCertificatePrivateKey + "', protocol='" + this.protocol + "'}";
        }

        public static enum ClientAuth {
            NONE,
            WANT,
            NEED;

        }
    }
}

