/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.ProbabilisticSplitBrainProtectionConfigBuilder;
import com.hazelcast.config.RecentlyActiveSplitBrainProtectionConfigBuilder;
import com.hazelcast.config.SplitBrainProtectionListenerConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionFunction;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionOn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SplitBrainProtectionConfig
implements IdentifiedDataSerializable,
NamedConfig {
    private String name;
    private boolean enabled;
    private int minimumClusterSize = 2;
    private List<SplitBrainProtectionListenerConfig> listenerConfigs = new ArrayList<SplitBrainProtectionListenerConfig>();
    private SplitBrainProtectionOn protectOn = SplitBrainProtectionOn.READ_WRITE;
    private String functionClassName;
    private SplitBrainProtectionFunction functionImplementation;

    public SplitBrainProtectionConfig() {
    }

    public SplitBrainProtectionConfig(String name) {
        this.name = name;
    }

    public SplitBrainProtectionConfig(String name, boolean enabled) {
        this.name = name;
        this.enabled = enabled;
    }

    public SplitBrainProtectionConfig(String name, boolean enabled, int minimumClusterSize) {
        this.name = name;
        this.enabled = enabled;
        this.minimumClusterSize = minimumClusterSize;
    }

    public SplitBrainProtectionConfig(SplitBrainProtectionConfig splitBrainProtectionConfig) {
        this.name = splitBrainProtectionConfig.name;
        this.enabled = splitBrainProtectionConfig.enabled;
        this.minimumClusterSize = splitBrainProtectionConfig.minimumClusterSize;
        this.listenerConfigs = splitBrainProtectionConfig.listenerConfigs;
        this.protectOn = splitBrainProtectionConfig.protectOn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SplitBrainProtectionConfig setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SplitBrainProtectionConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public int getMinimumClusterSize() {
        return this.minimumClusterSize;
    }

    public SplitBrainProtectionConfig setMinimumClusterSize(int minimumClusterSize) {
        if (minimumClusterSize < 2) {
            throw new InvalidConfigurationException("Minimum cluster size configured for split-brain protection cannot be less than 2");
        }
        this.minimumClusterSize = minimumClusterSize;
        return this;
    }

    public SplitBrainProtectionOn getProtectOn() {
        return this.protectOn;
    }

    public SplitBrainProtectionConfig setProtectOn(SplitBrainProtectionOn protectOn) {
        this.protectOn = protectOn;
        return this;
    }

    public List<SplitBrainProtectionListenerConfig> getListenerConfigs() {
        return this.listenerConfigs;
    }

    public SplitBrainProtectionConfig setListenerConfigs(List<SplitBrainProtectionListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
        return this;
    }

    public SplitBrainProtectionConfig addListenerConfig(SplitBrainProtectionListenerConfig listenerConfig) {
        this.listenerConfigs.add(listenerConfig);
        return this;
    }

    public String getFunctionClassName() {
        return this.functionClassName;
    }

    public SplitBrainProtectionConfig setFunctionClassName(String functionClassName) {
        this.functionClassName = functionClassName;
        return this;
    }

    public SplitBrainProtectionFunction getFunctionImplementation() {
        return this.functionImplementation;
    }

    public SplitBrainProtectionConfig setFunctionImplementation(SplitBrainProtectionFunction functionImplementation) {
        this.functionImplementation = functionImplementation;
        return this;
    }

    public String toString() {
        return "SplitBrainProtectionConfig{name='" + this.name + "', enabled=" + this.enabled + ", minimumClusterSize=" + this.minimumClusterSize + ", listenerConfigs=" + String.valueOf(this.listenerConfigs) + ", functionClassName=" + this.functionClassName + ", functionImplementation=" + String.valueOf(this.functionImplementation) + ", protectOn=" + String.valueOf((Object)this.protectOn) + "}";
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 41;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.minimumClusterSize);
        SerializationUtil.writeNullableList(this.listenerConfigs, out);
        out.writeString(this.protectOn.name());
        out.writeString(this.functionClassName);
        out.writeObject(this.functionImplementation);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.enabled = in.readBoolean();
        this.minimumClusterSize = in.readInt();
        this.listenerConfigs = SerializationUtil.readNullableList(in);
        this.protectOn = SplitBrainProtectionOn.valueOf(in.readString());
        this.functionClassName = in.readString();
        this.functionImplementation = (SplitBrainProtectionFunction)in.readObject();
    }

    public static ProbabilisticSplitBrainProtectionConfigBuilder newProbabilisticSplitBrainProtectionConfigBuilder(String name, int minimumClusterSize) {
        return new ProbabilisticSplitBrainProtectionConfigBuilder(name, minimumClusterSize);
    }

    public static RecentlyActiveSplitBrainProtectionConfigBuilder newRecentlyActiveSplitBrainProtectionConfigBuilder(String name, int minimumClusterSize, int toleranceMillis) {
        return new RecentlyActiveSplitBrainProtectionConfigBuilder(name, minimumClusterSize, toleranceMillis);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitBrainProtectionConfig that = (SplitBrainProtectionConfig)o;
        return this.enabled == that.enabled && this.minimumClusterSize == that.minimumClusterSize && Objects.equals(this.name, that.name) && Objects.equals(this.listenerConfigs, that.listenerConfigs) && this.protectOn == that.protectOn && Objects.equals(this.functionClassName, that.functionClassName) && Objects.equals(this.functionImplementation, that.functionImplementation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.enabled, this.minimumClusterSize, this.listenerConfigs, this.protectOn, this.functionClassName, this.functionImplementation});
    }
}

