/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi;

import com.hazelcast.client.config.ClusterRoutingConfig;
import com.hazelcast.client.config.RoutingMode;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.SubsetMembers;
import com.hazelcast.client.impl.clientside.SubsetMembersImpl;
import com.hazelcast.client.impl.clientside.SubsetMembersView;
import com.hazelcast.client.impl.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.impl.spi.impl.MemberListSnapshot;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.nio.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;

public class EnterpriseClientClusterServiceImpl
extends ClientClusterServiceImpl {
    private final SubsetMembers subsetMembers;
    private final ClusterRoutingConfig clusterRoutingConfig;

    public EnterpriseClientClusterServiceImpl(HazelcastClientInstanceImpl client) {
        super(client);
        this.clusterRoutingConfig = client.getClientConfig().getNetworkConfig().getClusterRoutingConfig();
        this.subsetMembers = this.clusterRoutingConfig.getRoutingMode() == RoutingMode.MULTI_MEMBER ? new SubsetMembersImpl(client, this.clusterRoutingConfig, client.getLoggingService()) : SubsetMembers.NOOP;
    }

    @Override
    public void onClusterConnect(UUID newClusterId) {
        UUID oldClusterId = this.clusterId;
        this.clusterId = newClusterId;
        this.subsetMembers.onClusterConnect(oldClusterId, newClusterId);
    }

    @Override
    @Nonnull
    public Collection<Member> getEffectiveMemberList() {
        MemberListSnapshot snapshot = (MemberListSnapshot)this.memberListSnapshot.get();
        if (snapshot.version() == -1) {
            return Collections.emptyList();
        }
        if (this.clientInstance.getConnectionManager().getRoutingMode() == RoutingMode.SINGLE_MEMBER) {
            UUID activeConnection = this.clientInstance.getConnectionManager().getActiveConnections().stream().findFirst().map(Connection::getRemoteUuid).orElse(null);
            if (activeConnection == null || !snapshot.members().containsKey(activeConnection)) {
                return Collections.emptyList();
            }
            return Collections.singletonList(snapshot.members().get(activeConnection));
        }
        if (this.clusterRoutingConfig.getRoutingMode() != RoutingMode.MULTI_MEMBER) {
            return snapshot.members().values();
        }
        switch (this.clusterRoutingConfig.getRoutingStrategy()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case PARTITION_GROUPS: 
        }
        return this.toMemberListFromMemberGroup(snapshot);
    }

    protected List<Member> toMemberListFromMemberGroup(MemberListSnapshot snapshot) {
        SubsetMembersView subsetMembersView = this.subsetMembers.getSubsetMembersView();
        if (subsetMembersView == null) {
            return Collections.emptyList();
        }
        Set<UUID> uuids = subsetMembersView.members();
        ArrayList<Member> members = new ArrayList<Member>(uuids.size());
        for (UUID uuid : uuids) {
            Member member = snapshot.members().get(uuid);
            if (member == null) continue;
            members.add(member);
        }
        return members;
    }

    @Override
    public void updateOnAuth(UUID clusterUuid, UUID authMemberUuid, Map<String, String> keyValuePairs) {
        this.subsetMembers.updateOnAuth(clusterUuid, authMemberUuid, keyValuePairs);
        super.updateOnAuth(clusterUuid, authMemberUuid, keyValuePairs);
    }

    @Override
    public SubsetMembers getSubsetMembers() {
        return this.subsetMembers;
    }

    public ClusterRoutingConfig getClusterRoutingConfig() {
        return this.clusterRoutingConfig;
    }
}

