/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapExecuteWithPredicateCodec;
import com.hazelcast.client.impl.protocol.task.AbstractMultiPartitionMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MapExecuteWithPredicateMessageTask
extends AbstractMultiPartitionMessageTask<MapExecuteWithPredicateCodec.RequestParameters> {
    private Predicate predicate;

    public MapExecuteWithPredicateMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void beforeProcess() {
        this.predicate = (Predicate)this.serializationService.toObject(((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).predicate);
    }

    @Override
    public PartitionIdSet getPartitions() {
        Predicate predicate = this.predicate;
        if (predicate instanceof PartitionPredicate) {
            PartitionPredicate partitionPredicate = (PartitionPredicate)predicate;
            return this.clientEngine.getPartitionService().getPartitionIdSet(partitionPredicate.getPartitionKeys());
        }
        IPartition[] partitions = this.clientEngine.getPartitionService().getPartitions();
        ArrayList<Integer> partitionsList = new ArrayList<Integer>(partitions.length);
        Arrays.stream(partitions).forEach(partition -> partitionsList.add(partition.getPartitionId()));
        return new PartitionIdSet(partitions.length, partitionsList);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        Predicate targetPredicate = this.predicate;
        Predicate predicate = this.predicate;
        if (predicate instanceof PartitionPredicate) {
            PartitionPredicate partitionPredicate = (PartitionPredicate)predicate;
            targetPredicate = partitionPredicate.getTarget();
        }
        return this.createOperationFactory(targetPredicate);
    }

    private OperationFactory createOperationFactory(Predicate predicate) {
        MapOperationProvider operationProvider = this.getOperationProvider(((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).name);
        EntryProcessor entryProcessor = (EntryProcessor)this.serializationService.toObject(((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).entryProcessor);
        return operationProvider.createPartitionWideEntryWithPredicateOperationFactory(((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).name, entryProcessor, predicate);
    }

    private MapOperationProvider getOperationProvider(String mapName) {
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        return mapServiceContext.getMapOperationProvider(mapName);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        ArrayList<Map.Entry<Data, Data>> dataMap = new ArrayList<Map.Entry<Data, Data>>();
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        for (Object o : map.values()) {
            if (o == null) continue;
            MapEntries mapEntries = (MapEntries)mapService.getMapServiceContext().toObject(o);
            mapEntries.putAllToList(dataMap);
        }
        return dataMap;
    }

    @Override
    protected MapExecuteWithPredicateCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapExecuteWithPredicateCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapExecuteWithPredicateCodec.encodeResponse((List)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).name, "put", "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "executeOnEntries";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).entryProcessor, ((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).predicate};
    }

    @Override
    protected String getUserCodeNamespace() {
        return MapService.lookupNamespace(this.nodeEngine, this.getDistributedObjectName());
    }
}

