/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.AbstractListenerService;
import com.hazelcast.client.impl.CPGroupViewListenerService;
import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddCPGroupViewListenerCodec;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPGroupsSnapshot;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftGroupInfo;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class CPGroupViewListenerServiceImpl
extends AbstractListenerService
implements CPGroupViewListenerService {
    private final AtomicLong clientUpdatesVersion = new AtomicLong(-1L);

    CPGroupViewListenerServiceImpl(NodeEngineImpl nodeEngine) {
        super(nodeEngine, nodeEngine.getLogger(CPGroupViewListenerService.class), "hz:cpSubsystem");
        this.logger.info("Clients with cp-direct-to-leader-routing enabled will now receive CP leadership information");
    }

    @Override
    protected void pushView() {
        CPGroupsSnapshot snapshot = this.getCPMembershipSnapshot();
        this.logger.finest("Sending new snapshot to all listening clients: %s", snapshot);
        this.sendToListeningEndpoints(this.getMembershipViewMessage(this.clientUpdatesVersion.incrementAndGet(), snapshot));
    }

    @Override
    public void onGroupViewChange() {
        this.pushView();
    }

    @Override
    protected void sendUpdate(ClientEndpoint clientEndpoint, Connection connection, long correlationId) {
        CPGroupsSnapshot snapshot = this.getCPMembershipSnapshot();
        this.logger.finest("Sending new snapshot to specific client %s: %s", clientEndpoint, snapshot);
        ClientMessage memberListViewMessage = this.getMembershipViewMessage(this.clientUpdatesVersion.incrementAndGet(), snapshot);
        memberListViewMessage.setCorrelationId(correlationId);
        this.write(memberListViewMessage, connection);
    }

    private CPGroupsSnapshot getCPMembershipSnapshot() {
        return this.nodeEngine.getHazelcastInstance().getCPSubsystem().getCPSubsystemManagementService().getCurrentGroupsSnapshot();
    }

    private ClientMessage getMembershipViewMessage(long version, CPGroupsSnapshot snapshot) {
        Map<CPGroupId, CPGroupsSnapshot.GroupInfo> allGroupInfo = snapshot.getAllGroupInformation();
        ArrayList<RaftGroupInfo> processed = new ArrayList<RaftGroupInfo>(allGroupInfo.size());
        Map<UUID, UUID> cpToApUuids = snapshot.getCpToApUuids();
        for (Map.Entry<CPGroupId, CPGroupsSnapshot.GroupInfo> entry : allGroupInfo.entrySet()) {
            CPGroupId groupId = entry.getKey();
            CPGroupsSnapshot.GroupInfo groupInfo = entry.getValue();
            processed.add(new RaftGroupInfo((RaftGroupId)groupId, groupInfo.leader(), groupInfo.followers()));
        }
        List<Map.Entry<UUID, UUID>> finalUuids = cpToApUuids.entrySet().stream().toList();
        return ClientAddCPGroupViewListenerCodec.encodeGroupsViewEvent(version, processed, finalUuids);
    }
}

