/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.operation.BackupAwareKeyBasedHiDensityCacheOperation;
import com.hazelcast.cache.impl.hidensity.operation.CacheRemoveBackupOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;

public class CacheRemoveOperation
extends BackupAwareKeyBasedHiDensityCacheOperation
implements MutableOperation,
MutatingOperation {
    private Data currentValue;

    public CacheRemoveOperation() {
    }

    public CacheRemoveOperation(String name, Data key, Data currentValue) {
        super(name, key);
        this.currentValue = currentValue;
    }

    @Override
    protected void runInternal() {
        this.response = this.currentValue == null ? Boolean.valueOf(this.recordStore.remove(this.key, this.getCallerUuid(), null, this.completionId)) : Boolean.valueOf(this.recordStore.remove(this.key, this.currentValue, this.getCallerUuid(), null, this.completionId));
    }

    @Override
    public void afterRun() throws Exception {
        if (Boolean.TRUE.equals(this.response)) {
            this.publishWanRemove(this.key);
        }
        super.afterRun();
        this.dispose();
    }

    @Override
    protected void disposeInternal(EnterpriseSerializationService serializationService) {
        serializationService.disposeData(this.key);
        if (this.currentValue != null) {
            serializationService.disposeData(this.currentValue);
        }
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new CacheRemoveBackupOperation(this.name, this.key);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeData(out, this.currentValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.currentValue = CacheRemoveOperation.readNativeMemoryOperationData(in);
    }

    @Override
    public int getClassId() {
        return 4;
    }
}

