/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.operation.KeyBasedHiDensityCacheOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;

public class CacheRemoveBackupOperation
extends KeyBasedHiDensityCacheOperation
implements BackupOperation,
MutableOperation {
    private boolean wanOriginated;

    public CacheRemoveBackupOperation() {
    }

    public CacheRemoveBackupOperation(String name, Data key) {
        super(name, key, true);
    }

    public CacheRemoveBackupOperation(String name, Data key, boolean wanOriginated) {
        this(name, key);
        this.wanOriginated = wanOriginated;
    }

    @Override
    public void runInternal() {
        this.response = this.recordStore != null ? this.recordStore.removeRecord(this.key) : Boolean.FALSE;
    }

    @Override
    public void afterRun() throws Exception {
        if (!Boolean.FALSE.equals(this.response) && !this.wanOriginated) {
            this.publishWanRemove(this.key);
        }
        super.afterRun();
        this.dispose();
    }

    @Override
    protected void disposeInternal(EnterpriseSerializationService serializationService) {
        serializationService.disposeData(this.key);
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.wanOriginated);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.wanOriginated = in.readBoolean();
    }
}

