/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class CacheMergeBackupOperation
extends HiDensityCacheOperation
implements BackupOperation,
MutableOperation {
    private List dataCacheRecordPairs;
    private BitSet noWanReplicationKeys;
    private transient int lastIndex;

    public CacheMergeBackupOperation() {
    }

    public CacheMergeBackupOperation(String cacheNameWithPrefix, List dataCacheRecordPairs, BitSet noWanReplicationKeys) {
        super(cacheNameWithPrefix);
        this.dataCacheRecordPairs = dataCacheRecordPairs;
        this.noWanReplicationKeys = noWanReplicationKeys;
    }

    @Override
    protected void runInternal() {
        if (this.recordStore == null) {
            return;
        }
        if (this.dataCacheRecordPairs != null) {
            for (int i = this.lastIndex; i < this.dataCacheRecordPairs.size(); i += 2) {
                boolean nonReplicatedKey;
                Data key = (Data)this.dataCacheRecordPairs.get(i);
                CacheRecord record = (CacheRecord)this.dataCacheRecordPairs.get(i + 1);
                this.recordStore.putRecord(key, record, true);
                boolean bl = nonReplicatedKey = this.noWanReplicationKeys != null && this.noWanReplicationKeys.get(i / 2);
                if (!nonReplicatedKey) {
                    this.publishWanUpdate(key, record);
                }
                this.lastIndex = i;
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.dataCacheRecordPairs != null);
        if (this.dataCacheRecordPairs != null) {
            out.writeInt(this.dataCacheRecordPairs.size() / 2);
            for (int i = 0; i < this.dataCacheRecordPairs.size(); i += 2) {
                Data dataKey = (Data)this.dataCacheRecordPairs.get(i);
                CacheRecord record = (CacheRecord)this.dataCacheRecordPairs.get(i + 1);
                IOUtil.writeData(out, dataKey);
                out.writeObject(record);
            }
            if (out.getVersion().isGreaterOrEqual(Versions.V5_4)) {
                if (this.noWanReplicationKeys == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeByteArray(this.noWanReplicationKeys.toByteArray());
                }
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        boolean recordNotNull = in.readBoolean();
        if (recordNotNull) {
            int size = in.readInt();
            this.dataCacheRecordPairs = new ArrayList(size * 2);
            for (int i = 0; i < size; ++i) {
                Data key = IOUtil.readData(in);
                CacheRecord record = (CacheRecord)in.readObject();
                this.dataCacheRecordPairs.add(key);
                this.dataCacheRecordPairs.add(record);
            }
            if (in.getVersion().isGreaterOrEqual(Versions.V5_4) && in.readBoolean()) {
                this.noWanReplicationKeys = BitSet.valueOf(in.readByteArray());
            }
        }
    }

    @Override
    public int getClassId() {
        return 25;
    }
}

