/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.nativememory;

import com.hazelcast.cache.impl.EnterpriseCacheService;
import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheRecord;
import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheRecordMap;
import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheRecordStore;
import com.hazelcast.cache.impl.hidensity.nativememory.HotRestartHiDensityNativeMemoryCacheRecordMap;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hotrestart.HotRestartStore;
import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.KeyHandleOffHeap;
import com.hazelcast.internal.hotrestart.RamStore;
import com.hazelcast.internal.hotrestart.RamStoreHelper;
import com.hazelcast.internal.hotrestart.RecordDataSink;
import com.hazelcast.internal.hotrestart.impl.KeyOffHeap;
import com.hazelcast.internal.hotrestart.impl.SetOfKeyHandle;
import com.hazelcast.internal.hotrestart.impl.SimpleHandleOffHeap;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.Iterator;
import java.util.UUID;

public class HotRestartHiDensityNativeMemoryCacheRecordStore
extends HiDensityNativeMemoryCacheRecordStore
implements RamStore {
    private static final boolean ASSERTION_ENABLED = HotRestartHiDensityNativeMemoryCacheRecordStore.class.desiredAssertionStatus();
    private final long prefix;
    private final boolean fsync;
    private final HotRestartStore hotRestartStore;
    private final Object mutex;

    public HotRestartHiDensityNativeMemoryCacheRecordStore(int partitionId, String cacheNameWithPrefix, EnterpriseCacheService cacheService, NodeEngine nodeEngine, boolean fsync, long keyPrefix) {
        super(partitionId, cacheNameWithPrefix, cacheService, nodeEngine);
        this.fsync = fsync;
        this.prefix = keyPrefix;
        this.hotRestartStore = cacheService.offHeapHotRestartStoreForPartition(partitionId);
        assert (this.hotRestartStore != null);
        HotRestartHiDensityNativeMemoryCacheRecordMap recordMap = (HotRestartHiDensityNativeMemoryCacheRecordMap)this.records;
        this.mutex = recordMap.getMutex();
        this.initMap(recordMap);
    }

    private void initMap(HotRestartHiDensityNativeMemoryCacheRecordMap recordMap) {
        recordMap.setPrefix(this.prefix);
        recordMap.setHotRestartStore(this.hotRestartStore);
        recordMap.setFsync(this.fsync);
    }

    @Override
    protected HiDensityNativeMemoryCacheRecordMap createMapInternal(int capacity) {
        return new HotRestartHiDensityNativeMemoryCacheRecordMap(capacity, this.cacheRecordProcessor, this.cacheInfo, this.serializationService);
    }

    @Override
    long newSequence() {
        return this.memoryManager.newSequence();
    }

    @Override
    protected HiDensityNativeMemoryCacheRecord doPutRecord(Data key, HiDensityNativeMemoryCacheRecord record, UUID source, boolean updateJournal) {
        HiDensityNativeMemoryCacheRecord oldRecord = super.doPutRecord(key, record, source, updateJournal);
        this.putToHotRestart(key, record);
        return oldRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateRecordValue(HiDensityNativeMemoryCacheRecord record, Object recordValue) {
        Object object = this.mutex;
        synchronized (object) {
            record.setValue((NativeMemoryData)recordValue);
        }
    }

    @Override
    protected void onUpdateRecord(Data key, HiDensityNativeMemoryCacheRecord record, Object value, Data oldDataValue) {
        super.onUpdateRecord(key, record, value, oldDataValue);
        this.putToHotRestart(key, record);
    }

    @Override
    public CacheRecord removeRecord(Data key) {
        this.lookupAndRemoveFromHotRestart(key);
        return super.removeRecord(key);
    }

    @Override
    protected HiDensityNativeMemoryCacheRecord doRemoveRecord(Data key, UUID source) {
        this.lookupAndRemoveFromHotRestart(key);
        return (HiDensityNativeMemoryCacheRecord)super.doRemoveRecord(key, source);
    }

    private void lookupAndRemoveFromHotRestart(Data key) {
        HiDensityNativeMemoryCacheRecord record = (HiDensityNativeMemoryCacheRecord)((HiDensityNativeMemoryCacheRecordMap)this.records).get(key);
        if (this.isMemoryBlockValid(record)) {
            this.removeFromHotRestart(key, record);
        }
    }

    @Override
    protected void onOwn(Data key, Object value, long ttlMillis, HiDensityNativeMemoryCacheRecord record, NativeMemoryData oldValueData, boolean isNewPut, boolean disableDeferredDispose) {
        this.putToHotRestart(key, record);
        super.onOwn(key, value, ttlMillis, record, oldValueData, isNewPut, disableDeferredDispose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeDeferredBlocks() {
        Object object = this.mutex;
        synchronized (object) {
            super.disposeDeferredBlocks();
        }
    }

    private void putToHotRestart(Data key, HiDensityNativeMemoryCacheRecord record) {
        NativeMemoryData value = record.getValue();
        assert (value != null) : "Value should not be null! -> " + String.valueOf(record);
        byte[] valueBytes = value.toByteArray();
        this.hotRestartStore.put(this.newHotRestartKey(key, record), valueBytes, this.fsync);
    }

    private void removeFromHotRestart(Data key, HiDensityNativeMemoryCacheRecord record) {
        KeyOffHeap hotRestartKey = this.newHotRestartKey(key, record);
        this.hotRestartStore.remove(hotRestartKey, this.fsync);
    }

    private KeyOffHeap newHotRestartKey(Data key, HiDensityNativeMemoryCacheRecord record) {
        long keyAddress = ((HiDensityNativeMemoryCacheRecordMap)this.records).getNativeKeyAddress(key);
        assert (keyAddress != 0L) : "Invalid key address!";
        assert (record.address() != 0L);
        assert (record.getValueAddress() != 0L);
        return new KeyOffHeap(this.prefix, key.toByteArray(), keyAddress, record.getSequence());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyEntry(KeyHandle keyHandle, int expectedSize, RecordDataSink sink) {
        KeyHandleOffHeap kh = (KeyHandleOffHeap)keyHandle;
        assert (kh.address() != 0L);
        Object object = this.mutex;
        synchronized (object) {
            NativeMemoryData key = RamStoreHelper.validateAndGetKey(kh, this.memoryManager);
            if (key == null) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var5_5
            HiDensityNativeMemoryCacheRecord record = (HiDensityNativeMemoryCacheRecord)((HiDensityNativeMemoryCacheRecordMap)this.records).getIfSameKey(key);
            return record != null && RamStoreHelper.copyEntry(kh, key, record, expectedSize, sink);
        }
    }

    @Override
    public KeyHandleOffHeap toKeyHandle(byte[] keyBytes) {
        assert (keyBytes != null && keyBytes.length > 0);
        HeapData heapKey = new HeapData(keyBytes);
        long nativeKeyAddress = ((HiDensityNativeMemoryCacheRecordMap)this.records).getNativeKeyAddress(heapKey);
        if (nativeKeyAddress != 0L) {
            return this.readExistingKeyHandle(nativeKeyAddress);
        }
        return this.newKeyHandle(heapKey);
    }

    @Override
    public void accept(KeyHandle kh, byte[] valueBytes) {
        assert (kh != null) : "accept() called with null KeyHandle";
        assert (valueBytes != null && valueBytes.length > 0) : "accept() called with null/empty value";
        KeyHandleOffHeap ohk = (KeyHandleOffHeap)kh;
        HiDensityNativeMemoryCacheRecord record = (HiDensityNativeMemoryCacheRecord)((HiDensityNativeMemoryCacheRecordMap)this.records).get(new NativeMemoryData().reset(ohk.address()));
        assert (record != null) : "accept() caled with unknown key";
        assert (ohk.sequenceId() == record.getSequence()) : String.format("Sequence ID of the supplied keyHandle (%d) doesn't match the one in RamStore (%d)", ohk.sequenceId(), record.getSequence());
        this.acceptNewValue(record, new HeapData(valueBytes));
    }

    @Override
    public void removeNullEntries(SetOfKeyHandle keyHandles) {
        SetOfKeyHandle.KhCursor cursor = keyHandles.cursor();
        NativeMemoryData key = new NativeMemoryData();
        while (cursor.advance()) {
            KeyHandleOffHeap keyHandle = (KeyHandleOffHeap)cursor.asKeyHandle();
            key.reset(keyHandle.address());
            HiDensityNativeMemoryCacheRecord record = (HiDensityNativeMemoryCacheRecord)((HiDensityNativeMemoryCacheRecordMap)this.records).remove(key);
            assert (record != null);
            assert (record.getValueAddress() == 0L);
            assert (record.getSequence() == keyHandle.sequenceId());
            this.cacheRecordProcessor.dispose(record);
            this.cacheRecordProcessor.disposeData(key);
        }
        if (ASSERTION_ENABLED) {
            this.scanEmptyRecords();
        }
    }

    @Override
    public void reset() {
        this.resetInternal(true);
    }

    private void resetInternal(boolean clearHotRestartStore) {
        if (clearHotRestartStore) {
            this.hotRestartStore.clear(this.fsync, this.prefix);
        }
        super.reset();
    }

    @Override
    public void close(boolean onShutdown) {
        if (this.shouldExplicitlyClear(onShutdown)) {
            this.resetInternal(false);
        }
        this.destroyEventJournal();
        ((HiDensityNativeMemoryCacheRecordMap)this.records).dispose();
        this.closeListeners();
    }

    private KeyHandleOffHeap readExistingKeyHandle(long nativeKeyAddress) {
        NativeMemoryData key = new NativeMemoryData().reset(nativeKeyAddress);
        HiDensityNativeMemoryCacheRecord record = (HiDensityNativeMemoryCacheRecord)((HiDensityNativeMemoryCacheRecordMap)this.records).get(key);
        assert (record != null);
        return new SimpleHandleOffHeap(key.address(), record.getSequence());
    }

    private KeyHandleOffHeap newKeyHandle(HeapData heapKey) {
        HiDensityRecordProcessor<HiDensityNativeMemoryCacheRecord> recordProcessor = this.getRecordProcessor();
        NativeMemoryData nativeKey = (NativeMemoryData)recordProcessor.convertData(heapKey, DataType.NATIVE);
        long recordSequence = this.newSequence();
        this.acceptNewRecord(nativeKey, recordSequence);
        return new SimpleHandleOffHeap(nativeKey.address(), recordSequence);
    }

    private void acceptNewRecord(NativeMemoryData key, long recordSequence) {
        HiDensityRecordProcessor<HiDensityNativeMemoryCacheRecord> recordProcessor = this.getRecordProcessor();
        HiDensityNativeMemoryCacheRecord record = null;
        try {
            record = this.createRecordInternal(null, Clock.currentTimeMillis(), Long.MAX_VALUE, recordSequence);
            boolean isNewRecord = ((HiDensityNativeMemoryCacheRecordMap)this.records).set((Data)key, record);
            assert (isNewRecord);
        }
        catch (NativeOutOfMemoryError e) {
            recordProcessor.disposeData(key);
            if (record != null) {
                recordProcessor.dispose(record);
            }
            throw e;
        }
    }

    private void acceptNewValue(HiDensityNativeMemoryCacheRecord record, HeapData value) {
        HiDensityRecordProcessor<HiDensityNativeMemoryCacheRecord> recordProcessor = this.getRecordProcessor();
        NativeMemoryData nativeValue = (NativeMemoryData)recordProcessor.convertData(value, DataType.NATIVE);
        recordProcessor.disposeValue(record);
        record.setValue(nativeValue);
    }

    private void scanEmptyRecords() {
        Iterator iter2 = ((HiDensityNativeMemoryCacheRecordMap)this.records).valueIter();
        while (iter2.hasNext()) {
            HiDensityNativeMemoryCacheRecord record = (HiDensityNativeMemoryCacheRecord)iter2.next();
            assert (record != null);
            assert (record.getValueAddress() != 0L);
        }
    }
}

